/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.ComplexTypeFunctionDescriptor;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class ArrayFlattenFunction
extends SqlScalarFunction {
    public static final ArrayFlattenFunction ARRAY_FLATTEN_FUNCTION = new ArrayFlattenFunction();
    private static final String FUNCTION_NAME = "flatten";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayFlattenFunction.class, "flatten", Type.class, Type.class, Block.class);
    private final ComplexTypeFunctionDescriptor descriptor = new ComplexTypeFunctionDescriptor(false, (List)ImmutableList.of(), Optional.of(ImmutableSet.of((Object)0)), Optional.of(ComplexTypeFunctionDescriptor::prependAllSubscripts), this.getSignature());

    private ArrayFlattenFunction() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)FUNCTION_NAME), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"E")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(E)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(array(E))")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "Flattens the given array";
    }

    @Override
    public ComplexTypeFunctionDescriptor getComplexTypeFunctionDescriptor() {
        return this.descriptor;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type elementType = boundVariables.getTypeVariable("E");
        Type arrayType = functionAndTypeManager.getParameterizedType("array", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(elementType).bindTo(arrayType);
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    public static Block flatten(Type type, Type arrayType, Block array) {
        if (array.getPositionCount() == 0) {
            return type.createBlockBuilder(null, 0).build();
        }
        BlockBuilder builder = type.createBlockBuilder(null, array.getPositionCount(), Math.toIntExact(array.getSizeInBytes() / (long)array.getPositionCount()));
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) continue;
            Block subArray = (Block)arrayType.getObject(array, i);
            for (int j = 0; j < subArray.getPositionCount(); ++j) {
                type.appendTo(subArray, j, builder);
            }
        }
        return builder.build();
    }
}

