/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.PageBuilderStatus;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.Optional;

@Description(value="Returns n-element combinations from array")
@ScalarFunction(value="combinations")
public final class ArrayCombinationsFunction {
    private static final int MAX_COMBINATION_LENGTH = 5;
    private static final int MAX_RESULT_ELEMENTS = 100000;

    private ArrayCombinationsFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="array(array(T))")
    public static Block combinations(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block array, @SqlType(value="integer") long n) {
        int arrayLength = array.getPositionCount();
        int combinationLength = StrictMath.toIntExact(n);
        Failures.checkCondition(combinationLength >= 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "combination size must not be negative: %s", combinationLength);
        Failures.checkCondition(combinationLength <= 5, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "combination size must not exceed %s: %s", 5, combinationLength);
        ArrayType arrayType = new ArrayType(elementType);
        if (combinationLength > arrayLength) {
            return arrayType.createBlockBuilder(new PageBuilderStatus().createBlockBuilderStatus(), 0).build();
        }
        int combinationCount = ArrayCombinationsFunction.combinationCount(arrayLength, combinationLength);
        Failures.checkCondition((long)combinationCount * (long)combinationLength <= 100000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "combinations exceed max size", new Object[0]);
        int[] ids = new int[combinationCount * combinationLength];
        int idsPosition = 0;
        int[] combination = ArrayCombinationsFunction.firstCombination(combinationLength);
        do {
            System.arraycopy(combination, 0, ids, idsPosition, combinationLength);
            idsPosition += combinationLength;
        } while (ArrayCombinationsFunction.nextCombination(combination, arrayLength));
        Verify.verify((idsPosition == ids.length ? 1 : 0) != 0, (String)"idsPosition != ids.length, %s and %s respectively", (int)idsPosition, (int)ids.length);
        int[] offsets = new int[combinationCount + 1];
        Arrays.setAll(offsets, i -> i * combinationLength);
        return ArrayBlock.fromElementBlock((int)combinationCount, Optional.empty(), (int[])offsets, (Block)new DictionaryBlock(array, ids));
    }

    @VisibleForTesting
    static int combinationCount(int arrayLength, int combinationLength) {
        try {
            int combinations = 1;
            for (int i = 1; i <= combinationLength; ++i) {
                combinations = Math.multiplyExact(combinations, arrayLength - combinationLength + i) / i;
            }
            return combinations;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Number of combinations too large for array of size %s and combination length %s", arrayLength, combinationLength));
        }
    }

    private static int[] firstCombination(int combinationLength) {
        int[] combination = new int[combinationLength];
        Arrays.setAll(combination, i -> i);
        return combination;
    }

    private static boolean nextCombination(int[] combination, int arrayLength) {
        for (int i = 0; i < combination.length - 1; ++i) {
            if (combination[i] + 1 >= combination[i + 1]) continue;
            int n = i;
            combination[n] = combination[n] + 1;
            ArrayCombinationsFunction.resetCombination(combination, i);
            return true;
        }
        if (combination.length > 0 && combination[combination.length - 1] + 1 < arrayLength) {
            int n = combination.length - 1;
            combination[n] = combination[n] + 1;
            ArrayCombinationsFunction.resetCombination(combination, combination.length - 1);
            return true;
        }
        return false;
    }

    private static void resetCombination(int[] combination, int to) {
        for (int i = 0; i < to; ++i) {
            combination[i] = i;
        }
    }
}

