/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SliceOutput;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class RowBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    private static final String NAME = "ROW";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlockEncodingBuffer.class).instanceSize();
    private byte[] offsetsBuffer;
    private int offsetsBufferIndex;
    private int estimatedOffsetBufferMaxCapacity;
    private int[] offsets;
    private int lastOffset;
    private final AbstractBlockEncodingBuffer[] fieldBuffers;

    public RowBlockEncodingBuffer(DecodedBlockNode decodedBlockNode, ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
        List<DecodedBlockNode> childrenNodes = decodedBlockNode.getChildren();
        this.fieldBuffers = new AbstractBlockEncodingBuffer[childrenNodes.size()];
        for (int i = 0; i < childrenNodes.size(); ++i) {
            this.fieldBuffers[i] = (AbstractBlockEncodingBuffer)RowBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(i), bufferAllocator, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        int i = 0;
        while (i < this.positionCount) {
            int n = i++;
            serializedRowSizes[n] = serializedRowSizes[n] + 5;
        }
        int[] offsetsCopy = Arrays.ensureCapacity(null, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            for (int i2 = 0; i2 < this.fieldBuffers.length; ++i2) {
                System.arraycopy(this.offsets, 0, offsetsCopy, 0, this.positionCount + 1);
                this.fieldBuffers[i2].accumulateSerializedRowSizes(offsetsCopy, this.positionCount, serializedRowSizes);
            }
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    @Override
    public void setNextBatch(int positionsOffset, int batchSize) {
        this.positionsOffset = positionsOffset;
        this.batchSize = batchSize;
        this.flushed = false;
        if (this.positionCount == 0) {
            return;
        }
        int offset = this.offsets[positionsOffset];
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].setNextBatch(offset, this.offsets[positionsOffset + batchSize] - offset);
        }
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendNulls();
        this.appendOffsets();
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].appendDataInBatch();
        }
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        RowBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.fieldBuffers.length);
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].serializeTo(output);
        }
        output.writeInt(this.bufferedPositionCount);
        output.writeInt(0);
        if (this.offsetsBufferIndex > 0) {
            output.appendBytes(this.offsetsBuffer, 0, this.offsetsBufferIndex);
        }
        this.serializeNullsTo(output);
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.offsetsBufferIndex = 0;
        this.lastOffset = 0;
        this.flushed = true;
        this.resetNullsBuffer();
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].resetBuffers();
        }
    }

    @Override
    public void noMoreBatches() {
        for (int i = this.fieldBuffers.length - 1; i >= 0; --i) {
            this.fieldBuffers[i].noMoreBatches();
        }
        if (this.flushed && this.offsetsBuffer != null) {
            this.bufferAllocator.returnArray(this.offsetsBuffer);
            this.offsetsBuffer = null;
        }
        super.noMoreBatches();
        if (this.offsets != null) {
            this.bufferAllocator.returnArray(this.offsets);
            this.offsets = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        int size = INSTANCE_SIZE;
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            size = (int)((long)size + this.fieldBuffers[i].getRetainedSizeInBytes());
        }
        return size;
    }

    @Override
    public long getSerializedSizeInBytes() {
        int size = 0;
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            size = (int)((long)size + this.fieldBuffers[i].getSerializedSizeInBytes());
        }
        return (long)(NAME.length() + 4 + 4 + size + 4 + 4 + this.offsetsBufferIndex) + this.getNullsBufferSerializedSizeInBytes();
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("estimatedOffsetBufferMaxCapacity", this.estimatedOffsetBufferMaxCapacity).add("offsetsBufferCapacity", this.offsetsBuffer == null ? 0 : this.offsetsBuffer.length).add("offsetsBufferIndex", this.offsetsBufferIndex).add("offsetsCapacity", this.offsets == null ? 0 : this.offsets.length).add("lastOffset", this.lastOffset);
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            stringHelper.add("fieldBuffer_" + i, (Object)this.fieldBuffers[i]);
        }
        return stringHelper.toString();
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode, int partitionBufferCapacity, double decodedBlockPageSizeFraction) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        decodedBlockNode = this.mapPositionsToNestedBlock(decodedBlockNode);
        ColumnarRow columnarRow = (ColumnarRow)decodedBlockNode.getDecodedBlock();
        this.decodedBlock = columnarRow.getNullCheckBlock();
        this.populateNestedPositions(columnarRow);
        long estimatedSerializedSizeInBytes = decodedBlockNode.getEstimatedSerializedSizeInBytes();
        long childrenEstimatedSerializedSizeInBytes = 0L;
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            DecodedBlockNode childDecodedBlockNode = decodedBlockNode.getChildren().get(i);
            long childEstimatedSerializedSizeInBytes = childDecodedBlockNode.getEstimatedSerializedSizeInBytes();
            childrenEstimatedSerializedSizeInBytes += childEstimatedSerializedSizeInBytes;
            this.fieldBuffers[i].setupDecodedBlockAndMapPositions(childDecodedBlockNode, partitionBufferCapacity, decodedBlockPageSizeFraction * (double)childEstimatedSerializedSizeInBytes / (double)estimatedSerializedSizeInBytes);
        }
        double targetBufferSize = (double)partitionBufferCapacity * decodedBlockPageSizeFraction * (double)(estimatedSerializedSizeInBytes - childrenEstimatedSerializedSizeInBytes) / (double)estimatedSerializedSizeInBytes;
        this.setEstimatedNullsBufferMaxCapacity(RowBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 1, 5));
        this.estimatedOffsetBufferMaxCapacity = RowBlockEncodingBuffer.getEstimatedBufferMaxCapacity(targetBufferSize, 4, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        if (this.positionCount == 0) {
            return;
        }
        int lastOffset = positionOffsets[0];
        for (int i = 0; i < positionCount; ++i) {
            int offset = positionOffsets[i + 1];
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + 5 * (offset - lastOffset);
            lastOffset = offset;
            positionOffsets[i + 1] = this.offsets[offset];
        }
        int[] offsetsCopy = Arrays.ensureCapacity(null, (int)(positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            for (int i = 0; i < this.fieldBuffers.length; ++i) {
                System.arraycopy(positionOffsets, 0, offsetsCopy, 0, positionCount + 1);
                this.fieldBuffers[i].accumulateSerializedRowSizes(offsetsCopy, positionCount, serializedRowSizes);
            }
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    @Override
    int getEstimatedValueBufferMaxCapacity() {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    int getEstimatedOffsetBufferMaxCapacity() {
        return this.estimatedOffsetBufferMaxCapacity;
    }

    @VisibleForTesting
    BlockEncodingBuffer[] getFieldBuffers() {
        return this.fieldBuffers;
    }

    private void populateNestedPositions(ColumnarRow columnarRow) {
        int i;
        for (int i2 = 0; i2 < this.fieldBuffers.length; ++i2) {
            this.fieldBuffers[i2].resetPositions();
        }
        if (this.positionCount == 0) {
            return;
        }
        this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        this.offsets[0] = 0;
        int[] positions = this.getPositions();
        int columnarRowBaseOffset = columnarRow.getOffset(0);
        for (i = 0; i < this.positionCount; ++i) {
            int position = positions[i];
            this.offsets[i + 1] = this.offsets[i] + columnarRow.getOffset(position + 1) - columnarRow.getOffset(position);
        }
        for (int j = 0; j < this.fieldBuffers.length; ++j) {
            this.fieldBuffers[j].ensurePositionsCapacity(this.offsets[this.positionCount]);
        }
        for (i = 0; i < this.positionCount; ++i) {
            int beginOffset = columnarRow.getOffset(positions[i]);
            int currentRowSize = this.offsets[i + 1] - this.offsets[i];
            if (currentRowSize <= 0) continue;
            for (int j = 0; j < this.fieldBuffers.length; ++j) {
                this.fieldBuffers[j].appendPositionRange(beginOffset - columnarRowBaseOffset, currentRowSize);
            }
        }
    }

    private void appendOffsets() {
        this.offsetsBuffer = Arrays.ensureCapacity((byte[])this.offsetsBuffer, (int)(this.offsetsBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (int)this.estimatedOffsetBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int baseOffset = this.lastOffset - this.offsets[this.positionsOffset];
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            this.offsetsBufferIndex = UncheckedByteArrays.setIntUnchecked(this.offsetsBuffer, this.offsetsBufferIndex, this.offsets[i + 1] + baseOffset);
        }
        this.lastOffset = this.offsets[this.positionsOffset + this.batchSize] + baseOffset;
    }
}

