/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.common.Page;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class InputChannels {
    private final int[] inputChannels;

    public InputChannels(int ... inputChannels) {
        this.inputChannels = (int[])inputChannels.clone();
    }

    public InputChannels(List<Integer> inputChannels) {
        this.inputChannels = inputChannels.stream().mapToInt(Integer::intValue).toArray();
    }

    public int size() {
        return this.inputChannels.length;
    }

    public List<Integer> getInputChannels() {
        return Collections.unmodifiableList(Ints.asList((int[])this.inputChannels));
    }

    public Page getInputChannels(Page page) {
        return page.extractChannels(this.inputChannels);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)Arrays.toString(this.inputChannels)).toString();
    }
}

