/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class TuplePageFilter
implements PageFilter {
    private final Page tuplePage;
    private final InputChannels inputChannels;
    private final List<Type> types;
    private boolean[] selectedPositions = new boolean[0];

    public TuplePageFilter(Page tuplePage, List<Type> types, List<Integer> inputChannels) {
        Objects.requireNonNull(tuplePage, "tuplePage is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(inputChannels, "inputChannels is null");
        Preconditions.checkArgument((tuplePage.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"tuplePage should only have one position");
        Preconditions.checkArgument((tuplePage.getChannelCount() == inputChannels.size() ? 1 : 0) != 0, (Object)"tuplePage and inputChannels have different number of channels");
        Preconditions.checkArgument((types.size() == inputChannels.size() ? 1 : 0) != 0, (Object)"types and inputChannels have different number of channels");
        this.tuplePage = tuplePage;
        this.types = ImmutableList.copyOf(types);
        this.inputChannels = new InputChannels(inputChannels);
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public SelectedPositions filter(SqlFunctionProperties properties, Page page) {
        if (this.selectedPositions.length < page.getPositionCount()) {
            this.selectedPositions = new boolean[page.getPositionCount()];
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            this.selectedPositions[position] = this.matches(page, position);
        }
        return PageFilter.positionsArrayToSelectedPositions(this.selectedPositions, page.getPositionCount());
    }

    private boolean matches(Page page, int position) {
        for (int channel = 0; channel < this.inputChannels.size(); ++channel) {
            Type type = this.types.get(channel);
            Block outputBlock = page.getBlock(channel);
            Block singleTupleBlock = this.tuplePage.getBlock(channel);
            try {
                if (type.equalTo(singleTupleBlock, 0, outputBlock, position)) continue;
                return false;
            }
            catch (NotSupportedException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }
}

