/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.common.Page;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PageBuffer {
    private static final ListenableFuture<?> NOT_FULL = Futures.immediateFuture(null);
    private final int maxBufferedPages;
    private final Queue<Page> pages;
    private SettableFuture<?> settableFuture;

    public PageBuffer(int maxBufferedPages) {
        Preconditions.checkArgument((maxBufferedPages > 0 ? 1 : 0) != 0, (Object)"maxBufferedPages must be at least one");
        this.maxBufferedPages = maxBufferedPages;
        this.pages = new ArrayDeque<Page>(maxBufferedPages);
    }

    public synchronized boolean isFull() {
        return this.pages.size() >= this.maxBufferedPages;
    }

    public synchronized ListenableFuture<?> add(Page page) {
        Preconditions.checkState((!this.isFull() ? 1 : 0) != 0, (Object)"PageBuffer is full!");
        this.pages.offer(page);
        if (this.isFull()) {
            if (this.settableFuture == null) {
                this.settableFuture = SettableFuture.create();
            }
            return this.settableFuture;
        }
        return NOT_FULL;
    }

    public synchronized Page poll() {
        if (this.settableFuture != null) {
            this.settableFuture.set(null);
            this.settableFuture = null;
        }
        return this.pages.poll();
    }
}

