/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchangeSource;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.PageReference;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.function.LongConsumer;

public class PassthroughExchanger
implements LocalExchanger {
    private final LocalExchangeSource localExchangeSource;
    private final LocalExchangeMemoryManager bufferMemoryManager;
    private final LongConsumer memoryTracker;
    private final PageReference.PageReleasedListener onPageReleased;

    public PassthroughExchanger(LocalExchangeSource localExchangeSource, long bufferMaxMemory, LongConsumer memoryTracker) {
        this.localExchangeSource = Objects.requireNonNull(localExchangeSource, "localExchangeSource is null");
        this.memoryTracker = Objects.requireNonNull(memoryTracker, "memoryTracker is null");
        this.bufferMemoryManager = new LocalExchangeMemoryManager(bufferMaxMemory);
        this.onPageReleased = releasedSizeInBytes -> {
            this.bufferMemoryManager.updateMemoryUsage(-releasedSizeInBytes);
            this.memoryTracker.accept(-releasedSizeInBytes);
        };
    }

    @Override
    public void accept(Page page) {
        long retainedSizeInBytes = page.getRetainedSizeInBytes();
        this.bufferMemoryManager.updateMemoryUsage(retainedSizeInBytes);
        this.memoryTracker.accept(retainedSizeInBytes);
        this.localExchangeSource.addPage(new PageReference(page, 1, this.onPageReleased));
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.bufferMemoryManager.getNotFullFuture();
    }

    @Override
    public void finish() {
        this.localExchangeSource.finish();
    }
}

