/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.SetOfValues;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.SetAggregationState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.TypeParameter;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SetAggregationStateFactory
implements AccumulatorStateFactory<SetAggregationState> {
    private final Type elementType;

    public SetAggregationStateFactory(@TypeParameter(value="T") Type elementType) {
        this.elementType = elementType;
    }

    public SetAggregationState createSingleState() {
        return new SingleState(this.elementType);
    }

    public Class<? extends SetAggregationState> getSingleStateClass() {
        return SingleState.class;
    }

    public SetAggregationState createGroupedState() {
        return new GroupedState(this.elementType);
    }

    public Class<? extends SetAggregationState> getGroupedStateClass() {
        return GroupedState.class;
    }

    public static class SingleState
    implements SetAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleState.class).instanceSize();
        private final Type elementType;
        private SetOfValues set;

        public SingleState(Type elementType) {
            this.elementType = elementType;
        }

        @Override
        public SetOfValues get() {
            return this.set;
        }

        @Override
        public void set(SetOfValues set) {
            this.set = set;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }

        @Override
        public Type getElementType() {
            return this.elementType;
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.set != null) {
                estimatedSize += this.set.estimatedInMemorySize();
            }
            return estimatedSize;
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements SetAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedState.class).instanceSize();
        private final Type elementType;
        private long size;
        private final ObjectBigArray<SetOfValues> set = new ObjectBigArray();

        public GroupedState(Type elementType) {
            this.elementType = elementType;
        }

        public void ensureCapacity(long size) {
            this.set.ensureCapacity(size);
        }

        @Override
        public SetOfValues get() {
            return (SetOfValues)this.set.get(this.getGroupId());
        }

        @Override
        public void set(SetOfValues value) {
            Objects.requireNonNull(value, "value is null");
            SetOfValues previous = this.get();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.set.set(this.getGroupId(), (Object)value);
            this.size += value.estimatedInMemorySize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        @Override
        public Type getElementType() {
            return this.elementType;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size;
        }
    }
}

