/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.fixedhistogram.FixedDoubleHistogram;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.PrecisionRecallState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class PrecisionRecallStateFactory
implements AccumulatorStateFactory<PrecisionRecallState> {
    public PrecisionRecallState createSingleState() {
        return new SingleState();
    }

    public Class<? extends PrecisionRecallState> getSingleStateClass() {
        return SingleState.class;
    }

    public PrecisionRecallState createGroupedState() {
        return new GroupedState();
    }

    public Class<? extends PrecisionRecallState> getGroupedStateClass() {
        return GroupedState.class;
    }

    public static class SingleState
    implements PrecisionRecallState {
        private boolean nullSet;
        private FixedDoubleHistogram trueWeights;
        private FixedDoubleHistogram falseWeights;

        @Override
        public void setTrueWeights(FixedDoubleHistogram histogram) {
            Objects.requireNonNull(histogram, "histogram is null");
            this.trueWeights = histogram;
        }

        @Override
        public FixedDoubleHistogram getTrueWeights() {
            return this.trueWeights;
        }

        @Override
        public void setFalseWeights(FixedDoubleHistogram histogram) {
            Objects.requireNonNull(histogram, "histogram is null");
            this.falseWeights = histogram;
        }

        @Override
        public FixedDoubleHistogram getFalseWeights() {
            return this.falseWeights;
        }

        public long getEstimatedSize() {
            if (this.trueWeights == null) {
                return 0L;
            }
            return this.trueWeights.estimatedInMemorySize() + this.falseWeights.estimatedInMemorySize();
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements PrecisionRecallState {
        private final ObjectBigArray<FixedDoubleHistogram> trueWeights = new ObjectBigArray();
        private final ObjectBigArray<FixedDoubleHistogram> falseWeights = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.trueWeights.ensureCapacity(size);
            this.falseWeights.ensureCapacity(size);
        }

        @Override
        public void setTrueWeights(FixedDoubleHistogram histogram) {
            Objects.requireNonNull(histogram, "histogram is null");
            FixedDoubleHistogram previous = this.getTrueWeights();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.trueWeights.set(this.getGroupId(), (Object)histogram);
            this.size += histogram.estimatedInMemorySize();
        }

        @Override
        public FixedDoubleHistogram getTrueWeights() {
            return (FixedDoubleHistogram)this.trueWeights.get(this.getGroupId());
        }

        @Override
        public void setFalseWeights(FixedDoubleHistogram histogram) {
            Objects.requireNonNull(histogram, "histogram is null");
            FixedDoubleHistogram previous = this.getFalseWeights();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.falseWeights.set(this.getGroupId(), (Object)histogram);
            this.size += histogram.estimatedInMemorySize();
        }

        @Override
        public FixedDoubleHistogram getFalseWeights() {
            return (FixedDoubleHistogram)this.falseWeights.get(this.getGroupId());
        }

        public long getEstimatedSize() {
            return this.size + this.trueWeights.sizeOf() + this.falseWeights.sizeOf();
        }
    }
}

