/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;

public class NullableDoubleStateSerializer
implements AccumulatorStateSerializer<NullableDoubleState> {
    public Type getSerializedType() {
        return DoubleType.DOUBLE;
    }

    public void serialize(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, state.getDouble());
        }
    }

    public void deserialize(Block block, int index, NullableDoubleState state) {
        state.setNull(false);
        state.setDouble(DoubleType.DOUBLE.getDouble(block, index));
    }
}

