/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.slice.SizeOf;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DigestAndPercentileArrayStateFactory
implements AccumulatorStateFactory<DigestAndPercentileArrayState> {
    public DigestAndPercentileArrayState createSingleState() {
        return new SingleDigestAndPercentileArrayState();
    }

    public Class<? extends DigestAndPercentileArrayState> getSingleStateClass() {
        return SingleDigestAndPercentileArrayState.class;
    }

    public DigestAndPercentileArrayState createGroupedState() {
        return new GroupedDigestAndPercentileArrayState();
    }

    public Class<? extends DigestAndPercentileArrayState> getGroupedStateClass() {
        return GroupedDigestAndPercentileArrayState.class;
    }

    public static class SingleDigestAndPercentileArrayState
    implements DigestAndPercentileArrayState {
        public static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleDigestAndPercentileArrayState.class).instanceSize();
        private QuantileDigest digest;
        private List<Double> percentiles;

        @Override
        public QuantileDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digest = Objects.requireNonNull(digest, "digest is null");
        }

        @Override
        public List<Double> getPercentiles() {
            return this.percentiles;
        }

        @Override
        public void setPercentiles(List<Double> percentiles) {
            this.percentiles = Objects.requireNonNull(percentiles, "percentiles is null");
        }

        @Override
        public void addMemoryUsage(long value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += this.digest.estimatedInMemorySizeInBytes();
            }
            if (this.percentiles != null) {
                estimatedSize += SizeOf.sizeOfDoubleArray((int)this.percentiles.size());
            }
            return estimatedSize;
        }
    }

    public static class GroupedDigestAndPercentileArrayState
    extends AbstractGroupedAccumulatorState
    implements DigestAndPercentileArrayState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedDigestAndPercentileArrayState.class).instanceSize();
        private final ObjectBigArray<QuantileDigest> digests = new ObjectBigArray();
        private final ObjectBigArray<List<Double>> percentilesArray = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
            this.percentilesArray.ensureCapacity(size);
        }

        @Override
        public QuantileDigest getDigest() {
            return (QuantileDigest)this.digests.get(this.getGroupId());
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digests.set(this.getGroupId(), (Object)Objects.requireNonNull(digest, "digest is null"));
        }

        @Override
        public List<Double> getPercentiles() {
            return (List)this.percentilesArray.get(this.getGroupId());
        }

        @Override
        public void setPercentiles(List<Double> percentiles) {
            this.percentilesArray.set(this.getGroupId(), Objects.requireNonNull(percentiles, "percentiles is null"));
        }

        @Override
        public void addMemoryUsage(long value) {
            this.size += value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf() + this.percentilesArray.sizeOf();
        }
    }
}

