/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.theta;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchAggregationState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;

public class ThetaSketchStateSerializer
implements AccumulatorStateSerializer<ThetaSketchAggregationState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(ThetaSketchAggregationState state, BlockBuilder out) {
        Slice stateMemory = Slices.wrappedBuffer((byte[])state.getSketch().toByteArray());
        VarbinaryType.VARBINARY.writeSlice(out, stateMemory);
    }

    public void deserialize(Block block, int index, ThetaSketchAggregationState state) {
        Slice data = VarbinaryType.VARBINARY.getSlice(block, index);
        SetOperation op = Union.wrap((WritableMemory)WritableMemory.writableWrap((byte[])data.getBytes()));
        Verify.verify((op.getFamily() == Family.UNION ? 1 : 0) != 0);
        state.setSketch((Union)op);
    }
}

