/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.kll;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchAggregationState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.apache.datasketches.kll.KllItemsSketch;

@AggregationFunction(value="sketch_kll_with_k")
public class KllSketchWithKAggregationFunction {
    private KllSketchWithKAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState KllSketchAggregationState state, @SqlType(value="T") long value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, type, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(() -> -KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Long.TYPE));
        state.update(value);
        state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Long.TYPE));
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState KllSketchAggregationState state, @SqlType(value="T") double value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, type, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(() -> -KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Double.TYPE));
        state.update(value);
        state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Double.TYPE));
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState KllSketchAggregationState state, @SqlType(value="T") Slice value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, type, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(() -> -KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Slice.class));
        state.update(value);
        state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Slice.class));
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState KllSketchAggregationState state, @SqlType(value="T") boolean value, @SqlType(value="bigint") long k) {
        KllSketchWithKAggregationFunction.initializeSketch(state, type, k);
        KllItemsSketch sketch = state.getSketch();
        state.addMemoryUsage(() -> -KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Boolean.TYPE));
        state.update(value);
        state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, Boolean.TYPE));
    }

    @CombineFunction
    public static void combine(@AggregationState KllSketchAggregationState state, @AggregationState KllSketchAggregationState otherState) {
        if (state.getSketch() != null && otherState.getSketch() != null) {
            state.addMemoryUsage(() -> -KllSketchAggregationState.getEstimatedKllInMemorySize(state.getSketch(), state.getType().getJavaType()));
            state.getSketch().merge(otherState.getSketch());
            state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(state.getSketch(), state.getType().getJavaType()));
        } else if (state.getSketch() == null) {
            state.setSketch(otherState.getSketch());
            state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(otherState.getSketch(), state.getType().getJavaType()));
        }
    }

    @TypeParameter(value="T")
    @OutputFunction(value="kllsketch(T)")
    public static void output(@AggregationState KllSketchAggregationState state, BlockBuilder out) {
        if (state.getSketch() == null) {
            out.appendNull();
            return;
        }
        VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedBuffer((byte[])state.getSketch().toByteArray()));
    }

    private static void initializeSketch(KllSketchAggregationState state, Type type, long k) {
        if (state.getSketch() != null) {
            return;
        }
        if (k < 8L || k > 65535L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("k value must satisfy 8 <= k <= %d: %d", 65535, k));
        }
        KllSketchAggregationState.SketchParameters<?> parameters = KllSketchAggregationState.getSketchParameters(type);
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)((int)k), parameters.getComparator(), parameters.getSerde());
        state.setSketch(sketch);
        state.setConversion(parameters.getConversion());
        state.addMemoryUsage(() -> KllSketchAggregationState.getEstimatedKllInMemorySize(sketch, state.getType().getJavaType()));
    }
}

