/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.kll;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.type.AbstractVarcharType;
import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchStateFactory;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchStateSerializer;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchStateFactory;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateMetadata;
import com.facebook.presto.type.IntervalYearMonthType;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;
import org.openjdk.jol.info.ClassLayout;

@AccumulatorStateMetadata(stateFactoryClass=KllSketchStateFactory.class, stateSerializerClass=KllSketchStateSerializer.class)
public interface KllSketchAggregationState
extends AccumulatorState {
    public static final Map<Class<?>, double[]> SIZE_ESTIMATOR_PARAMETERS = ImmutableMap.builder().put(Double.TYPE, (Object)new double[]{929.0746716729514, 3.3328879969131457}).put(Long.TYPE, (Object)new double[]{929.920850240635, 3.3325974295999283}).put(Slice.class, (Object)new double[]{1008.5483794752541, 4.234749475485517}).put(Boolean.TYPE, (Object)new double[]{345.60095530779705, 14.12193288555095}).build();
    public static final long SKETCH_INSTANCE_SIZE = ClassLayout.parseClass(KllItemsSketch.class).instanceSize();

    @Nullable
    public <T> KllItemsSketch<T> getSketch();

    public void addMemoryUsage(Supplier<Long> var1);

    public Type getType();

    public <T> void setSketch(KllItemsSketch<T> var1);

    public void setConversion(Function<Object, Object> var1);

    public <T> void update(T var1);

    public static long getEstimatedKllInMemorySize(@Nullable KllItemsSketch<?> sketch, Class<?> type) {
        if (sketch == null) {
            return 0L;
        }
        double[] parameters = SIZE_ESTIMATOR_PARAMETERS.get(type);
        if (parameters == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unsupported parameter class: " + type.getName());
        }
        double linear = parameters[1];
        double constant = parameters[0];
        return (long)(linear * (double)sketch.getSerializedSizeBytes() + constant);
    }

    public static SketchParameters<?> getSketchParameters(Type type) {
        if (!type.isOrderable() || !type.isComparable()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, type + " does not support comparisons or ordering");
        }
        if (type.equals(RealType.REAL)) {
            return new SketchParameters(Double::compareTo, new ArrayOfDoublesSerDe(), intValue -> (double)Float.intBitsToFloat(((Long)intValue).intValue()));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new SketchParameters(Double::compareTo, new ArrayOfDoublesSerDe());
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new SketchParameters(Boolean::compareTo, new ArrayOfBooleansSerDe());
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return new SketchParameters(Long::compareTo, new ArrayOfLongsSerDe(), packed -> DateTimeEncoding.unpackMillisUtc((long)((Long)packed)));
        }
        if (type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type instanceof BigintEnumType || type.equals(TimeType.TIME) || type.equals(TimestampType.TIMESTAMP) || type.equals(DateType.DATE) || type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
            return new SketchParameters(Long::compareTo, new ArrayOfLongsSerDe());
        }
        if (type instanceof AbstractVarcharType) {
            return new SketchParameters(String::compareTo, new ArrayOfStringsSerDe(), slice -> ((Slice)slice).toStringUtf8());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Unsupported type for KLL sketch: " + type);
    }

    public static class SketchParameters<T> {
        private final Comparator<T> comparator;
        private final ArrayOfItemsSerDe<T> serde;
        private final Function<Object, Object> conversion;

        public SketchParameters(Comparator<T> comparator, ArrayOfItemsSerDe<T> serde, Function<Object, Object> conversion) {
            this.comparator = comparator;
            this.serde = serde;
            this.conversion = conversion;
        }

        public SketchParameters(Comparator<T> comparator, ArrayOfItemsSerDe<T> serde) {
            this(comparator, serde, Function.identity());
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }

        public ArrayOfItemsSerDe<T> getSerde() {
            return this.serde;
        }

        public Function<Object, Object> getConversion() {
            return this.conversion;
        }
    }

    public static class Grouped
    extends AbstractGroupedAccumulatorState
    implements KllSketchAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(ThetaSketchStateFactory.GroupedThetaSketchState.class).instanceSize();
        private final ObjectBigArray<KllItemsSketch> sketches = new ObjectBigArray();
        private long accumulatedSizeInBytes;
        private final Type type;
        private Function<Object, Object> conversion = Function.identity();

        public Grouped(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public <T> KllItemsSketch<T> getSketch() {
            return (KllItemsSketch)this.sketches.get(this.getGroupId());
        }

        @Override
        public void addMemoryUsage(Supplier<Long> usage) {
            this.accumulatedSizeInBytes += usage.get().longValue();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T> void setSketch(KllItemsSketch<T> sketch) {
            this.sketches.set(this.getGroupId(), Objects.requireNonNull(sketch, "kll sketch is null"));
        }

        @Override
        public void setConversion(Function<Object, Object> conversion) {
            this.conversion = conversion;
        }

        @Override
        public <T> void update(T item) {
            this.getSketch().update(this.conversion.apply(item));
        }

        public long getEstimatedSize() {
            return this.sketches.sizeOf() + (long)INSTANCE_SIZE + this.accumulatedSizeInBytes;
        }

        public void ensureCapacity(long size) {
            this.sketches.ensureCapacity(size);
        }
    }

    public static class Single
    implements KllSketchAggregationState {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(Single.class).instanceSize();
        @Nullable
        private KllItemsSketch sketch;
        private final Type type;
        private Function<Object, Object> conversion = Function.identity();

        public Single(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public <T> KllItemsSketch<T> getSketch() {
            return this.sketch;
        }

        @Override
        public <T> void setSketch(KllItemsSketch<T> sketch) {
            this.sketch = sketch;
        }

        @Override
        public void setConversion(Function<Object, Object> conversion) {
            this.conversion = conversion;
        }

        @Override
        public <T> void update(T item) {
            this.sketch.update(this.conversion.apply(item));
        }

        @Override
        public void addMemoryUsage(Supplier<Long> usage) {
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public long getEstimatedSize() {
            if (this.sketch != null) {
                return SKETCH_INSTANCE_SIZE + INSTANCE_SIZE + KllSketchAggregationState.getEstimatedKllInMemorySize(this.sketch, this.type.getJavaType());
            }
            return INSTANCE_SIZE;
        }
    }
}

