/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.reservoirsample;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.reservoirsample.ReservoirSample;
import com.facebook.presto.operator.aggregation.reservoirsample.ReservoirSampleState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.TypeParameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ReservoirSampleStateSerializer
implements AccumulatorStateSerializer<ReservoirSampleState> {
    private final Type elementType;
    private final Type arrayType;

    public ReservoirSampleStateSerializer(@TypeParameter(value="T") Type elementType) {
        this.elementType = elementType;
        this.arrayType = new ArrayType(elementType);
    }

    public Type getSerializedType() {
        RowType.Field initialSample = new RowType.Field(Optional.of("initialSample"), this.arrayType);
        RowType.Field initialSeenCount = new RowType.Field(Optional.of("initialSeenCount"), (Type)BigintType.BIGINT);
        RowType.Field seenCount = new RowType.Field(Optional.of("seenCount"), (Type)BigintType.BIGINT);
        RowType.Field maxSampleSize = new RowType.Field(Optional.of("maxSampleSize"), (Type)IntegerType.INTEGER);
        RowType.Field sample = new RowType.Field(Optional.of("sample"), this.arrayType);
        List<RowType.Field> fields = Arrays.asList(initialSample, initialSeenCount, seenCount, maxSampleSize, sample);
        return RowType.from(fields);
    }

    public void serialize(ReservoirSampleState state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.get().serialize(entryBuilder);
            out.closeEntry();
        }
    }

    public void deserialize(Block block, int index, ReservoirSampleState state) {
        if (block.isNull(index)) {
            state.set(null);
            return;
        }
        Type rowTypes = this.getSerializedType();
        Block stateBlock = (Block)rowTypes.getObject(block, index);
        Block initialSample = (Block)this.arrayType.getObject(stateBlock, 0);
        long initialSeenCount = stateBlock.getLong(1);
        long seenCount = stateBlock.getLong(2);
        int maxSampleSize = stateBlock.getInt(3);
        Block samplesBlock = (Block)this.arrayType.getObject(stateBlock, 4);
        ReservoirSample reservoirSample = new ReservoirSample(this.elementType, seenCount, maxSampleSize, samplesBlock, initialSample, initialSeenCount);
        state.set(reservoirSample);
    }
}

