/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

public final class SfmSketchAggregationUtils {
    public static final int DEFAULT_BUCKET_COUNT = 4096;
    public static final int DEFAULT_PRECISION = 24;

    private SfmSketchAggregationUtils() {
    }

    public static void ensureStateInitialized(SfmSketchState state, double epsilon, long numberOfBuckets, long precision) {
        if (state.getSketch() != null) {
            return;
        }
        SfmSketchAggregationUtils.validateSketchParameters(epsilon, (int)numberOfBuckets, (int)precision);
        SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision);
        state.setSketch(sketch);
        state.setEpsilon(epsilon);
    }

    public static void validateSketchParameters(double epsilon, int numberOfBuckets, int precision) {
        Failures.checkCondition(epsilon > 0.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "epsilon must be positive", new Object[0]);
        Failures.checkCondition(numberOfBuckets > 0 && (numberOfBuckets & numberOfBuckets - 1) == 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "numberOfBuckets must be a power of 2", new Object[0]);
        Failures.checkCondition(precision > 0 && precision % 8 == 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "precision must be a multiple of %s", 8);
    }

    public static void addHashToSketch(SfmSketchState state, long hash, double epsilon, long numberOfBuckets, long precision) {
        SfmSketchAggregationUtils.ensureStateInitialized(state, epsilon, numberOfBuckets, precision);
        state.getSketch().addHash(hash);
    }

    public static void addIndexAndZerosToSketch(SfmSketchState state, long index, long zeros, double epsilon, long numberOfBuckets, long precision) {
        SfmSketchAggregationUtils.ensureStateInitialized(state, epsilon, numberOfBuckets, precision);
        state.getSketch().addIndexAndZeros(index, zeros);
    }

    public static long hashLong(MethodHandle methodHandle, long value) {
        long hash;
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        return hash;
    }

    public static long hashDouble(MethodHandle methodHandle, double value) {
        long hash;
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        return hash;
    }

    public static long hashSlice(MethodHandle methodHandle, Slice value) {
        long hash;
        try {
            hash = methodHandle.invokeExact(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        return hash;
    }

    public static void mergeStates(SfmSketchState state, SfmSketchState otherState) {
        SfmSketch sketch = state.getSketch();
        SfmSketch otherSketch = otherState.getSketch();
        if (sketch == null) {
            state.setSketch(otherSketch);
            state.setEpsilon(otherState.getEpsilon());
        } else {
            try {
                state.mergeSketch(otherSketch);
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void writeCardinality(SfmSketchState state, BlockBuilder out) {
        SfmSketch sketch = state.getSketch();
        if (sketch == null) {
            out.appendNull();
        } else {
            sketch.enablePrivacy(state.getEpsilon());
            BigintType.BIGINT.writeLong(out, sketch.cardinality());
        }
    }

    public static void writeSketch(SfmSketchState state, BlockBuilder out) {
        SfmSketch sketch = state.getSketch();
        if (sketch == null) {
            out.appendNull();
        } else {
            sketch.enablePrivacy(state.getEpsilon());
            VarbinaryType.VARBINARY.writeSlice(out, sketch.serialize());
        }
    }
}

