/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumState;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumStateSerializer;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class NoisySumGaussianAggregation
extends SqlAggregationFunction {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)18, (int)0);
    public static final NoisySumGaussianAggregation NOISY_SUM_GAUSSIAN_AGGREGATION = new NoisySumGaussianAggregation();
    private static final String NAME = "noisy_sum_gaussian";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputShortDecimal", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputLongDecimal", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputDouble", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle REAL_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputReal", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle BIGINT_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputBigInt", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle INTEGER_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputInteger", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle SMALLINT_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputSmallInt", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle TINYINT_INPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "inputTinyInt", NoisyCountAndSumState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "output", NoisyCountAndSumState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(NoisySumGaussianAggregation.class, "combine", NoisyCountAndSumState.class, NoisyCountAndSumState.class);

    public NoisySumGaussianAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"double"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"double")), FunctionKind.AGGREGATE);
    }

    public String getDescription() {
        return "Calculates the sum over the input values and then adds random Gaussian noise.";
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type type = boundVariables.getTypeVariable("T");
        return NoisySumGaussianAggregation.generateAggregation(type);
    }

    private static BuiltInAggregationFunctionImplementation generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(NoisySumGaussianAggregation.class.getClassLoader());
        NoisyCountAndSumStateSerializer stateSerializer = new NoisyCountAndSumStateSerializer();
        AccumulatorStateFactory<NoisyCountAndSumState> stateFactory = StateCompiler.generateStateFactory(NoisyCountAndSumState.class, classLoader);
        ImmutableList inputTypes = ImmutableList.of((Object)type, (Object)DoubleType.DOUBLE);
        MethodHandle inputFunction = type instanceof DecimalType ? (((DecimalType)type).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION) : (type instanceof TinyintType ? TINYINT_INPUT_FUNCTION : (type instanceof SmallintType ? SMALLINT_INPUT_FUNCTION : (type instanceof IntegerType ? INTEGER_INPUT_FUNCTION : (type instanceof BigintType ? BIGINT_INPUT_FUNCTION : (type instanceof RealType ? REAL_INPUT_FUNCTION : DOUBLE_INPUT_FUNCTION)))));
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, DoubleType.DOUBLE.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), NoisySumGaussianAggregation.createInputParameterMetadata(type), inputFunction, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(NoisyCountAndSumState.class, (AccumulatorStateSerializer)stateSerializer, stateFactory)), (Type)DoubleType.DOUBLE);
        Type intermediateType = stateSerializer.getSerializedType();
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)DoubleType.DOUBLE, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Type)DoubleType.DOUBLE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)SHORT_DECIMAL_TYPE.getLong(valueBlock, position))).doubleValue();
        double noiseScale = DoubleType.DOUBLE.getDouble(noiseScaleBlock, position);
        NoisyCountAndSumAggregationUtils.updateState(state, value, noiseScale, null, null, null);
    }

    public static void inputLongDecimal(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((Slice)LONG_DECIMAL_TYPE.getSlice(valueBlock, position))).doubleValue();
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    public static void inputDouble(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = DoubleType.DOUBLE.getDouble(valueBlock, position);
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    public static void inputReal(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = Float.intBitsToFloat((int)RealType.REAL.getLong(valueBlock, position));
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    public static void inputBigInt(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = BigintType.BIGINT.getLong(valueBlock, position);
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    public static void inputInteger(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = IntegerType.INTEGER.getLong(valueBlock, position);
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    public static void inputSmallInt(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = SmallintType.SMALLINT.getLong(valueBlock, position);
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    public static void inputTinyInt(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, int position) {
        double value = TinyintType.TINYINT.getLong(valueBlock, position);
        NoisySumGaussianAggregation.input(state, value, noiseScaleBlock, position);
    }

    private static void input(NoisyCountAndSumState state, double value, Block noiseScaleBlock, int position) {
        double noiseScale = DoubleType.DOUBLE.getDouble(noiseScaleBlock, position);
        NoisyCountAndSumAggregationUtils.updateState(state, value, noiseScale, null, null, null);
    }

    public static void combine(NoisyCountAndSumState state, NoisyCountAndSumState otherState) {
        NoisyCountAndSumAggregationUtils.combineStates(state, otherState);
    }

    public static void output(NoisyCountAndSumState state, BlockBuilder out) {
        NoisyCountAndSumAggregationUtils.writeNoisySumOutput(state, out);
    }
}

