/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumState;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAndSumStateSerializer;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class NoisyAverageGaussianClippingRandomSeedAggregation
extends SqlAggregationFunction {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)18, (int)0);
    public static final NoisyAverageGaussianClippingRandomSeedAggregation NOISY_AVERAGE_GAUSSIAN_CLIPPING_RANDOM_SEED_AGGREGATION = new NoisyAverageGaussianClippingRandomSeedAggregation();
    private static final String NAME = "noisy_avg_gaussian";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputShortDecimal", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputLongDecimal", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputDouble", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle REAL_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputReal", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle BIGINT_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputBigInt", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle INTEGER_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputInteger", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle SMALLINT_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputSmallInt", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle TINYINT_INPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "inputTinyInt", NoisyCountAndSumState.class, Block.class, Block.class, Block.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "output", NoisyCountAndSumState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(NoisyAverageGaussianClippingRandomSeedAggregation.class, "combine", NoisyCountAndSumState.class, NoisyCountAndSumState.class);

    public NoisyAverageGaussianClippingRandomSeedAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"double"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"double"), (Object)TypeSignature.parseTypeSignature((String)"double"), (Object)TypeSignature.parseTypeSignature((String)"double"), (Object)TypeSignature.parseTypeSignature((String)"bigint")), FunctionKind.AGGREGATE);
    }

    public String getDescription() {
        return "Calculates the average (arithmetic mean) of all the input values where values are clipped to [lower, upper] range and then adds random Gaussian noise.  Random seed is used to seed random generator. This method does not use a secure random.";
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type type = boundVariables.getTypeVariable("T");
        return NoisyAverageGaussianClippingRandomSeedAggregation.generateAggregation(type);
    }

    private static BuiltInAggregationFunctionImplementation generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(NoisyAverageGaussianClippingRandomSeedAggregation.class.getClassLoader());
        NoisyCountAndSumStateSerializer stateSerializer = new NoisyCountAndSumStateSerializer();
        AccumulatorStateFactory<NoisyCountAndSumState> stateFactory = StateCompiler.generateStateFactory(NoisyCountAndSumState.class, classLoader);
        ImmutableList inputTypes = ImmutableList.of((Object)type, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
        MethodHandle inputFunction = type instanceof DecimalType ? (((DecimalType)type).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION) : (type instanceof TinyintType ? TINYINT_INPUT_FUNCTION : (type instanceof SmallintType ? SMALLINT_INPUT_FUNCTION : (type instanceof IntegerType ? INTEGER_INPUT_FUNCTION : (type instanceof BigintType ? BIGINT_INPUT_FUNCTION : (type instanceof RealType ? REAL_INPUT_FUNCTION : DOUBLE_INPUT_FUNCTION)))));
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, DoubleType.DOUBLE.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), NoisyAverageGaussianClippingRandomSeedAggregation.createInputParameterMetadata(type), inputFunction, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(NoisyCountAndSumState.class, (AccumulatorStateSerializer)stateSerializer, stateFactory)), (Type)DoubleType.DOUBLE);
        Type intermediateType = stateSerializer.getSerializedType();
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)DoubleType.DOUBLE, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Type)DoubleType.DOUBLE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Type)DoubleType.DOUBLE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Type)DoubleType.DOUBLE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, (Type)BigintType.BIGINT), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)SHORT_DECIMAL_TYPE.getLong(valueBlock, position))).doubleValue();
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputLongDecimal(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = UnscaledDecimal128Arithmetic.unscaledDecimalToBigInteger((Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((Slice)LONG_DECIMAL_TYPE.getSlice(valueBlock, position))).doubleValue();
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputDouble(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = DoubleType.DOUBLE.getDouble(valueBlock, position);
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputReal(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = Float.intBitsToFloat((int)RealType.REAL.getLong(valueBlock, position));
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputBigInt(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = BigintType.BIGINT.getLong(valueBlock, position);
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputInteger(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = IntegerType.INTEGER.getLong(valueBlock, position);
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputSmallInt(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = SmallintType.SMALLINT.getLong(valueBlock, position);
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    public static void inputTinyInt(NoisyCountAndSumState state, Block valueBlock, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double value = TinyintType.TINYINT.getLong(valueBlock, position);
        NoisyAverageGaussianClippingRandomSeedAggregation.input(state, value, noiseScaleBlock, lowerBlock, upperBlock, randomSeedBlock, position);
    }

    private static void input(NoisyCountAndSumState state, double value, Block noiseScaleBlock, Block lowerBlock, Block upperBlock, Block randomSeedBlock, int position) {
        double noiseScale = DoubleType.DOUBLE.getDouble(noiseScaleBlock, position);
        double lower = DoubleType.DOUBLE.getDouble(lowerBlock, position);
        double upper = DoubleType.DOUBLE.getDouble(upperBlock, position);
        long randomSeed = BigintType.BIGINT.getLong(randomSeedBlock, position);
        NoisyCountAndSumAggregationUtils.updateState(state, value, noiseScale, lower, upper, randomSeed);
    }

    public static void combine(NoisyCountAndSumState state, NoisyCountAndSumState otherState) {
        NoisyCountAndSumAggregationUtils.combineStates(state, otherState);
    }

    public static void output(NoisyCountAndSumState state, BlockBuilder out) {
        NoisyCountAndSumAggregationUtils.writeNoisyAvgOutput(state, out);
    }
}

