/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jol.info.ClassLayout;

public class WeightedDoubleReservoirSample
implements Cloneable {
    public static final int MAX_SAMPLES_LIMIT = 1000000;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(WeightedDoubleReservoirSample.class).instanceSize();
    private int count;
    private double[] samples;
    private double[] weights;
    private double totalPopulationWeight;

    public WeightedDoubleReservoirSample(int maxSamples) {
        Preconditions.checkArgument((maxSamples > 0 ? 1 : 0) != 0, (Object)String.format("Maximum number of samples must be positive: %s", maxSamples));
        Preconditions.checkArgument((maxSamples <= 1000000 ? 1 : 0) != 0, (Object)String.format("Maximum number of samples must not exceed limit: %s %s", maxSamples, 1000000));
        this.samples = new double[maxSamples];
        this.weights = new double[maxSamples];
    }

    private WeightedDoubleReservoirSample(WeightedDoubleReservoirSample other) {
        this.count = other.count;
        this.samples = Arrays.copyOf(other.samples, other.samples.length);
        this.weights = Arrays.copyOf(other.weights, other.weights.length);
        this.totalPopulationWeight = other.totalPopulationWeight;
    }

    private WeightedDoubleReservoirSample(int count, double[] samples, double[] weights, double totalPopulationWeight) {
        this.count = count;
        this.samples = Objects.requireNonNull(samples, "samples is null");
        this.weights = Objects.requireNonNull(weights, "weights is null");
        this.totalPopulationWeight = totalPopulationWeight;
    }

    public long getMaxSamples() {
        return this.samples.length;
    }

    public void add(double sample, double weight) {
        Preconditions.checkArgument((weight >= 0.0 ? 1 : 0) != 0, (Object)String.format("Weight %s cannot be negative", weight));
        this.totalPopulationWeight += weight;
        double adjustedWeight = Math.pow(ThreadLocalRandom.current().nextDouble(), 1.0 / weight);
        this.addWithAdjustedWeight(sample, adjustedWeight);
    }

    private void addWithAdjustedWeight(double sample, double adjustedWeight) {
        if (this.count < this.samples.length) {
            this.samples[this.count] = sample;
            this.weights[this.count] = adjustedWeight;
            ++this.count;
            this.bubbleUp();
            return;
        }
        if (adjustedWeight <= this.weights[0]) {
            return;
        }
        this.samples[0] = sample;
        this.weights[0] = adjustedWeight;
        this.bubbleDown();
    }

    public void mergeWith(WeightedDoubleReservoirSample other) {
        this.totalPopulationWeight += other.totalPopulationWeight;
        for (int i = 0; i < other.count; ++i) {
            this.addWithAdjustedWeight(other.samples[i], other.weights[i]);
        }
    }

    public final WeightedDoubleReservoirSample clone() {
        return new WeightedDoubleReservoirSample(this);
    }

    public double[] getSamples() {
        return Arrays.copyOf(this.samples, this.count);
    }

    private void swap(int i, int j) {
        double tmpElement = this.samples[i];
        double tmpWeight = this.weights[i];
        this.samples[i] = this.samples[j];
        this.weights[i] = this.weights[j];
        this.samples[j] = tmpElement;
        this.weights[j] = tmpWeight;
    }

    private void bubbleDown() {
        int index = 0;
        while (WeightedDoubleReservoirSample.leftChild(index) < this.count) {
            int smallestChildIndex = WeightedDoubleReservoirSample.leftChild(index);
            if (WeightedDoubleReservoirSample.rightChild(index) < this.count && this.weights[WeightedDoubleReservoirSample.leftChild(index)] > this.weights[WeightedDoubleReservoirSample.rightChild(index)]) {
                smallestChildIndex = WeightedDoubleReservoirSample.rightChild(index);
            }
            if (!(this.weights[index] > this.weights[smallestChildIndex])) break;
            this.swap(index, smallestChildIndex);
            index = smallestChildIndex;
        }
    }

    private void bubbleUp() {
        int index = this.count - 1;
        while (index > 0 && this.weights[index] < this.weights[WeightedDoubleReservoirSample.parent(index)]) {
            this.swap(index, WeightedDoubleReservoirSample.parent(index));
            index = WeightedDoubleReservoirSample.parent(index);
        }
    }

    private static int parent(int pos) {
        return pos / 2;
    }

    private static int leftChild(int pos) {
        return 2 * pos;
    }

    private static int rightChild(int pos) {
        return 2 * pos + 1;
    }

    public static WeightedDoubleReservoirSample deserialize(SliceInput input) {
        int maxSamples;
        int count = input.readInt();
        Preconditions.checkArgument((count <= (maxSamples = input.readInt()) ? 1 : 0) != 0, (Object)"count must not be larger than number of samples");
        double[] samples = new double[maxSamples];
        input.readBytes(Slices.wrappedDoubleArray((double[])samples), count * 8);
        double[] weights = new double[maxSamples];
        input.readBytes(Slices.wrappedDoubleArray((double[])weights), count * 8);
        double totalPopulationWeight = input.readDouble();
        return new WeightedDoubleReservoirSample(count, samples, weights, totalPopulationWeight);
    }

    public void serialize(SliceOutput output) {
        int i;
        output.appendInt(this.count);
        output.appendInt(this.samples.length);
        for (i = 0; i < this.count; ++i) {
            output.appendDouble(this.samples[i]);
        }
        for (i = 0; i < this.count; ++i) {
            output.appendDouble(this.weights[i]);
        }
        output.appendDouble(this.totalPopulationWeight);
    }

    public int getRequiredBytesForSerialization() {
        return 8 + 16 * Math.min(this.count, this.samples.length) + 8;
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((double[])this.samples) + SizeOf.sizeOf((double[])this.weights);
    }

    public double getTotalPopulationWeight() {
        return this.totalPopulationWeight;
    }
}

