/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.EntropyCalculations;
import com.facebook.presto.operator.aggregation.differentialentropy.UnweightedDoubleReservoirSample;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class UnweightedReservoirSampleStateStrategy
implements DifferentialEntropyStateStrategy {
    private final UnweightedDoubleReservoirSample reservoir;

    public UnweightedReservoirSampleStateStrategy(long maxSamples) {
        if (maxSamples <= 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, max samples must be positive: %s", maxSamples));
        }
        if (maxSamples >= 1000000L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, max samples  must be capped: max_samples=%s, cap=%s", maxSamples, 1000000));
        }
        this.reservoir = new UnweightedDoubleReservoirSample(Math.toIntExact(maxSamples));
    }

    private UnweightedReservoirSampleStateStrategy(UnweightedReservoirSampleStateStrategy other) {
        this.reservoir = other.reservoir.clone();
    }

    private UnweightedReservoirSampleStateStrategy(UnweightedDoubleReservoirSample reservoir) {
        this.reservoir = reservoir;
    }

    @Override
    public void validateParameters(long maxSamples, double sample, double weight) {
        if (weight != 1.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, weight must be 1.0: %s", weight));
        }
        if (maxSamples != (long)this.reservoir.getMaxSamples()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, inconsistent maxSamples: %s, %s", maxSamples, this.reservoir.getMaxSamples()));
        }
    }

    @Override
    public void validateParameters(long maxSamples, double sample) {
        if (maxSamples != (long)this.reservoir.getMaxSamples()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, inconsistent maxSamples: %s, %s", maxSamples, this.reservoir.getMaxSamples()));
        }
    }

    @Override
    public void mergeWith(DifferentialEntropyStateStrategy other) {
        this.reservoir.mergeWith(((UnweightedReservoirSampleStateStrategy)other).reservoir);
    }

    @Override
    public void add(double value) {
        this.reservoir.add(value);
    }

    @Override
    public double getTotalPopulationWeight() {
        return this.reservoir.getTotalPopulationCount();
    }

    @Override
    public double calculateEntropy() {
        return EntropyCalculations.calculateFromSamplesUsingVasicek(this.reservoir.getSamples());
    }

    @Override
    public long getEstimatedSize() {
        return this.reservoir.estimatedInMemorySize();
    }

    @Override
    public int getRequiredBytesForSpecificSerialization() {
        return this.reservoir.getRequiredBytesForSerialization();
    }

    public static UnweightedReservoirSampleStateStrategy deserialize(SliceInput input) {
        return new UnweightedReservoirSampleStateStrategy(UnweightedDoubleReservoirSample.deserialize(input));
    }

    @Override
    public void serialize(SliceOutput out) {
        this.reservoir.serialize(out);
    }

    @Override
    public DifferentialEntropyStateStrategy clone() {
        return new UnweightedReservoirSampleStateStrategy(this);
    }

    @Override
    public DifferentialEntropyStateStrategy cloneEmpty() {
        return new UnweightedReservoirSampleStateStrategy(this.reservoir.getMaxSamples());
    }
}

