/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent.stream;

import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.PriorityQueueDataChangeListener;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamDataEntity;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class IndexedPriorityQueue {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IndexedPriorityQueue.class).instanceSize();
    public static final int MIN_POSITION = 0;
    private final StreamDataEntity[] minHeap;
    private final int heapCapacity;
    private final PriorityQueueDataChangeListener heapDataChangeListener;
    private final Comparator<StreamDataEntity> heapDataComparator;
    private int positionCount;

    public IndexedPriorityQueue(int heapCapacity, Comparator<StreamDataEntity> heapDataComparator, PriorityQueueDataChangeListener heapDataChangeListener) {
        this.minHeap = new StreamDataEntity[heapCapacity];
        this.heapCapacity = heapCapacity;
        this.heapDataChangeListener = heapDataChangeListener;
        this.heapDataComparator = heapDataComparator;
    }

    public boolean isFull() {
        return this.positionCount == this.heapCapacity;
    }

    public void add(StreamDataEntity data) {
        this.minHeap[this.positionCount++] = data;
        this.percolateUp(this.positionCount - 1);
    }

    public void replaceMin(StreamDataEntity data) {
        this.minHeap[0] = data;
        this.percolateDown(0);
    }

    public StreamDataEntity get(int index) {
        return this.minHeap[index];
    }

    public StreamDataEntity getMin() {
        return this.minHeap[0];
    }

    public void percolateDown(int position) {
        int leftPosition;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.heapDataComparator.compare(this.minHeap[leftPosition], this.minHeap[rightPosition]) >= 0 ? rightPosition : leftPosition;
            }
            if (this.heapDataComparator.compare(this.minHeap[smallerChildPosition], this.minHeap[position]) >= 0) break;
            this.swap(position, smallerChildPosition);
            this.heapDataChangeListener.indexChanged(this.minHeap[position], position);
            position = smallerChildPosition;
        }
        this.heapDataChangeListener.indexChanged(this.minHeap[position], position);
    }

    private void swap(int position, int smallerChildPosition) {
        StreamDataEntity swapTemp = this.minHeap[position];
        this.minHeap[position] = this.minHeap[smallerChildPosition];
        this.minHeap[smallerChildPosition] = swapTemp;
    }

    public void percolateUp(int position) {
        int parentPosition;
        while (position != 0 && this.heapDataComparator.compare(this.minHeap[position], this.minHeap[parentPosition = (position - 1) / 2]) < 0) {
            this.swap(position, parentPosition);
            this.heapDataChangeListener.indexChanged(this.minHeap[position], position);
            position = parentPosition;
        }
        this.heapDataChangeListener.indexChanged(this.minHeap[position], position);
    }

    public int getSize() {
        return this.positionCount;
    }

    public List<StreamDataEntity> topK(int k, Comparator<StreamDataEntity> comparator) {
        ImmutableList.Builder builder = ImmutableList.builder();
        StreamDataEntity[] topKData = Arrays.copyOf(this.minHeap, this.positionCount);
        Arrays.sort(topKData, comparator);
        int totalCount = Math.min(k, this.positionCount);
        for (int position = 0; position < totalCount; ++position) {
            builder.add((Object)topKData[position]);
        }
        return builder.build();
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.minHeap);
    }
}

