/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class SetOfValues {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SetOfValues.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private final BlockBuilder valueBlockBuilder;
    private final Type valueType;
    MethodHandle elementIsDistinctFrom;
    private int[] valuePositionByHash;
    private int hashCapacity;
    private int maxFill;
    private int hashMask;

    public SetOfValues(Type valueType, MethodHandle elementIsDistinctFrom) {
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.elementIsDistinctFrom = Objects.requireNonNull(elementIsDistinctFrom, "elementIsDistinctFrom is null");
        this.valueBlockBuilder = this.valueType.createBlockBuilder(null, 10, com.facebook.presto.type.TypeUtils.expectedValueSize(valueType, 16));
        this.hashCapacity = HashCommon.arraySize((int)10, (float)0.75f);
        this.maxFill = SetOfValues.calculateMaxFill(this.hashCapacity);
        this.hashMask = this.hashCapacity - 1;
        this.valuePositionByHash = new int[this.hashCapacity];
        Arrays.fill(this.valuePositionByHash, -1);
    }

    public SetOfValues(Block serialized, Type elementType, MethodHandle elementIsDistinctFrom) {
        this(elementType, elementIsDistinctFrom);
        this.deserialize(Objects.requireNonNull(serialized, "serialized is null"));
    }

    public Block getvalues() {
        return this.valueBlockBuilder.build();
    }

    private void deserialize(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            this.add(block, i);
        }
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
        for (int i = 0; i < this.valueBlockBuilder.getPositionCount(); ++i) {
            this.valueType.appendTo((Block)this.valueBlockBuilder, i, arrayBlockBuilder);
        }
        out.closeEntry();
    }

    public long estimatedInMemorySize() {
        long size = INSTANCE_SIZE;
        size += this.valueBlockBuilder.getRetainedSizeInBytes();
        return size += SizeOf.sizeOf((int[])this.valuePositionByHash);
    }

    public void add(Block value, int valuePosition) {
        int hashPosition = this.getHashPositionOfValue(value, valuePosition);
        if (this.valuePositionByHash[hashPosition] == -1) {
            this.valueType.appendTo(value, valuePosition, this.valueBlockBuilder);
            this.valuePositionByHash[hashPosition] = this.valueBlockBuilder.getPositionCount() - 1;
            if (this.valueBlockBuilder.getPositionCount() >= this.maxFill) {
                this.rehash();
            }
        }
    }

    private int getHashPositionOfValue(Block value, int position) {
        int hashPosition = this.getMaskedHash(com.facebook.presto.type.TypeUtils.hashPosition(this.valueType, value, position));
        while (this.valuePositionByHash[hashPosition] != -1) {
            if (this.isContainedAt((Block)this.valueBlockBuilder, this.valuePositionByHash[hashPosition], value, position)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
        return hashPosition;
    }

    private boolean isContainedAt(Block firstBlock, int positionWithinFirstBlock, Block secondBlock, int positionWithinSecondBlock) {
        boolean firstValueNull = firstBlock.isNull(positionWithinFirstBlock);
        Object firstValue = firstValueNull ? Defaults.defaultValue((Class)this.valueType.getJavaType()) : TypeUtils.readNativeValue((Type)this.valueType, (Block)firstBlock, (int)positionWithinFirstBlock);
        boolean secondValueNull = secondBlock.isNull(positionWithinSecondBlock);
        Object secondValue = secondValueNull ? Defaults.defaultValue((Class)this.valueType.getJavaType()) : TypeUtils.readNativeValue((Type)this.valueType, (Block)secondBlock, (int)positionWithinSecondBlock);
        try {
            return !this.elementIsDistinctFrom.invoke(firstValue, firstValueNull, secondValue, secondValueNull);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private void rehash() {
        int newCapacity;
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.hashCapacity = newCapacity = (int)newCapacityLong;
        this.hashMask = newCapacity - 1;
        this.maxFill = SetOfValues.calculateMaxFill(newCapacity);
        this.valuePositionByHash = new int[newCapacity];
        Arrays.fill(this.valuePositionByHash, -1);
        for (int position = 0; position < this.valueBlockBuilder.getPositionCount(); ++position) {
            this.valuePositionByHash[this.getHashPositionOfValue((Block)this.valueBlockBuilder, (int)position)] = position;
        }
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private int getMaskedHash(long rawHash) {
        return (int)(rawHash & (long)this.hashMask);
    }
}

