/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.DoubleCorrelationAggregation;
import com.facebook.presto.operator.aggregation.state.CorrelationState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;

@AggregationFunction(value="corr")
public class RealCorrelationAggregation {
    private RealCorrelationAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CorrelationState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleCorrelationAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState CorrelationState state, @AggregationState CorrelationState otherState) {
        DoubleCorrelationAggregation.combine(state, otherState);
    }

    @OutputFunction(value="real")
    public static void corr(@AggregationState CorrelationState state, BlockBuilder out) {
        double result = AggregationUtils.getCorrelation(state);
        if (Double.isFinite(result)) {
            long resultBits = Float.floatToRawIntBits((float)result);
            RealType.REAL.writeLong(out, resultBits);
        } else {
            out.appendNull();
        }
    }
}

