/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.MergeStatisticalDigestFunction;
import com.facebook.presto.operator.aggregation.StatisticalDigestFactory;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestState;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateFactory;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import java.lang.invoke.MethodHandle;

public class MergeQuantileDigestFunction
extends MergeStatisticalDigestFunction {
    public static final MergeQuantileDigestFunction MERGE = new MergeQuantileDigestFunction();
    public static final String NAME = "merge";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "input", Type.class, StatisticalDigestState.class, Block.class, Integer.TYPE);

    private MergeQuantileDigestFunction() {
        super(NAME, "qdigest", StatisticalDigestStateFactory.createQuantileDigestFactory(), SqlFunctionVisibility.PUBLIC);
    }

    public String getDescription() {
        return "Merges the input quantile digests into a single quantile digest";
    }

    public static void input(Type type, StatisticalDigestState state, Block value, int index) {
        MergeQuantileDigestFunction.merge(state, StatisticalDigestFactory.createStatisticalQuantileDigest(new QuantileDigest(type.getSlice(value, index))));
    }

    @Override
    protected MethodHandle getInputFunction() {
        return INPUT_FUNCTION;
    }
}

