/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.array.IntBigArray;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.ArrayBlockBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.SingleRowBlock;
import com.facebook.presto.common.block.SingleRowBlockWriter;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.MarkDistinctHash;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.FinalOnlyGroupedAccumulator;
import com.facebook.presto.sessionpropertyproviders.JavaWorkerSessionPropertyProvider;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.WindowIndex;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupByIdBlock;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.function.aggregation.LambdaProvider;
import com.facebook.presto.spi.storage.SerializedStorageHandle;
import com.facebook.presto.spiller.StandaloneSpiller;
import com.facebook.presto.spiller.StandaloneSpillerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class GenericAccumulatorFactory
implements AccumulatorFactory {
    private final List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;
    private final List<LambdaProvider> lambdaProviders;
    private final Optional<Integer> maskChannel;
    private final List<Integer> inputChannels;
    private final List<Type> sourceTypes;
    private final List<Integer> orderByChannels;
    private final List<SortOrder> orderings;
    @Nullable
    private final JoinCompiler joinCompiler;
    @Nullable
    private final Session session;
    private final boolean distinct;
    private final boolean spillEnabled;
    private final PagesIndex.Factory pagesIndexFactory;
    private final StandaloneSpillerFactory standaloneSpillerFactory;

    public GenericAccumulatorFactory(List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors, Constructor<? extends Accumulator> accumulatorConstructor, Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor, List<LambdaProvider> lambdaProviders, List<Integer> inputChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, Session session, boolean distinct, boolean spillEnabled, StandaloneSpillerFactory standaloneSpillerFactory) {
        this.stateDescriptors = Objects.requireNonNull(stateDescriptors, "stateDescriptors is null");
        this.accumulatorConstructor = Objects.requireNonNull(accumulatorConstructor, "accumulatorConstructor is null");
        this.groupedAccumulatorConstructor = Objects.requireNonNull(groupedAccumulatorConstructor, "groupedAccumulatorConstructor is null");
        this.lambdaProviders = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaProviders, "lambdaProviders is null"));
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        this.inputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
        this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
        this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
        Preconditions.checkArgument((orderByChannels.isEmpty() || !Objects.isNull(pagesIndexFactory) ? 1 : 0) != 0, (Object)"No pagesIndexFactory to process ordering");
        this.pagesIndexFactory = pagesIndexFactory;
        Preconditions.checkArgument((!distinct || !Objects.isNull(session) && !Objects.isNull(joinCompiler) && !Objects.isNull(standaloneSpillerFactory) ? 1 : 0) != 0, (Object)"joinCompiler, session and standaloneSpillerFactory needed when distinct is true");
        this.joinCompiler = joinCompiler;
        this.session = session;
        this.distinct = distinct;
        this.spillEnabled = spillEnabled;
        this.standaloneSpillerFactory = standaloneSpillerFactory;
    }

    @Override
    public List<Integer> getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Accumulator createAccumulator(UpdateMemory updateMemory) {
        Accumulator accumulator;
        if (this.hasDistinct()) {
            accumulator = this.instantiateAccumulator(this.inputChannels.stream().map(value -> value + 1).collect(Collectors.toList()), Optional.of(0));
            List argumentTypes = this.inputChannels.stream().map(this.sourceTypes::get).collect(Collectors.toList());
            accumulator = new DistinctingAccumulator(accumulator, argumentTypes, this.inputChannels, this.maskChannel, this.session, this.joinCompiler, updateMemory);
        } else {
            accumulator = this.instantiateAccumulator(this.inputChannels, this.maskChannel);
        }
        if (this.orderByChannels.isEmpty()) {
            return accumulator;
        }
        return new OrderingAccumulator(accumulator, this.sourceTypes, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    @Override
    public Accumulator createIntermediateAccumulator() {
        try {
            return this.accumulatorConstructor.newInstance(this.stateDescriptors, ImmutableList.of(), Optional.empty(), this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator(UpdateMemory updateMemory) {
        GroupedAccumulator accumulator = this.createGenericGroupedAccumulator(updateMemory);
        if (!this.spillEnabled || !this.hasDistinct() && !this.hasOrderBy()) {
            return accumulator;
        }
        Preconditions.checkState((boolean)(accumulator instanceof FinalOnlyGroupedAccumulator));
        ImmutableSet.Builder aggregateInputChannels = ImmutableSet.builder();
        aggregateInputChannels.addAll(this.inputChannels);
        this.maskChannel.ifPresent(arg_0 -> ((ImmutableSet.Builder)aggregateInputChannels).add(arg_0));
        aggregateInputChannels.addAll(this.orderByChannels);
        Preconditions.checkState((this.session != null ? 1 : 0) != 0, (Object)"Session is null");
        if (JavaWorkerSessionPropertyProvider.isDedupBasedDistinctAggregationSpillEnabled(this.session) && this.hasDistinct() && !this.hasOrderBy()) {
            return new DedupBasedSpillableDistinctGroupedAccumulator(this.sourceTypes, (List<Integer>)aggregateInputChannels.build().asList(), (DistinctingGroupedAccumulator)accumulator, this.maskChannel, this.standaloneSpillerFactory, this.session);
        }
        return new SpillableFinalOnlyGroupedAccumulator(this.sourceTypes, (List<Integer>)aggregateInputChannels.build().asList(), (FinalOnlyGroupedAccumulator)accumulator, this.standaloneSpillerFactory, this.session);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator(UpdateMemory updateMemory) {
        if (!this.hasOrderBy() && !this.hasDistinct()) {
            try {
                return this.groupedAccumulatorConstructor.newInstance(this.stateDescriptors, ImmutableList.of(), Optional.empty(), this.lambdaProviders);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return this.createGroupedAccumulator(updateMemory);
    }

    @Override
    public boolean hasOrderBy() {
        return !this.orderByChannels.isEmpty();
    }

    @Override
    public boolean hasDistinct() {
        return this.distinct;
    }

    private GroupedAccumulator createGenericGroupedAccumulator(UpdateMemory updateMemory) {
        GroupedAccumulator accumulator;
        if (this.hasDistinct()) {
            accumulator = this.instantiateGroupedAccumulator(this.inputChannels.stream().map(value -> value + 1).collect(Collectors.toList()), Optional.of(0));
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            for (int input : this.inputChannels) {
                argumentTypes.add(this.sourceTypes.get(input));
            }
            accumulator = new DistinctingGroupedAccumulator(accumulator, argumentTypes, this.inputChannels, this.maskChannel, this.session, this.joinCompiler, updateMemory);
        } else {
            accumulator = this.instantiateGroupedAccumulator(this.inputChannels, this.maskChannel);
        }
        if (this.orderByChannels.isEmpty()) {
            return accumulator;
        }
        return new OrderingGroupedAccumulator(accumulator, this.sourceTypes, this.orderByChannels, this.orderings, this.pagesIndexFactory);
    }

    private Accumulator instantiateAccumulator(List<Integer> inputs, Optional<Integer> mask) {
        try {
            return this.accumulatorConstructor.newInstance(this.stateDescriptors, inputs, mask, this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private GroupedAccumulator instantiateGroupedAccumulator(List<Integer> inputs, Optional<Integer> mask) {
        try {
            return this.groupedAccumulatorConstructor.newInstance(this.stateDescriptors, inputs, mask, this.lambdaProviders);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static AccumulatorFactory generateAccumulatorFactory(JavaAggregationFunctionImplementation functionImplementation, List<Integer> argumentChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory, boolean distinct, JoinCompiler joinCompiler, List<LambdaProvider> lambdaProviders, boolean spillEnabled, Session session, StandaloneSpillerFactory standaloneSpillerFactory) {
        try {
            Constructor accumulatorConstructor = functionImplementation.getAccumulatorClass().getConstructor(List.class, List.class, Optional.class, List.class);
            Constructor groupedAccumulatorConstructor = functionImplementation.getGroupedAccumulatorClass().getConstructor(List.class, List.class, Optional.class, List.class);
            return new GenericAccumulatorFactory(functionImplementation.getAggregationMetadata().getAccumulatorStateDescriptors(), accumulatorConstructor, groupedAccumulatorConstructor, lambdaProviders, argumentChannels, maskChannel, sourceTypes, orderByChannels, orderings, pagesIndexFactory, joinCompiler, session, distinct, spillEnabled, standaloneSpillerFactory);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static AccumulatorFactory generateAccumulatorFactory(JavaAggregationFunctionImplementation javaAggregationFunctionImplementation, List<Integer> inputChannels, Optional<Integer> maskChannel) {
        return GenericAccumulatorFactory.generateAccumulatorFactory(javaAggregationFunctionImplementation, inputChannels, maskChannel, (List<Type>)ImmutableList.of(), (List<Integer>)ImmutableList.of(), (List<SortOrder>)ImmutableList.of(), null, false, null, (List<LambdaProvider>)ImmutableList.of(), false, null, null);
    }

    private static Page filter(Page page, Block mask) {
        int positions = mask.getPositionCount();
        if (positions > 0 && mask instanceof RunLengthEncodedBlock) {
            boolean isNull;
            boolean bl = isNull = mask.mayHaveNull() && mask.isNull(0);
            if (!isNull && BooleanType.BOOLEAN.getBoolean(mask, 0)) {
                return page;
            }
            return page.getPositions(new int[0], 0, 0);
        }
        boolean mayHaveNull = mask.mayHaveNull();
        int[] ids = new int[positions];
        int next = 0;
        for (int i = 0; i < ids.length; ++i) {
            boolean isNull;
            boolean bl = isNull = mayHaveNull && mask.isNull(i);
            if (isNull || !BooleanType.BOOLEAN.getBoolean(mask, i)) continue;
            ids[next++] = i;
        }
        if (next == ids.length) {
            return page;
        }
        return page.getPositions(ids, 0, next);
    }

    private static class DistinctingAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final MarkDistinctHash hash;
        private final int maskChannel;

        private DistinctingAccumulator(Accumulator accumulator, List<Type> inputTypes, List<Integer> inputs, Optional<Integer> maskChannel, Session session, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null").orElse(-1);
            this.hash = new MarkDistinctHash(session, inputTypes, Ints.toArray(inputs), Optional.empty(), joinCompiler, () -> {
                updateMemory.update();
                return true;
            });
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        public void addInput(Page page) {
            Page filtered = this.maskChannel >= 0 ? GenericAccumulatorFactory.filter(page, page.getBlock(this.maskChannel)) : page;
            if (filtered.getPositionCount() == 0) {
                return;
            }
            Work<Block> work = this.hash.markDistinctRows(filtered);
            Preconditions.checkState((boolean)work.process());
            Block distinctMask = work.getResult();
            this.accumulator.addInput(filtered.prependColumn(distinctMask));
        }

        public void addInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }

    private static class OrderingAccumulator
    implements Accumulator {
        private final Accumulator accumulator;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;

        private OrderingAccumulator(Accumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            this.pagesIndex = pagesIndexFactory.newPagesIndex(aggregationSourceTypes, 10000);
        }

        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        public Type getIntermediateType() {
            throw new UnsupportedOperationException();
        }

        public void addInput(Page page) {
            this.pagesIndex.addPage(page);
        }

        public void addInput(WindowIndex index, List<Integer> channels, int startPosition, int endPosition) {
            throw new UnsupportedOperationException();
        }

        public void addIntermediate(Block block) {
            throw new UnsupportedOperationException();
        }

        public void evaluateIntermediate(BlockBuilder blockBuilder) {
            throw new UnsupportedOperationException();
        }

        public void evaluateFinal(BlockBuilder blockBuilder) {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(arg_0 -> ((Accumulator)this.accumulator).addInput(arg_0));
            this.accumulator.evaluateFinal(blockBuilder);
        }
    }

    private static class DedupBasedSpillableDistinctGroupedAccumulator
    extends SpillableFinalOnlyGroupedAccumulator {
        private final DistinctingGroupedAccumulator delegate;
        private final int maskChannel;
        private long groupCount;

        public DedupBasedSpillableDistinctGroupedAccumulator(List<Type> sourceTypes, List<Integer> aggregateInputChannels, DistinctingGroupedAccumulator delegate, Optional<Integer> maskChannel, StandaloneSpillerFactory standaloneSpillerFactory, Session session) {
            super(sourceTypes, aggregateInputChannels, delegate, standaloneSpillerFactory, session);
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null").orElse(-1);
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            this.groupCount = Long.max(this.groupCount, groupIdsBlock.getGroupCount());
            this.updateGroupIdCount(this.delegate.preprocessInput(groupIdsBlock, page));
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.addRawInputs(this.delegate.getDistinctPages());
            this.delegate.reset();
            super.evaluateIntermediate(groupId, output);
        }

        @Override
        public void prepareFinal() {
            this.addRawInputs(this.delegate.getDistinctPages());
            this.delegate.reset();
            if (this.getRawInputsLength() == 0L) {
                Page page = new PageBuilder(this.getSpillingTypes()).build();
                this.addRawInputs((List<Page>)ImmutableList.of((Object)page));
            }
            super.prepareFinal();
        }

        private void addRawInputs(List<Page> inputPages) {
            for (Page inputPage : inputPages) {
                Block groupIdBlock = inputPage.getBlock(0);
                inputPage = inputPage.dropColumn(0);
                if (this.maskChannel >= 0) {
                    inputPage = inputPage.appendColumn(RunLengthEncodedBlock.create((Type)BooleanType.BOOLEAN, (Object)true, (int)inputPage.getPositionCount()));
                }
                GroupByIdBlock groupByIdBlock = new GroupByIdBlock(this.groupCount, groupIdBlock);
                this.addRawInput(groupByIdBlock, inputPage);
            }
        }
    }

    private static class DistinctingGroupedAccumulator
    extends FinalOnlyGroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final List<Type> inputTypes;
        private final List<Integer> inputChannels;
        private final int maskChannel;
        private final Session session;
        private final JoinCompiler joinCompiler;
        private final UpdateMemory updateMemory;
        private MarkDistinctHash hash;

        private DistinctingGroupedAccumulator(GroupedAccumulator accumulator, List<Type> inputTypes, List<Integer> inputChannels, Optional<Integer> maskChannel, Session session, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            this.inputTypes = Objects.requireNonNull(inputTypes, "inputTypes is null");
            this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
            this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null").orElse(-1);
            this.session = Objects.requireNonNull(session, "session is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.updateMemory = Objects.requireNonNull(updateMemory, "updateMemory is null");
            this.hash = this.createMarkDistinctHash();
        }

        private MarkDistinctHash createMarkDistinctHash() {
            ImmutableList types = ImmutableList.builder().add((Object)BigintType.BIGINT).addAll(this.inputTypes).build();
            int[] inputs = new int[this.inputChannels.size() + 1];
            inputs[0] = 0;
            for (int i = 0; i < this.inputChannels.size(); ++i) {
                inputs[i + 1] = this.inputChannels.get(i) + 1;
            }
            return new MarkDistinctHash(this.session, (List<Type>)types, inputs, Optional.empty(), this.joinCompiler, () -> {
                this.updateMemory.update();
                return true;
            });
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize() + this.accumulator.getEstimatedSize();
        }

        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Page withGroup = page.prependColumn((Block)groupIdsBlock);
            Page filtered = this.applyMaskChannelFilter(withGroup, this.maskChannel);
            Block distinctMask = this.computeDistinctMask(filtered, this.hash);
            GroupByIdBlock groupIds = new GroupByIdBlock(groupIdsBlock.getGroupCount(), filtered.getBlock(0));
            Block[] columns = new Block[filtered.getChannelCount()];
            columns[0] = distinctMask;
            for (int i = 1; i < filtered.getChannelCount(); ++i) {
                columns[i] = filtered.getBlock(i);
            }
            this.accumulator.addInput(groupIds, new Page(filtered.getPositionCount(), columns));
        }

        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        public void prepareFinal() {
        }

        public GroupByIdBlock preprocessInput(GroupByIdBlock groupIdsBlock, Page page) {
            Page withGroup = page.prependColumn((Block)groupIdsBlock);
            Page filtered = this.applyMaskChannelFilter(withGroup, this.maskChannel);
            Block distinctMask = this.computeDistinctMask(filtered, this.hash);
            Page dedupPage = GenericAccumulatorFactory.filter(filtered, distinctMask);
            return new GroupByIdBlock(groupIdsBlock.getGroupCount(), dedupPage.getBlock(0));
        }

        private Page applyMaskChannelFilter(Page page, int maskChannel) {
            if (maskChannel >= 0) {
                return GenericAccumulatorFactory.filter(page, page.getBlock(maskChannel + 1));
            }
            return page;
        }

        private Block computeDistinctMask(Page page, MarkDistinctHash hash) {
            Work<Block> work = hash.markDistinctRows(page);
            Preconditions.checkState((boolean)work.process());
            return work.getResult();
        }

        private List<Page> getDistinctPages() {
            return this.hash.getDistinctPages();
        }

        private void reset() {
            this.hash = this.createMarkDistinctHash();
        }
    }

    private static class SpillableFinalOnlyGroupedAccumulator
    implements GroupedAccumulator {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SpillableFinalOnlyGroupedAccumulator.class).instanceSize();
        private final FinalOnlyGroupedAccumulator delegate;
        private final List<Type> sourceTypes;
        private final List<Type> spillingTypes;
        private final List<Integer> aggregateInputChannels;
        private ObjectBigArray<GroupIdPage> rawInputs = new ObjectBigArray();
        private IntBigArray groupIdCount = new IntBigArray();
        private ObjectBigArray<RowBlockBuilder> blockBuilders;
        private long rawInputsSizeInBytes;
        private long blockBuildersSizeInBytes;
        private long rawInputsLength;
        private final StandaloneSpiller standaloneSpiller;
        private final boolean isDistinctAggregationLargeBlockSpillEnabled;
        private final DataSize distinctAggregationLargeBlockSizeThreshold;

        public SpillableFinalOnlyGroupedAccumulator(List<Type> sourceTypes, List<Integer> aggregateInputChannels, FinalOnlyGroupedAccumulator delegate, StandaloneSpillerFactory standaloneSpillerFactory, Session session) {
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.aggregateInputChannels = Objects.requireNonNull(aggregateInputChannels, "aggregateInputChannels is null");
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            Objects.requireNonNull(standaloneSpillerFactory, "standaloneSpillerFactory is null");
            Objects.requireNonNull(session, "session is null");
            this.standaloneSpiller = standaloneSpillerFactory.create(session);
            this.isDistinctAggregationLargeBlockSpillEnabled = JavaWorkerSessionPropertyProvider.isDistinctAggregationLargeBlockSpillEnabled(session);
            this.distinctAggregationLargeBlockSizeThreshold = JavaWorkerSessionPropertyProvider.getDistinctAggregationLargeBlockSizeThreshold(session);
            this.spillingTypes = (List)aggregateInputChannels.stream().map(sourceTypes::get).collect(ImmutableList.toImmutableList());
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.delegate.getEstimatedSize() + (this.rawInputs == null ? 0L : this.rawInputsSizeInBytes + this.rawInputs.sizeOf()) + (this.groupIdCount == null ? 0L : this.groupIdCount.sizeOf()) + (this.blockBuilders == null ? 0L : this.blockBuildersSizeInBytes + this.blockBuilders.sizeOf());
        }

        public Type getFinalType() {
            return this.delegate.getFinalType();
        }

        public Type getIntermediateType() {
            if (this.isDistinctAggregationLargeBlockSpillEnabled) {
                return RowType.anonymous((List)ImmutableList.of((Object)this.getIntermediateFileHandleType(), (Object)this.getIntermediateRowsType()));
            }
            return this.getIntermediateRowsType();
        }

        private Type getIntermediateFileHandleType() {
            return VarcharType.VARCHAR;
        }

        private Type getIntermediateRowsType() {
            return new ArrayType((Type)RowType.anonymous(this.spillingTypes));
        }

        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            Preconditions.checkState((this.rawInputs != null && this.blockBuilders == null ? 1 : 0) != 0);
            Block[] blocks = new Block[this.aggregateInputChannels.size()];
            for (int i = 0; i < this.aggregateInputChannels.size(); ++i) {
                blocks[i] = page.getBlock(this.aggregateInputChannels.get(i).intValue());
            }
            Page accumulatorInputPage = Page.wrapBlocksWithoutCopy((int)page.getPositionCount(), (Block[])blocks);
            this.addRawInput(groupIdsBlock, accumulatorInputPage);
            this.updateGroupIdCount(groupIdsBlock);
        }

        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            Preconditions.checkState((this.rawInputs != null && this.blockBuilders == null ? 1 : 0) != 0);
            ArrayList<Long> newGroupIdsList = new ArrayList<Long>();
            ArrayList<Boolean> nullsList = new ArrayList<Boolean>();
            int newPositionCount = 0;
            if (this.isDistinctAggregationLargeBlockSpillEnabled) {
                Preconditions.checkState((boolean)(block instanceof RowBlock));
                RowBlock rowBlock = (RowBlock)block;
                PageBuilder pageBuilder = new PageBuilder(this.spillingTypes);
                for (int groupIdPosition = 0; groupIdPosition < groupIdsBlock.getPositionCount(); ++groupIdPosition) {
                    ColumnarRow columnarRow;
                    SingleRowBlock singleRowBlock = (SingleRowBlock)rowBlock.getBlock(groupIdPosition);
                    Block fileHandleBlock = singleRowBlock.getSingleValueBlock(0);
                    Slice fileHandleSlice = fileHandleBlock.getSlice(0, 0, fileHandleBlock.getSliceLength(0));
                    if (fileHandleSlice != Slices.EMPTY_SLICE) {
                        SerializedStorageHandle serializedStorageHandle = new SerializedStorageHandle(fileHandleSlice.byteArray());
                        ImmutableList pages = ImmutableList.copyOf(this.standaloneSpiller.getSpilledPages(serializedStorageHandle));
                        this.standaloneSpiller.remove(serializedStorageHandle);
                        newPositionCount += pages.stream().map(Page::getPositionCount).mapToInt(v -> v).sum();
                        for (Page page : pages) {
                            columnarRow = ColumnarRow.toColumnarRow((Block)page.getBlock(0));
                            for (int unused = 0; unused < columnarRow.getPositionCount() && !columnarRow.isNull(unused); ++unused) {
                                newGroupIdsList.add(groupIdsBlock.getGroupId(groupIdPosition));
                                nullsList.add(groupIdsBlock.isNull(groupIdPosition));
                            }
                            this.addToPageBuilder(pageBuilder, columnarRow);
                        }
                        continue;
                    }
                    Block arrayBlock = singleRowBlock.getSingleValueBlock(1);
                    ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)arrayBlock);
                    Block elementBlock = columnarArray.getElementsBlock();
                    columnarRow = ColumnarRow.toColumnarRow((Block)elementBlock);
                    newPositionCount += columnarRow.getNonNullPositionCount();
                    for (int unused = 0; unused < elementBlock.getPositionCount() && !elementBlock.isNull(unused); ++unused) {
                        newGroupIdsList.add(groupIdsBlock.getGroupId(groupIdPosition));
                        nullsList.add(groupIdsBlock.isNull(groupIdPosition));
                    }
                    this.addToPageBuilder(pageBuilder, columnarRow);
                }
                GroupByIdBlock squashedGroupIds = new GroupByIdBlock(groupIdsBlock.getGroupCount(), (Block)new LongArrayBlock(newPositionCount, Optional.of(Booleans.toArray(nullsList)), Longs.toArray(newGroupIdsList)));
                this.addRawInput(squashedGroupIds, pageBuilder.build());
            } else {
                Preconditions.checkState((boolean)(block instanceof ArrayBlock));
                ArrayBlock arrayBlock = (ArrayBlock)block;
                ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
                ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)columnarArray.getElementsBlock());
                newPositionCount = columnarRow.getNonNullPositionCount();
                for (int groupIdPosition = 0; groupIdPosition < groupIdsBlock.getPositionCount(); ++groupIdPosition) {
                    for (int unused = 0; unused < arrayBlock.getBlock(groupIdPosition).getPositionCount() && !arrayBlock.getBlock(groupIdPosition).isNull(unused); ++unused) {
                        newGroupIdsList.add(groupIdsBlock.getGroupId(groupIdPosition));
                        nullsList.add(groupIdsBlock.isNull(groupIdPosition));
                    }
                }
                Block[] blocks = new Block[this.spillingTypes.size()];
                for (int channel = 0; channel < this.spillingTypes.size(); ++channel) {
                    blocks[channel] = columnarRow.getField(channel);
                }
                Page page = new Page(blocks);
                GroupByIdBlock squashedGroupIds = new GroupByIdBlock(groupIdsBlock.getGroupCount(), (Block)new LongArrayBlock(newPositionCount, Optional.of(Booleans.toArray(nullsList)), Longs.toArray(newGroupIdsList)));
                this.addRawInput(squashedGroupIds, page);
            }
        }

        private void addToPageBuilder(PageBuilder pageBuilder, ColumnarRow columnarRow) {
            pageBuilder.declarePositions(columnarRow.getPositionCount());
            for (int i = 0; i < columnarRow.getPositionCount(); ++i) {
                for (int channel = 0; channel < this.spillingTypes.size(); ++channel) {
                    this.spillingTypes.get(channel).appendTo(columnarRow.getField(channel), i, pageBuilder.getBlockBuilder(channel));
                }
            }
        }

        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            Page page;
            Preconditions.checkState((output instanceof ArrayBlockBuilder || output instanceof RowBlockBuilder ? 1 : 0) != 0);
            if (this.blockBuilders == null) {
                Preconditions.checkState((this.rawInputs != null ? 1 : 0) != 0);
                this.blockBuilders = new ObjectBigArray();
                int i = 0;
                while ((long)i < this.rawInputsLength) {
                    GroupIdPage groupIdPage = (GroupIdPage)this.rawInputs.get((long)i);
                    page = groupIdPage.getPage();
                    GroupByIdBlock groupIdsBlock = groupIdPage.getGroupByIdBlock();
                    for (int position = 0; position < page.getPositionCount(); ++position) {
                        long currentGroupId = groupIdsBlock.getGroupId(position);
                        this.blockBuilders.ensureCapacity(currentGroupId);
                        RowBlockBuilder rowBlockBuilder = (RowBlockBuilder)this.blockBuilders.get(currentGroupId);
                        long currentRowBlockSizeInBytes = 0L;
                        if (rowBlockBuilder == null) {
                            rowBlockBuilder = new RowBlockBuilder(this.spillingTypes, null, this.groupIdCount.get(currentGroupId));
                        } else {
                            currentRowBlockSizeInBytes = rowBlockBuilder.getRetainedSizeInBytes();
                        }
                        SingleRowBlockWriter currentOutput = rowBlockBuilder.beginBlockEntry();
                        for (int channel = 0; channel < this.spillingTypes.size(); ++channel) {
                            this.spillingTypes.get(channel).appendTo(page.getBlock(channel), position, (BlockBuilder)currentOutput);
                        }
                        rowBlockBuilder.closeEntry();
                        this.blockBuildersSizeInBytes += rowBlockBuilder.getRetainedSizeInBytes() - currentRowBlockSizeInBytes;
                        this.blockBuilders.set(currentGroupId, (Object)rowBlockBuilder);
                    }
                    this.rawInputs.set((long)i, null);
                    ++i;
                }
                this.groupIdCount = null;
                this.rawInputs = null;
                this.rawInputsSizeInBytes = 0L;
                this.rawInputsLength = 0L;
            }
            BlockBuilder singleArrayBlockWriter = output.beginBlockEntry();
            Preconditions.checkState((this.rawInputs == null && this.blockBuilders != null ? 1 : 0) != 0);
            if ((long)groupId >= this.blockBuilders.getCapacity() || this.blockBuilders.get((long)groupId) == null) {
                this.writeIntermediateRow(singleArrayBlockWriter, null, null);
            } else {
                RowBlock rowBlock = (RowBlock)((RowBlockBuilder)this.blockBuilders.get((long)groupId)).build();
                if (this.isDistinctAggregationLargeBlockSpillEnabled) {
                    if (rowBlock.getSizeInBytes() > this.distinctAggregationLargeBlockSizeThreshold.toBytes()) {
                        page = new Page(new Block[]{rowBlock});
                        SerializedStorageHandle storageHandle = this.standaloneSpiller.spill((Iterator<Page>)Iterators.singletonIterator((Object)page));
                        this.writeIntermediateRow(singleArrayBlockWriter, Slices.wrappedBuffer((byte[])storageHandle.getSerializedStorageHandle()), null);
                    } else {
                        BlockBuilder intermediateRowBlockBuilder = this.getIntermediateRowsType().createBlockBuilder(null, rowBlock.getPositionCount());
                        BlockBuilder intermediateRowSingleArrayBlockWriter = intermediateRowBlockBuilder.beginBlockEntry();
                        for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                            intermediateRowSingleArrayBlockWriter.appendStructure(rowBlock.getBlock(i));
                        }
                        intermediateRowBlockBuilder.closeEntry();
                        this.writeIntermediateRow(singleArrayBlockWriter, null, intermediateRowBlockBuilder.build().getBlock(0));
                    }
                } else {
                    for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                        singleArrayBlockWriter.appendStructure(rowBlock.getBlock(i));
                    }
                }
                this.blockBuilders.set((long)groupId, null);
            }
            output.closeEntry();
        }

        private void writeIntermediateRow(BlockBuilder singleArrayBlockWriter, Slice fileHandle, Block squashedBlock) {
            if (this.isDistinctAggregationLargeBlockSpillEnabled) {
                if (fileHandle == null) {
                    singleArrayBlockWriter.appendNull();
                } else {
                    VarcharType.VARCHAR.writeSlice(singleArrayBlockWriter, fileHandle);
                }
            }
            if (squashedBlock == null) {
                singleArrayBlockWriter.appendNull();
            } else {
                singleArrayBlockWriter.appendStructure(squashedBlock);
            }
        }

        public void evaluateFinal(int groupId, BlockBuilder output) {
            Preconditions.checkState((this.rawInputs == null && this.blockBuilders == null ? 1 : 0) != 0);
            this.delegate.evaluateFinal(groupId, output);
        }

        public void prepareFinal() {
            Preconditions.checkState((this.rawInputs != null && this.blockBuilders == null ? 1 : 0) != 0);
            int i = 0;
            while ((long)i < this.rawInputsLength) {
                GroupIdPage groupIdPage = (GroupIdPage)this.rawInputs.get((long)i);
                Page page = groupIdPage.getPage();
                Block[] blocks = new Block[this.sourceTypes.size()];
                for (int channel = 0; channel < this.sourceTypes.size(); ++channel) {
                    blocks[channel] = this.aggregateInputChannels.contains(channel) ? page.getBlock(this.aggregateInputChannels.indexOf(channel)) : RunLengthEncodedBlock.create((Type)this.sourceTypes.get(channel), null, (int)page.getPositionCount());
                }
                this.delegate.addInput(groupIdPage.getGroupByIdBlock(), Page.wrapBlocksWithoutCopy((int)page.getPositionCount(), (Block[])blocks));
                ++i;
            }
            this.rawInputs = null;
            this.rawInputsSizeInBytes = 0L;
            this.rawInputsLength = 0L;
            this.delegate.prepareFinal();
        }

        protected long getRawInputsLength() {
            return this.rawInputsLength;
        }

        protected List<Type> getSpillingTypes() {
            return this.spillingTypes;
        }

        protected void addRawInput(GroupByIdBlock groupByIdBlock, Page page) {
            this.rawInputs.ensureCapacity(this.rawInputsLength);
            GroupIdPage groupIdPage = new GroupIdPage(groupByIdBlock, page);
            this.rawInputsSizeInBytes += groupIdPage.getRetainedSizeInBytes();
            this.rawInputs.set(this.rawInputsLength, (Object)groupIdPage);
            ++this.rawInputsLength;
        }

        protected void updateGroupIdCount(GroupByIdBlock groupIdsBlock) {
            for (int i = 0; i < groupIdsBlock.getPositionCount(); ++i) {
                long currentGroupId = groupIdsBlock.getGroupId(i);
                this.groupIdCount.ensureCapacity(currentGroupId);
                this.groupIdCount.increment(currentGroupId);
            }
        }
    }

    private static class OrderingGroupedAccumulator
    extends FinalOnlyGroupedAccumulator {
        private final GroupedAccumulator accumulator;
        private final List<Integer> orderByChannels;
        private final List<SortOrder> orderings;
        private final PagesIndex pagesIndex;
        private long groupCount;

        private OrderingGroupedAccumulator(GroupedAccumulator accumulator, List<Type> aggregationSourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory) {
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
            Objects.requireNonNull(aggregationSourceTypes, "aggregationSourceTypes is null");
            this.orderByChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderByChannels, "orderByChannels is null"));
            this.orderings = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderings, "orderings is null"));
            ArrayList<Type> pageIndexTypes = new ArrayList<Type>(aggregationSourceTypes);
            pageIndexTypes.add((Type)BigintType.BIGINT);
            this.pagesIndex = pagesIndexFactory.newPagesIndex(pageIndexTypes, 10000);
            this.groupCount = 0L;
        }

        public long getEstimatedSize() {
            return this.pagesIndex.getEstimatedSize().toBytes() + this.accumulator.getEstimatedSize();
        }

        public Type getFinalType() {
            return this.accumulator.getFinalType();
        }

        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            this.groupCount = Long.max(this.groupCount, groupIdsBlock.getGroupCount());
            this.pagesIndex.addPage(page.appendColumn((Block)groupIdsBlock));
        }

        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.accumulator.evaluateFinal(groupId, output);
        }

        public void prepareFinal() {
            this.pagesIndex.sort(this.orderByChannels, this.orderings);
            Iterator<Page> pagesIterator = this.pagesIndex.getSortedPages();
            pagesIterator.forEachRemaining(page -> {
                GroupByIdBlock groupIds = new GroupByIdBlock(this.groupCount, page.getBlock(page.getChannelCount() - 1));
                this.accumulator.addInput(groupIds, page);
            });
        }
    }

    private static class GroupIdPage {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupIdPage.class).instanceSize();
        private final GroupByIdBlock groupByIdBlock;
        private final Page page;

        public GroupIdPage(GroupByIdBlock groupByIdBlock, Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.groupByIdBlock = Objects.requireNonNull(groupByIdBlock, "groupByIdBlock is null");
        }

        public Page getPage() {
            return this.page;
        }

        public GroupByIdBlock getGroupByIdBlock() {
            return this.groupByIdBlock;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.groupByIdBlock.getRetainedSizeInBytes() + this.page.getRetainedSizeInBytes();
        }
    }
}

