/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Set;

public class DecimalSumAggregation
extends SqlAggregationFunction {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)18, (int)0);
    public static final DecimalSumAggregation DECIMAL_SUM_AGGREGATION = new DecimalSumAggregation();
    private static final String NAME = "sum";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputShortDecimal", LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputLongDecimal", LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "outputLongDecimal", LongDecimalWithOverflowState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "combine", LongDecimalWithOverflowState.class, LongDecimalWithOverflowState.class);

    public DecimalSumAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"decimal(38,s)", (Set)ImmutableSet.of((Object)"s")), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"))), FunctionKind.AGGREGATE);
    }

    public String getDescription() {
        return "Calculates the sum over the input values";
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type inputType = (Type)Iterables.getOnlyElement(SignatureBinder.applyBoundVariables(functionAndTypeManager, this.getSignature().getArgumentTypes(), boundVariables));
        Type outputType = SignatureBinder.applyBoundVariables(functionAndTypeManager, this.getSignature().getReturnType(), boundVariables);
        return DecimalSumAggregation.generateAggregation(inputType, outputType);
    }

    private static BuiltInAggregationFunctionImplementation generateAggregation(Type inputType, Type outputType) {
        Preconditions.checkArgument((boolean)(inputType instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalSumAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)inputType);
        Class<LongDecimalWithOverflowState> stateInterface = LongDecimalWithOverflowState.class;
        LongDecimalWithOverflowStateSerializer stateSerializer = new LongDecimalWithOverflowStateSerializer();
        MethodHandle inputFunction = ((DecimalType)inputType).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), DecimalSumAggregation.createInputParameterMetadata(inputType), inputFunction, COMBINE_FUNCTION, LONG_DECIMAL_OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)new LongDecimalWithOverflowStateFactory())), outputType);
        Type intermediateType = stateSerializer.getSerializedType();
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(LongDecimalWithOverflowState state, Block block, int position) {
        Slice currentSum = state.getLongDecimal();
        if (currentSum == null) {
            currentSum = UnscaledDecimal128Arithmetic.unscaledDecimal();
            state.setLongDecimal(currentSum);
        }
        state.addOverflow(UnscaledDecimal128Arithmetic.addWithOverflow((Slice)currentSum, (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)SHORT_DECIMAL_TYPE.getLong(block, position)), (Slice)currentSum));
    }

    public static void inputLongDecimal(LongDecimalWithOverflowState state, Block block, int position) {
        Slice currentSum = state.getLongDecimal();
        if (currentSum == null) {
            currentSum = UnscaledDecimal128Arithmetic.unscaledDecimal();
            state.setLongDecimal(currentSum);
        }
        state.addOverflow(UnscaledDecimal128Arithmetic.addWithOverflow((Slice)currentSum, (Slice)LONG_DECIMAL_TYPE.getSlice(block, position), (Slice)currentSum));
    }

    public static void combine(LongDecimalWithOverflowState state, LongDecimalWithOverflowState otherState) {
        long overflowToAdd = otherState.getOverflow();
        Slice currentState = state.getLongDecimal();
        Slice otherDecimal = otherState.getLongDecimal();
        if (currentState == null) {
            state.setLongDecimal(otherDecimal);
        } else {
            overflowToAdd += UnscaledDecimal128Arithmetic.addWithOverflow((Slice)currentState, (Slice)otherDecimal, (Slice)currentState);
        }
        state.addOverflow(overflowToAdd);
    }

    public static void outputLongDecimal(LongDecimalWithOverflowState state, BlockBuilder out) {
        Slice decimal = state.getLongDecimal();
        if (decimal == null) {
            out.appendNull();
        } else {
            if (state.getOverflow() != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)decimal);
            LONG_DECIMAL_TYPE.writeSlice(out, decimal);
        }
    }
}

