/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.operator.aggregation.HyperLogLogUtils;
import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;

@AggregationFunction(value="approx_set")
public final class ApproximateSetAggregation {
    public static final double DEFAULT_STANDARD_ERROR = 0.01625;
    private static final AccumulatorStateSerializer<HyperLogLogState> SERIALIZER = StateCompiler.generateStateSerializer(HyperLogLogState.class);

    private ApproximateSetAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="double") double value) {
        ApproximateSetAggregation.input(state, value, 0.01625);
    }

    @InputFunction
    @LiteralParameters(value={"x"})
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="varchar(x)") Slice value) {
        ApproximateSetAggregation.input(state, value, 0.01625);
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="bigint") long value) {
        ApproximateSetAggregation.input(state, value, 0.01625);
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="double") double value, @SqlType(value="double") double maxStandardError) {
        ApproximateSetAggregation.input(state, Double.doubleToLongBits(value), maxStandardError);
    }

    @InputFunction
    @LiteralParameters(value={"x"})
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="varchar(x)") Slice value, @SqlType(value="double") double maxStandardError) {
        HyperLogLog hll = HyperLogLogUtils.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        hll.add(value);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="bigint") long value, @SqlType(value="double") double maxStandardError) {
        HyperLogLog hll = HyperLogLogUtils.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        hll.add(value);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @CombineFunction
    public static void combineState(@AggregationState HyperLogLogState state, @AggregationState HyperLogLogState otherState) {
        HyperLogLogUtils.mergeState(state, otherState.getHyperLogLog());
    }

    @OutputFunction(value="HyperLogLog")
    public static void evaluateFinal(@AggregationState HyperLogLogState state, BlockBuilder out) {
        SERIALIZER.serialize((Object)state, out);
    }
}

