/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.util.DateTimeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.joda.time.DateTime;

@ThriftStruct
public class TaskStats {
    private final long createTimeInMillis;
    private final long firstStartTimeInMillis;
    private final long lastStartTimeInMillis;
    private final long lastEndTimeInMillis;
    private final long endTimeInMillis;
    private final long elapsedTimeInNanos;
    private final long queuedTimeInNanos;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int queuedPartitionedDrivers;
    private final long queuedPartitionedSplitsWeight;
    private final int runningDrivers;
    private final int runningPartitionedDrivers;
    private final long runningPartitionedSplitsWeight;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final int totalNewDrivers;
    private final int queuedNewDrivers;
    private final int runningNewDrivers;
    private final int completedNewDrivers;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final long userMemoryReservationInBytes;
    private final long revocableMemoryReservationInBytes;
    private final long systemMemoryReservationInBytes;
    private final long peakUserMemoryInBytes;
    private final long peakTotalMemoryInBytes;
    private final long peakNodeTotalMemoryInBytes;
    private final long totalScheduledTimeInNanos;
    private final long totalCpuTimeInNanos;
    private final long totalBlockedTimeInNanos;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final long totalAllocationInBytes;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final long processedInputDataSizeInBytes;
    private final long processedInputPositions;
    private final long outputDataSizeInBytes;
    private final long outputPositions;
    private final long physicalWrittenDataSizeInBytes;
    private final int fullGcCount;
    private final long fullGcTimeInMillis;
    private final List<PipelineStats> pipelines;
    private final RuntimeStats runtimeStats;

    public TaskStats(long createTimeInMillis, long endTimeInMillis) {
        this(createTimeInMillis, 0L, 0L, 0L, endTimeInMillis, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, (Set<BlockedReason>)ImmutableSet.of(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0, 0L, (List<PipelineStats>)ImmutableList.of(), new RuntimeStats());
    }

    public TaskStats(DateTime createTime, DateTime endTime) {
        this(DateTimeUtils.toTimeStampInMillis(createTime), 0L, 0L, 0L, DateTimeUtils.toTimeStampInMillis(endTime), 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, (Set<BlockedReason>)ImmutableSet.of(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0, 0L, (List<PipelineStats>)ImmutableList.of(), new RuntimeStats());
    }

    @JsonCreator
    @ThriftConstructor
    public TaskStats(@JsonProperty(value="createTimeInMillis") long createTimeInMillis, @JsonProperty(value="firstStartTimeInMillis") long firstStartTimeInMillis, @JsonProperty(value="lastStartTimeInMillis") long lastStartTimeInMillis, @JsonProperty(value="lastEndTimeInMillis") long lastEndTimeInMillis, @JsonProperty(value="endTimeInMillis") long endTimeInMillis, @JsonProperty(value="elapsedTimeInNanos") long elapsedTimeInNanos, @JsonProperty(value="queuedTimeInNanos") long queuedTimeInNanos, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="queuedPartitionedSplitsWeight") long queuedPartitionedSplitsWeight, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="runningPartitionedSplitsWeight") long runningPartitionedSplitsWeight, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalNewDrivers") int totalNewDrivers, @JsonProperty(value="queuedNewDrivers") int queuedNewDrivers, @JsonProperty(value="runningNewDrivers") int runningNewDrivers, @JsonProperty(value="completedNewDrivers") int completedNewDrivers, @JsonProperty(value="totalSplits") int totalSplits, @JsonProperty(value="queuedSplits") int queuedSplits, @JsonProperty(value="runningSplits") int runningSplits, @JsonProperty(value="completedSplits") int completedSplits, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="cumulativeTotalMemory") double cumulativeTotalMemory, @JsonProperty(value="userMemoryReservationInBytes") long userMemoryReservationInBytes, @JsonProperty(value="revocableMemoryReservationInBytes") long revocableMemoryReservationInBytes, @JsonProperty(value="systemMemoryReservationInBytes") long systemMemoryReservationInBytes, @JsonProperty(value="peakTotalMemoryInBytes") long peakTotalMemoryInBytes, @JsonProperty(value="peakUserMemoryInBytes") long peakUserMemoryInBytes, @JsonProperty(value="peakNodeTotalMemoryInBytes") long peakNodeTotalMemoryInBytes, @JsonProperty(value="totalScheduledTimeInNanos") long totalScheduledTimeInNanos, @JsonProperty(value="totalCpuTimeInNanos") long totalCpuTimeInNanos, @JsonProperty(value="totalBlockedTimeInNanos") long totalBlockedTimeInNanos, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocationInBytes") long totalAllocationInBytes, @JsonProperty(value="rawInputDataSizeInBytes") long rawInputDataSizeInBytes, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSizeInBytes") long processedInputDataSizeInBytes, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSizeInBytes") long outputDataSizeInBytes, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="fullGcCount") int fullGcCount, @JsonProperty(value="fullGcTimeInMillis") long fullGcTimeInMillis, @JsonProperty(value="pipelines") List<PipelineStats> pipelines, @JsonProperty(value="runtimeStats") RuntimeStats runtimeStats) {
        Preconditions.checkArgument((createTimeInMillis >= 0L ? 1 : 0) != 0, (Object)"createTimeInMillis is negative");
        this.createTimeInMillis = createTimeInMillis;
        this.firstStartTimeInMillis = firstStartTimeInMillis;
        this.lastStartTimeInMillis = lastStartTimeInMillis;
        this.lastEndTimeInMillis = lastEndTimeInMillis;
        this.endTimeInMillis = endTimeInMillis;
        this.elapsedTimeInNanos = elapsedTimeInNanos;
        this.queuedTimeInNanos = queuedTimeInNanos;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers is negative");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((queuedPartitionedSplitsWeight >= 0L ? 1 : 0) != 0, (Object)"queuedPartitionedSplitsWeight must be non-negative");
        this.queuedPartitionedSplitsWeight = queuedPartitionedSplitsWeight;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers is negative");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        Preconditions.checkArgument((runningPartitionedSplitsWeight >= 0L ? 1 : 0) != 0, (Object)"runningPartitionedSplitsWeight must be non-negative");
        this.runningPartitionedSplitsWeight = runningPartitionedSplitsWeight;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((totalNewDrivers >= 0 ? 1 : 0) != 0, (Object)"totalNewDrivers is negative");
        this.totalNewDrivers = totalNewDrivers;
        Preconditions.checkArgument((queuedNewDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedNewDrivers is negative");
        this.queuedNewDrivers = queuedNewDrivers;
        Preconditions.checkArgument((runningNewDrivers >= 0 ? 1 : 0) != 0, (Object)"runningNewDrivers is negative");
        this.runningNewDrivers = runningNewDrivers;
        Preconditions.checkArgument((completedNewDrivers >= 0 ? 1 : 0) != 0, (Object)"completedNewDrivers is negative");
        this.completedNewDrivers = completedNewDrivers;
        Preconditions.checkArgument((totalSplits >= 0 ? 1 : 0) != 0, (Object)"totalSplits is negative");
        this.totalSplits = totalSplits;
        Preconditions.checkArgument((queuedSplits >= 0 ? 1 : 0) != 0, (Object)"queuedSplits is negative");
        this.queuedSplits = queuedSplits;
        Preconditions.checkArgument((runningSplits >= 0 ? 1 : 0) != 0, (Object)"runningSplits is negative");
        this.runningSplits = runningSplits;
        Preconditions.checkArgument((completedSplits >= 0 ? 1 : 0) != 0, (Object)"completedSplits is negative");
        this.completedSplits = completedSplits;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        this.revocableMemoryReservationInBytes = revocableMemoryReservationInBytes;
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        this.peakTotalMemoryInBytes = peakTotalMemoryInBytes;
        this.peakUserMemoryInBytes = peakUserMemoryInBytes;
        this.peakNodeTotalMemoryInBytes = peakNodeTotalMemoryInBytes;
        this.totalScheduledTimeInNanos = totalScheduledTimeInNanos;
        this.totalCpuTimeInNanos = totalCpuTimeInNanos;
        this.totalBlockedTimeInNanos = totalBlockedTimeInNanos;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocationInBytes = totalAllocationInBytes;
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSizeInBytes = processedInputDataSizeInBytes;
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSizeInBytes = outputDataSizeInBytes;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        Preconditions.checkArgument((fullGcCount >= 0 ? 1 : 0) != 0, (Object)"fullGcCount is negative");
        this.fullGcCount = fullGcCount;
        this.fullGcTimeInMillis = fullGcTimeInMillis;
        this.pipelines = ImmutableList.copyOf((Collection)Objects.requireNonNull(pipelines, "pipelines is null"));
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
    }

    public DateTime getCreateTime() {
        return new DateTime(this.createTimeInMillis);
    }

    @JsonProperty
    @ThriftField(value=1)
    public long getCreateTimeInMillis() {
        return this.createTimeInMillis;
    }

    public DateTime getFirstStartTime() {
        return new DateTime(this.firstStartTimeInMillis);
    }

    @JsonProperty
    @ThriftField(value=2)
    public long getFirstStartTimeInMillis() {
        return this.firstStartTimeInMillis;
    }

    public DateTime getLastStartTime() {
        return new DateTime(this.lastStartTimeInMillis);
    }

    @JsonProperty
    @ThriftField(value=3)
    public long getLastStartTimeInMillis() {
        return this.lastStartTimeInMillis;
    }

    public DateTime getLastEndTime() {
        return new DateTime(this.lastEndTimeInMillis);
    }

    @JsonProperty
    @ThriftField(value=4)
    public long getLastEndTimeInMillis() {
        return this.lastEndTimeInMillis;
    }

    public DateTime getEndTime() {
        return new DateTime(this.endTimeInMillis);
    }

    @JsonProperty
    @ThriftField(value=5)
    public long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    @JsonProperty
    @ThriftField(value=6)
    public long getElapsedTimeInNanos() {
        return this.elapsedTimeInNanos;
    }

    @JsonProperty
    @ThriftField(value=7)
    public long getQueuedTimeInNanos() {
        return this.queuedTimeInNanos;
    }

    @JsonProperty
    @ThriftField(value=8)
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    @ThriftField(value=9)
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    @ThriftField(value=10)
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    @ThriftField(value=11)
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    @ThriftField(value=12)
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    @ThriftField(value=13)
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    @ThriftField(value=14)
    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    @JsonProperty
    @ThriftField(value=15)
    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=16)
    public long getRevocableMemoryReservationInBytes() {
        return this.revocableMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=17)
    public long getSystemMemoryReservationInBytes() {
        return this.systemMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=18)
    public long getPeakUserMemoryInBytes() {
        return this.peakUserMemoryInBytes;
    }

    @JsonProperty
    @ThriftField(value=19)
    public long getPeakTotalMemoryInBytes() {
        return this.peakTotalMemoryInBytes;
    }

    @JsonProperty
    @ThriftField(value=20)
    public long getPeakNodeTotalMemoryInBytes() {
        return this.peakNodeTotalMemoryInBytes;
    }

    @JsonProperty
    @ThriftField(value=21)
    public long getTotalScheduledTimeInNanos() {
        return this.totalScheduledTimeInNanos;
    }

    @JsonProperty
    @ThriftField(value=22)
    public long getTotalCpuTimeInNanos() {
        return this.totalCpuTimeInNanos;
    }

    @JsonProperty
    @ThriftField(value=23)
    public long getTotalBlockedTimeInNanos() {
        return this.totalBlockedTimeInNanos;
    }

    @JsonProperty
    @ThriftField(value=24)
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    @ThriftField(value=25)
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    @ThriftField(value=26)
    public long getTotalAllocationInBytes() {
        return this.totalAllocationInBytes;
    }

    @JsonProperty
    @ThriftField(value=27)
    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=28)
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    @ThriftField(value=29)
    public long getProcessedInputDataSizeInBytes() {
        return this.processedInputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=30)
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    @ThriftField(value=31)
    public long getOutputDataSizeInBytes() {
        return this.outputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=32)
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    @ThriftField(value=33)
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=34)
    public List<PipelineStats> getPipelines() {
        return this.pipelines;
    }

    @JsonProperty
    @ThriftField(value=35)
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    @ThriftField(value=36)
    public long getQueuedPartitionedSplitsWeight() {
        return this.queuedPartitionedSplitsWeight;
    }

    @JsonProperty
    @ThriftField(value=37)
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    @ThriftField(value=38)
    public long getRunningPartitionedSplitsWeight() {
        return this.runningPartitionedSplitsWeight;
    }

    @JsonProperty
    @ThriftField(value=39)
    public int getFullGcCount() {
        return this.fullGcCount;
    }

    @JsonProperty
    @ThriftField(value=40)
    public long getFullGcTimeInMillis() {
        return this.fullGcTimeInMillis;
    }

    @JsonProperty
    @ThriftField(value=41)
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    @JsonProperty
    @ThriftField(value=42)
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @JsonProperty
    @ThriftField(value=43)
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @JsonProperty
    @ThriftField(value=44)
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @JsonProperty
    @ThriftField(value=45)
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    @ThriftField(value=46)
    public int getTotalNewDrivers() {
        return this.totalNewDrivers;
    }

    @JsonProperty
    @ThriftField(value=47)
    public int getQueuedNewDrivers() {
        return this.queuedNewDrivers;
    }

    @JsonProperty
    @ThriftField(value=48)
    public int getRunningNewDrivers() {
        return this.runningNewDrivers;
    }

    @JsonProperty
    @ThriftField(value=49)
    public int getCompletedNewDrivers() {
        return this.completedNewDrivers;
    }

    public TaskStats summarize() {
        return new TaskStats(this.createTimeInMillis, this.firstStartTimeInMillis, this.lastStartTimeInMillis, this.lastEndTimeInMillis, this.endTimeInMillis, this.elapsedTimeInNanos, this.queuedTimeInNanos, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.queuedPartitionedSplitsWeight, this.runningDrivers, this.runningPartitionedDrivers, this.runningPartitionedSplitsWeight, this.blockedDrivers, this.completedDrivers, this.totalNewDrivers, this.queuedNewDrivers, this.runningNewDrivers, this.completedNewDrivers, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.cumulativeUserMemory, this.cumulativeTotalMemory, this.userMemoryReservationInBytes, this.revocableMemoryReservationInBytes, this.systemMemoryReservationInBytes, this.peakTotalMemoryInBytes, this.peakUserMemoryInBytes, this.peakNodeTotalMemoryInBytes, this.totalScheduledTimeInNanos, this.totalCpuTimeInNanos, this.totalBlockedTimeInNanos, this.fullyBlocked, this.blockedReasons, this.totalAllocationInBytes, this.rawInputDataSizeInBytes, this.rawInputPositions, this.processedInputDataSizeInBytes, this.processedInputPositions, this.outputDataSizeInBytes, this.outputPositions, this.physicalWrittenDataSizeInBytes, this.fullGcCount, this.fullGcTimeInMillis, (List<PipelineStats>)ImmutableList.of(), this.runtimeStats);
    }

    public TaskStats summarizeFinal() {
        return new TaskStats(this.createTimeInMillis, this.firstStartTimeInMillis, this.lastStartTimeInMillis, this.lastEndTimeInMillis, this.endTimeInMillis, this.elapsedTimeInNanos, this.queuedTimeInNanos, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.queuedPartitionedSplitsWeight, this.runningDrivers, this.runningPartitionedDrivers, this.runningPartitionedSplitsWeight, this.blockedDrivers, this.completedDrivers, this.totalNewDrivers, this.queuedNewDrivers, this.runningNewDrivers, this.completedNewDrivers, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.cumulativeUserMemory, this.cumulativeTotalMemory, this.userMemoryReservationInBytes, this.revocableMemoryReservationInBytes, this.systemMemoryReservationInBytes, this.peakTotalMemoryInBytes, this.peakUserMemoryInBytes, this.peakNodeTotalMemoryInBytes, this.totalScheduledTimeInNanos, this.totalCpuTimeInNanos, this.totalBlockedTimeInNanos, this.fullyBlocked, this.blockedReasons, this.totalAllocationInBytes, this.rawInputDataSizeInBytes, this.rawInputPositions, this.processedInputDataSizeInBytes, this.processedInputPositions, this.outputDataSizeInBytes, this.outputPositions, this.physicalWrittenDataSizeInBytes, this.fullGcCount, this.fullGcTimeInMillis, TaskStats.summarizePipelineStats(this.pipelines), this.runtimeStats);
    }

    private static List<PipelineStats> summarizePipelineStats(List<PipelineStats> pipelines) {
        ImmutableList.Builder results = ImmutableList.builderWithExpectedSize((int)pipelines.size());
        for (PipelineStats pipeline : pipelines) {
            results.add((Object)pipeline.summarize());
        }
        return results.build();
    }
}

