/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.presto.Session;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskMetadataContext;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.LazyOutputBuffer;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.VoidTraversingQueryContextVisitor;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorMemoryReservationSummary;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskMemoryReservationSummary;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TaskContext {
    private final QueryContext queryContext;
    private final TaskStateMachine taskStateMachine;
    private final GcMonitor gcMonitor;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final Session session;
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong startFullGcCount = new AtomicLong(-1L);
    private final AtomicLong startFullGcTimeNanos = new AtomicLong(-1L);
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicLong endFullGcCount = new AtomicLong(-1L);
    private final AtomicLong endFullGcTimeNanos = new AtomicLong(-1L);
    private final AtomicLong executionStartTime = new AtomicLong();
    private final AtomicLong lastExecutionStartTime = new AtomicLong();
    private final AtomicLong executionEndTime = new AtomicLong();
    private final Set<Lifespan> completedDriverGroups = Sets.newConcurrentHashSet();
    private final List<PipelineContext> pipelineContexts = new CopyOnWriteArrayList<PipelineContext>();
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;
    private final boolean perOperatorAllocationTrackingEnabled;
    private final boolean allocationTrackingEnabled;
    private final boolean legacyLifespanCompletionCondition;
    private final Object cumulativeMemoryLock = new Object();
    private final AtomicDouble cumulativeUserMemory = new AtomicDouble(0.0);
    private final AtomicDouble cumulativeTotalMemory = new AtomicDouble(0.0);
    private final AtomicLong peakTotalMemoryInBytes = new AtomicLong(0L);
    private final AtomicLong peakUserMemoryInBytes = new AtomicLong(0L);
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastUserMemoryReservation;
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastTotalMemoryReservation;
    @GuardedBy(value="cumulativeMemoryLock")
    private long lastTaskStatCallNanos;
    private final MemoryTrackingContext taskMemoryContext;
    private final TaskMetadataContext taskMetadataContext;
    private final Optional<PlanNode> taskPlan;
    private final RuntimeStats runtimeStats = new RuntimeStats();

    public static TaskContext createTaskContext(QueryContext queryContext, TaskStateMachine taskStateMachine, GcMonitor gcMonitor, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, MemoryTrackingContext taskMemoryContext, Optional<PlanNode> taskPlan, boolean perOperatorCpuTimerEnabled, boolean cpuTimerEnabled, boolean perOperatorAllocationTrackingEnabled, boolean allocationTrackingEnabled, boolean legacyLifespanCompletionCondition) {
        TaskContext taskContext = new TaskContext(queryContext, taskStateMachine, gcMonitor, notificationExecutor, yieldExecutor, session, taskMemoryContext, taskPlan, perOperatorCpuTimerEnabled, cpuTimerEnabled, perOperatorAllocationTrackingEnabled, allocationTrackingEnabled, legacyLifespanCompletionCondition);
        taskContext.initialize();
        return taskContext;
    }

    private TaskContext(QueryContext queryContext, TaskStateMachine taskStateMachine, GcMonitor gcMonitor, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, MemoryTrackingContext taskMemoryContext, Optional<PlanNode> taskPlan, boolean perOperatorCpuTimerEnabled, boolean cpuTimerEnabled, boolean perOperatorAllocationTrackingEnabled, boolean allocationTrackingEnabled, boolean legacyLifespanCompletionCondition) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.gcMonitor = Objects.requireNonNull(gcMonitor, "gcMonitor is null");
        this.queryContext = Objects.requireNonNull(queryContext, "queryContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.session = session;
        this.taskMemoryContext = Objects.requireNonNull(taskMemoryContext, "taskMemoryContext is null");
        this.taskPlan = Objects.requireNonNull(taskPlan, "taskPlan is null");
        taskMemoryContext.initializeLocalMemoryContexts(LazyOutputBuffer.class.getSimpleName());
        this.perOperatorCpuTimerEnabled = perOperatorCpuTimerEnabled;
        this.cpuTimerEnabled = cpuTimerEnabled;
        this.perOperatorAllocationTrackingEnabled = perOperatorAllocationTrackingEnabled;
        this.allocationTrackingEnabled = allocationTrackingEnabled;
        this.legacyLifespanCompletionCondition = legacyLifespanCompletionCondition;
        this.taskMetadataContext = new TaskMetadataContext();
    }

    private void initialize() {
        this.taskStateMachine.addStateChangeListener(this::updateStatsIfDone);
    }

    public TaskId getTaskId() {
        return this.taskStateMachine.getTaskId();
    }

    public PipelineContext addPipelineContext(int pipelineId, boolean inputPipeline, boolean outputPipeline, boolean partitioned) {
        PipelineContext pipelineContext = new PipelineContext(pipelineId, this, this.notificationExecutor, this.yieldExecutor, this.taskMemoryContext.newMemoryTrackingContext(), inputPipeline, outputPipeline, partitioned);
        this.pipelineContexts.add(pipelineContext);
        return pipelineContext;
    }

    public Session getSession() {
        return this.session;
    }

    public void start() {
        long now = System.currentTimeMillis();
        this.executionStartTime.compareAndSet(0L, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.startFullGcCount.compareAndSet(-1L, this.gcMonitor.getMajorGcCount());
        this.startFullGcTimeNanos.compareAndSet(-1L, this.gcMonitor.getMajorGcTime().roundTo(TimeUnit.NANOSECONDS));
        this.lastExecutionStartTime.set(now);
    }

    private void updateStatsIfDone(TaskState newState) {
        if (newState.isDone()) {
            long now = System.currentTimeMillis();
            long majorGcCount = this.gcMonitor.getMajorGcCount();
            long majorGcTime = this.gcMonitor.getMajorGcTime().roundTo(TimeUnit.NANOSECONDS);
            this.executionStartTime.compareAndSet(0L, now);
            this.startNanos.compareAndSet(0L, System.nanoTime());
            this.startFullGcCount.compareAndSet(-1L, majorGcCount);
            this.startFullGcTimeNanos.compareAndSet(-1L, majorGcTime);
            this.lastExecutionStartTime.compareAndSet(0L, now);
            this.executionEndTime.compareAndSet(0L, now);
            this.endNanos.compareAndSet(0L, System.nanoTime());
            this.endFullGcCount.compareAndSet(-1L, majorGcCount);
            this.endFullGcTimeNanos.compareAndSet(-1L, majorGcTime);
        }
    }

    public void failed(Throwable cause) {
        this.taskStateMachine.failed(cause);
    }

    public boolean isDone() {
        return this.taskStateMachine.getState().isDone();
    }

    public TaskState getState() {
        return this.taskStateMachine.getState();
    }

    public TaskMetadataContext getTaskMetadataContext() {
        return this.taskMetadataContext;
    }

    public DataSize getMemoryReservation() {
        return new DataSize((double)this.taskMemoryContext.getUserMemory(), DataSize.Unit.BYTE);
    }

    public DataSize getSystemMemoryReservation() {
        return new DataSize((double)this.taskMemoryContext.getSystemMemory(), DataSize.Unit.BYTE);
    }

    public Set<Lifespan> getCompletedDriverGroups() {
        return this.completedDriverGroups;
    }

    public void addCompletedDriverGroup(Lifespan driverGroup) {
        Preconditions.checkArgument((!driverGroup.isTaskWide() ? 1 : 0) != 0, (Object)"driverGroup is task-wide, not a driver group.");
        this.completedDriverGroups.add(driverGroup);
    }

    public List<PipelineContext> getPipelineContexts() {
        return this.pipelineContexts;
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        return this.queryContext.reserveSpill(bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.queryContext.freeSpill(bytes);
    }

    public LocalMemoryContext localSystemMemoryContext() {
        return this.taskMemoryContext.localSystemMemoryContext();
    }

    public void moreMemoryAvailable() {
        this.pipelineContexts.forEach(PipelineContext::moreMemoryAvailable);
    }

    public boolean isPerOperatorAllocationTrackingEnabled() {
        return this.perOperatorAllocationTrackingEnabled;
    }

    public boolean isAllocationTrackingEnabled() {
        return this.allocationTrackingEnabled;
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.perOperatorCpuTimerEnabled;
    }

    public boolean isCpuTimerEnabled() {
        return this.cpuTimerEnabled;
    }

    public boolean isLegacyLifespanCompletionCondition() {
        return this.legacyLifespanCompletionCondition;
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isInputPipeline()) continue;
            stat.merge(pipelineContext.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        for (PipelineContext pipelineContext : this.pipelineContexts) {
            if (!pipelineContext.isOutputPipeline()) continue;
            stat.merge(pipelineContext.getOutputPositions());
        }
        return stat;
    }

    public Duration getFullGcTime() {
        long startFullGcTimeNanos = this.startFullGcTimeNanos.get();
        if (startFullGcTimeNanos < 0L) {
            return new Duration(0.0, TimeUnit.MILLISECONDS);
        }
        long endFullGcTimeNanos = this.endFullGcTimeNanos.get();
        if (endFullGcTimeNanos < 0L) {
            endFullGcTimeNanos = this.gcMonitor.getMajorGcTime().roundTo(TimeUnit.NANOSECONDS);
        }
        return new Duration((double)Math.max(0L, endFullGcTimeNanos - startFullGcTimeNanos), TimeUnit.NANOSECONDS);
    }

    public int getFullGcCount() {
        long startFullGcCount = this.startFullGcCount.get();
        if (startFullGcCount < 0L) {
            return 0;
        }
        long endFullGcCount = this.endFullGcCount.get();
        if (endFullGcCount <= 0L) {
            endFullGcCount = this.gcMonitor.getMajorGcCount();
        }
        return Math.toIntExact(Math.max(0L, endFullGcCount - startFullGcCount));
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStats getTaskStats() {
        this.updateStatsIfDone(this.taskStateMachine.getState());
        ImmutableList pipelineStats = ImmutableList.copyOf((Iterable)Iterables.transform(this.pipelineContexts, PipelineContext::getPipelineStats));
        long lastExecutionEndTime = 0L;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int queuedPartitionedDrivers = 0;
        long queuedPartitionedSplitsWeight = 0L;
        int runningDrivers = 0;
        int runningPartitionedDrivers = 0;
        long runningPartitionedSplitsWeight = 0L;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalBlockedTime = 0L;
        long totalAllocation = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        RuntimeStats mergedRuntimeStats = RuntimeStats.copyOf((RuntimeStats)this.runtimeStats);
        ImmutableSet.Builder blockedReasons = ImmutableSet.builder();
        boolean hasRunningPipelines = false;
        boolean runningPipelinesFullyBlocked = true;
        for (PipelineStats pipeline : pipelineStats) {
            if (pipeline.getLastEndTimeInMillis() != 0L) {
                lastExecutionEndTime = Math.max(pipeline.getLastEndTimeInMillis(), lastExecutionEndTime);
            }
            if (pipeline.getRunningDrivers() > 0 || pipeline.getRunningPartitionedDrivers() > 0 || pipeline.getBlockedDrivers() > 0) {
                hasRunningPipelines = true;
                runningPipelinesFullyBlocked &= pipeline.isFullyBlocked();
                blockedReasons.addAll(pipeline.getBlockedReasons());
            }
            totalDrivers += pipeline.getTotalDrivers();
            queuedDrivers += pipeline.getQueuedDrivers();
            queuedPartitionedDrivers += pipeline.getQueuedPartitionedDrivers();
            queuedPartitionedSplitsWeight += pipeline.getQueuedPartitionedSplitsWeight();
            runningDrivers += pipeline.getRunningDrivers();
            runningPartitionedDrivers += pipeline.getRunningPartitionedDrivers();
            runningPartitionedSplitsWeight += pipeline.getRunningPartitionedSplitsWeight();
            blockedDrivers += pipeline.getBlockedDrivers();
            completedDrivers += pipeline.getCompletedDrivers();
            totalScheduledTime += pipeline.getTotalScheduledTimeInNanos();
            totalCpuTime += pipeline.getTotalCpuTimeInNanos();
            totalBlockedTime += pipeline.getTotalBlockedTimeInNanos();
            totalAllocation += pipeline.getTotalAllocationInBytes();
            if (pipeline.isInputPipeline()) {
                rawInputDataSize += pipeline.getRawInputDataSizeInBytes();
                rawInputPositions += pipeline.getRawInputPositions();
                processedInputDataSize += pipeline.getProcessedInputDataSizeInBytes();
                processedInputPositions += pipeline.getProcessedInputPositions();
            }
            if (pipeline.isOutputPipeline()) {
                outputDataSize += pipeline.getOutputDataSizeInBytes();
                outputPositions += pipeline.getOutputPositions();
            }
            physicalWrittenDataSize += pipeline.getPhysicalWrittenDataSizeInBytes();
            pipeline.getOperatorSummaries().stream().forEach(stats -> mergedRuntimeStats.mergeWith(stats.getRuntimeStats()));
        }
        long startNanos = this.startNanos.get();
        if (startNanos == 0L) {
            startNanos = System.nanoTime();
        }
        long queuedTimeInNanos = startNanos - this.createNanos;
        long endNanos = this.endNanos.get();
        long elapsedTimeInNanos = endNanos >= startNanos ? endNanos - this.createNanos : 0L;
        int fullGcCount = this.getFullGcCount();
        Duration fullGcTime = this.getFullGcTime();
        long userMemory = this.taskMemoryContext.getUserMemory();
        long systemMemory = this.taskMemoryContext.getSystemMemory();
        this.updatePeakMemory();
        Object object = this.cumulativeMemoryLock;
        synchronized (object) {
            if (this.lastTaskStatCallNanos == 0L) {
                this.lastTaskStatCallNanos = startNanos;
            }
            double sinceLastPeriodMillis = (double)(System.nanoTime() - this.lastTaskStatCallNanos) / 1000000.0;
            long averageUserMemoryForLastPeriod = (userMemory + this.lastUserMemoryReservation) / 2L;
            long averageTotalMemoryForLastPeriod = (userMemory + systemMemory + this.lastTotalMemoryReservation) / 2L;
            this.cumulativeUserMemory.addAndGet((double)averageUserMemoryForLastPeriod * sinceLastPeriodMillis);
            this.cumulativeTotalMemory.addAndGet((double)averageTotalMemoryForLastPeriod * sinceLastPeriodMillis);
            this.lastTaskStatCallNanos = System.nanoTime();
            this.lastUserMemoryReservation = userMemory;
            this.lastTotalMemoryReservation = systemMemory + userMemory;
        }
        boolean fullyBlocked = hasRunningPipelines && runningPipelinesFullyBlocked;
        return new TaskStats(this.taskStateMachine.getCreatedTimeInMillis(), this.executionStartTime.get(), this.lastExecutionStartTime.get(), lastExecutionEndTime, this.executionEndTime.get(), elapsedTimeInNanos, queuedTimeInNanos, totalDrivers, queuedDrivers, queuedPartitionedDrivers, queuedPartitionedSplitsWeight, runningDrivers, runningPartitionedDrivers, runningPartitionedSplitsWeight, blockedDrivers, completedDrivers, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, this.cumulativeUserMemory.get(), this.cumulativeTotalMemory.get(), userMemory, this.taskMemoryContext.getRevocableMemory(), systemMemory, this.peakTotalMemoryInBytes.get(), this.peakUserMemoryInBytes.get(), this.queryContext.getPeakNodeTotalMemory(), totalScheduledTime, totalCpuTime, totalBlockedTime, fullyBlocked && (runningDrivers > 0 || runningPartitionedDrivers > 0), (Set<BlockedReason>)blockedReasons.build(), totalAllocation, rawInputDataSize, rawInputPositions, processedInputDataSize, processedInputPositions, outputDataSize, outputPositions, physicalWrittenDataSize, fullGcCount, fullGcTime.toMillis(), (List<PipelineStats>)pipelineStats, mergedRuntimeStats);
    }

    public void updatePeakMemory() {
        long userMemory = this.taskMemoryContext.getUserMemory();
        long systemMemory = this.taskMemoryContext.getSystemMemory();
        this.peakTotalMemoryInBytes.accumulateAndGet(userMemory + systemMemory, Math::max);
        this.peakUserMemoryInBytes.accumulateAndGet(userMemory, Math::max);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitTaskContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.pipelineContexts.stream().map(pipelineContext -> pipelineContext.accept(visitor, context)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public synchronized MemoryTrackingContext getTaskMemoryContext() {
        return this.taskMemoryContext;
    }

    @VisibleForTesting
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public TaskMemoryReservationSummary getMemoryReservationSummary() {
        List<OperatorMemoryReservationSummary> operatorMemoryReservations = this.getOperatorMemoryReservations();
        long totalTaskMemoryReservationInBytes = operatorMemoryReservations.stream().map(OperatorMemoryReservationSummary::getTotal).mapToLong(DataSize::toBytes).sum();
        List topConsumers = (List)operatorMemoryReservations.stream().filter(summary -> summary.getTotal().toBytes() > 0L).sorted(Comparator.comparing(OperatorMemoryReservationSummary::getTotal).reversed()).limit(3L).collect(ImmutableList.toImmutableList());
        return new TaskMemoryReservationSummary(TaskContext.getShortTaskId(this.getTaskId()), DataSize.succinctBytes((long)totalTaskMemoryReservationInBytes), topConsumers);
    }

    private static String getShortTaskId(TaskId taskId) {
        return taskId.getStageExecutionId().getStageId().getId() + "." + taskId.getStageExecutionId().getId() + "." + taskId.getId();
    }

    private List<OperatorMemoryReservationSummary> getOperatorMemoryReservations() {
        ArrayListMultimap operatorContexts = ArrayListMultimap.create();
        this.accept(new VoidTraversingQueryContextVisitor<Void>((ListMultimap)operatorContexts){
            final /* synthetic */ ListMultimap val$operatorContexts;
            {
                this.val$operatorContexts = listMultimap;
            }

            @Override
            public Void visitOperatorContext(OperatorContext operatorContext, Void nothing) {
                this.val$operatorContexts.put((Object)ImmutableList.of((Object)operatorContext.getDriverContext().getPipelineContext().getPipelineId(), (Object)operatorContext.getOperatorId()), (Object)operatorContext);
                return null;
            }
        }, null);
        ImmutableList.Builder result = ImmutableList.builder();
        for (Collection operators : operatorContexts.asMap().values()) {
            OperatorContext lastContext = (OperatorContext)Iterables.getLast((Iterable)operators);
            long totalOperatorMemoryReservationInBytes = 0L;
            ArrayList<Object> reservations = new ArrayList<Object>();
            for (OperatorContext context : operators) {
                long reservedTotalMemoryInBytes = context.getCurrentTotalMemoryReservationInBytes();
                totalOperatorMemoryReservationInBytes += reservedTotalMemoryInBytes;
                reservations.add(DataSize.succinctBytes((long)reservedTotalMemoryInBytes));
            }
            reservations.sort(Comparator.reverseOrder());
            result.add((Object)new OperatorMemoryReservationSummary(lastContext.getOperatorType(), lastContext.getPlanNodeId(), (List<DataSize>)ImmutableList.copyOf(reservations), DataSize.succinctBytes((long)totalOperatorMemoryReservationInBytes), this.getAdditionalOperatorInfo(lastContext)));
        }
        return result.build();
    }

    private Optional<String> getAdditionalOperatorInfo(OperatorContext context) {
        if (!this.taskPlan.isPresent()) {
            return Optional.empty();
        }
        if (context.getOperatorType().equals("HashBuilderOperator")) {
            Optional<JoinNode> planNode = this.findPlanNode(context.getPlanNodeId(), JoinNode.class);
            if (!planNode.isPresent()) {
                return Optional.empty();
            }
            String info = planNode.get().getType().toString() + ";";
            if (planNode.get().getDistributionType().isPresent()) {
                info = info + planNode.get().getDistributionType().get() + ";";
            }
            return Optional.of(info);
        }
        if (context.getOperatorType().equals("HashAggregationOperator") || context.getOperatorType().equals("AggregationOperator")) {
            Optional<AggregationNode> planNode = this.findPlanNode(context.getPlanNodeId(), AggregationNode.class);
            if (!planNode.isPresent()) {
                return Optional.empty();
            }
            boolean isDistinct = planNode.get().getAggregations().values().stream().anyMatch(AggregationNode.Aggregation::isDistinct);
            boolean isOrderBy = planNode.get().getAggregations().values().stream().anyMatch(aggregation -> aggregation.getOrderBy().isPresent());
            String info = planNode.get().getStep() + ";";
            if (isDistinct) {
                info = info + "DISTINCT;";
            }
            if (isOrderBy) {
                info = info + "ORDER_BY;";
            }
            return Optional.of(info);
        }
        return Optional.empty();
    }

    private <T extends PlanNode> Optional<T> findPlanNode(PlanNodeId planNodeId, Class<T> nodeType) {
        Preconditions.checkState((boolean)this.taskPlan.isPresent(), (Object)"taskPlan is expected to be present");
        return PlanNodeSearcher.searchFrom(this.taskPlan.get()).where(node -> node.getId().equals((Object)planNodeId) && nodeType.isInstance(node)).findSingle();
    }
}

