/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.EmptySplit;
import com.facebook.presto.split.EmptySplitPageSource;
import com.facebook.presto.split.PageSourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class TableScanOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final PageSourceProvider pageSourceProvider;
    private final TableHandle table;
    private final List<ColumnHandle> columns;
    private final LocalMemoryContext systemMemoryContext;
    private final SettableFuture<?> blocked = SettableFuture.create();
    private Split split;
    private ConnectorPageSource source;
    private boolean finished;
    private long completedBytes;
    private long completedPositions;
    private long readTimeNanos;

    public TableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
        this.systemMemoryContext = operatorContext.localSystemMemoryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(ScheduledSplit scheduledSplit) {
        Split split = Objects.requireNonNull(scheduledSplit, "scheduledSplit is null").getSplit();
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.split == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        if (this.finished) {
            return Optional::empty;
        }
        this.split = split;
        Object splitInfo = split.getInfo();
        Map<String, String> infoMap = split.getInfoMap();
        if (infoMap != null && !infoMap.isEmpty()) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(infoMap)));
        } else if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(splitInfo)));
        }
        this.blocked.set(null);
        if (split.getConnectorSplit() instanceof EmptySplit) {
            this.source = new EmptySplitPageSource();
        }
        return () -> {
            if (this.source instanceof UpdatablePageSource) {
                return Optional.of((UpdatablePageSource)this.source);
            }
            return Optional.empty();
        };
    }

    @Override
    public void noMoreSplits() {
        if (this.split == null) {
            this.finished = true;
        }
        this.blocked.set(null);
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void finish() {
        this.finished = true;
        this.blocked.set(null);
        if (this.source != null) {
            try {
                this.source.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.systemMemoryContext.setBytes(this.source.getSystemMemoryUsage());
        }
    }

    @Override
    public boolean isFinished() {
        if (!this.finished) {
            boolean bl = this.finished = this.source != null && this.source.isFinished();
            if (this.source != null) {
                this.systemMemoryContext.setBytes(this.source.getSystemMemoryUsage());
            }
        }
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.blocked.isDone()) {
            return this.blocked;
        }
        if (this.source != null) {
            CompletableFuture pageSourceBlocked = this.source.isBlocked();
            return pageSourceBlocked.isDone() ? NOT_BLOCKED : MoreFutures.toListenableFuture((CompletableFuture)pageSourceBlocked);
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        Page page;
        if (this.split == null) {
            return null;
        }
        if (this.source == null) {
            this.source = this.pageSourceProvider.createPageSource(this.operatorContext.getSession(), this.split, this.table, this.columns, this.operatorContext.getRuntimeStats());
        }
        if ((page = this.source.getNextPage()) != null) {
            page = page.getLoadedPage();
        }
        this.recordInputStats();
        this.systemMemoryContext.setBytes(this.source.getSystemMemoryUsage());
        return page;
    }

    private void recordInputStats() {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"source must not be null");
        long endCompletedBytes = this.source.getCompletedBytes();
        long endCompletedPositions = this.source.getCompletedPositions();
        long endReadTimeNanos = this.source.getReadTimeNanos();
        long inputBytes = endCompletedBytes - this.completedBytes;
        long inputBytesReadTime = endReadTimeNanos - this.readTimeNanos;
        long positionCount = endCompletedPositions - this.completedPositions;
        this.operatorContext.recordProcessedInput(inputBytes, positionCount);
        this.operatorContext.recordRawInputWithTiming(inputBytes, positionCount, inputBytesReadTime);
        RuntimeStats runtimeStats = this.source.getRuntimeStats();
        if (runtimeStats != null) {
            runtimeStats.addMetricValueIgnoreZero("storageReadTimeNanos", RuntimeUnit.NANO, inputBytesReadTime);
            runtimeStats.addMetricValueIgnoreZero("storageReadDataBytes", RuntimeUnit.BYTE, inputBytes);
            this.operatorContext.updateStats(runtimeStats);
        }
        this.completedBytes = endCompletedBytes;
        this.completedPositions = endCompletedPositions;
        this.readTimeNanos = endReadTimeNanos;
    }

    public static class TableScanOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final TableHandle table;
        private final List<ColumnHandle> columns;
        private boolean closed;

        public TableScanOperatorFactory(int operatorId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, TableScanOperator.class.getSimpleName());
            return new TableScanOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.table, this.columns);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

