/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public class TableFinishInfo
implements OperatorInfo {
    private static final int JSON_LENGTH_LIMIT = Math.toIntExact(new DataSize(10.0, DataSize.Unit.MEGABYTE).toBytes());
    private static final JsonCodec<Object> INFO_CODEC = JsonCodec.jsonCodec(Object.class);
    private final String serializedConnectorOutputMetadata;
    private final boolean jsonLengthLimitExceeded;
    private final Duration statisticsWallTime;
    private final Duration statisticsCpuTime;

    public TableFinishInfo(Optional<ConnectorOutputMetadata> metadata, Duration statisticsWallTime, Duration statisticsCpuTime) {
        String serializedConnectorOutputMetadata = null;
        boolean jsonLengthLimitExceeded = false;
        if (metadata.isPresent()) {
            Optional serializedMetadata = INFO_CODEC.toJsonWithLengthLimit(metadata.get().getInfo(), JSON_LENGTH_LIMIT);
            if (!serializedMetadata.isPresent()) {
                serializedConnectorOutputMetadata = null;
                jsonLengthLimitExceeded = true;
            } else {
                serializedConnectorOutputMetadata = (String)serializedMetadata.get();
                jsonLengthLimitExceeded = false;
            }
        }
        this.serializedConnectorOutputMetadata = serializedConnectorOutputMetadata;
        this.jsonLengthLimitExceeded = jsonLengthLimitExceeded;
        this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
        this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
    }

    @JsonCreator
    @ThriftConstructor
    public TableFinishInfo(@JsonProperty(value="serializedConnectorOutputMetadata") String serializedConnectorOutputMetadata, @JsonProperty(value="jsonLengthLimitExceeded") boolean jsonLengthLimitExceeded, @JsonProperty(value="statisticsWallTime") Duration statisticsWallTime, @JsonProperty(value="statisticsCpuTime") Duration statisticsCpuTime) {
        this.serializedConnectorOutputMetadata = serializedConnectorOutputMetadata;
        this.jsonLengthLimitExceeded = jsonLengthLimitExceeded;
        this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
        this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
    }

    @JsonProperty
    @ThriftField(value=1)
    public String getSerializedConnectorOutputMetadata() {
        return this.serializedConnectorOutputMetadata;
    }

    @JsonProperty
    @ThriftField(value=2)
    public boolean isJsonLengthLimitExceeded() {
        return this.jsonLengthLimitExceeded;
    }

    @JsonProperty
    @ThriftField(value=3)
    public Duration getStatisticsWallTime() {
        return this.statisticsWallTime;
    }

    @JsonProperty
    @ThriftField(value=4)
    public Duration getStatisticsCpuTime() {
        return this.statisticsCpuTime;
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

