/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceProvider;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntPredicate;

public final class StaticLookupSourceProvider
implements LookupSourceProvider {
    private final LookupSource lookupSource;

    public StaticLookupSourceProvider(LookupSource lookupSource) {
        this.lookupSource = Objects.requireNonNull(lookupSource, "lookupSource is null");
    }

    @Override
    public <R> R withLease(Function<LookupSourceProvider.LookupSourceLease, R> action) {
        return action.apply(new SimpleLookupSourceLease());
    }

    @Override
    public void close() {
        this.lookupSource.close();
    }

    private class SimpleLookupSourceLease
    implements LookupSourceProvider.LookupSourceLease {
        private SimpleLookupSourceLease() {
        }

        @Override
        public LookupSource getLookupSource() {
            return StaticLookupSourceProvider.this.lookupSource;
        }

        @Override
        public boolean hasSpilled() {
            return false;
        }

        @Override
        public long spillEpoch() {
            return 0L;
        }

        @Override
        public IntPredicate getSpillMask() {
            return i -> false;
        }
    }
}

