/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupedTopNBuilder;
import com.facebook.presto.operator.InMemoryGroupedTopNBuilder;
import com.facebook.presto.operator.MergeHashSort;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.operator.SpillingUtils;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spiller.Spiller;
import com.facebook.presto.spiller.SpillerFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class SpillableGroupedTopNBuilder
implements GroupedTopNBuilder {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(SpillableGroupedTopNBuilder.class).instanceSize();
    private final Supplier<InMemoryGroupedTopNBuilder> inputInMemoryGroupedTopNBuilderSupplier;
    private final Supplier<InMemoryGroupedTopNBuilder> outputInMemoryGroupedTopNBuilderSupplier;
    private final Supplier<ListenableFuture<?>> memoryWaitingFutureSupplier;
    private final SpillerFactory spillerFactory;
    private final List<Type> sourceTypes;
    private final List<Type> partitionTypes;
    private final List<Integer> partitionChannels;
    private InMemoryGroupedTopNBuilder inputInMemoryGroupedTopNBuilder;
    private InMemoryGroupedTopNBuilder outputInMemoryGroupedTopNBuilder;
    private final LocalMemoryContext localUserMemoryContext;
    private final LocalMemoryContext localRevocableMemoryContext;
    private final AggregatedMemoryContext aggregatedMemoryContextForMerge;
    private final AggregatedMemoryContext aggregatedMemoryContextForSpill;
    private final DriverYieldSignal driverYieldSignal;
    private final SpillContext spillContext;
    private final long unspillMemoryLimit;
    private Optional<Spiller> spiller = Optional.empty();
    private ListenableFuture<?> spillInProgress = Futures.immediateFuture(null);

    public SpillableGroupedTopNBuilder(List<Type> sourceTypes, List<Type> partitionTypes, List<Integer> partitionChannels, Supplier<InMemoryGroupedTopNBuilder> inputInMemoryGroupedTopNBuilderSupplier, Supplier<InMemoryGroupedTopNBuilder> outputInMemoryGroupedTopNBuilderSupplier, Supplier<ListenableFuture<?>> memoryWaitingFutureSupplier, long unspillMemoryLimit, LocalMemoryContext localUserMemoryContext, LocalMemoryContext localRevocableMemoryContext, AggregatedMemoryContext aggregatedMemoryContextForMerge, AggregatedMemoryContext aggregatedMemoryContextForSpill, SpillContext spillContext, DriverYieldSignal driverYieldSignal, SpillerFactory spillerFactory) {
        this.inputInMemoryGroupedTopNBuilderSupplier = Objects.requireNonNull(inputInMemoryGroupedTopNBuilderSupplier, "inputInMemoryGroupedTopNBuilderSupplier cannot be null");
        this.outputInMemoryGroupedTopNBuilderSupplier = Objects.requireNonNull(outputInMemoryGroupedTopNBuilderSupplier, "outputInMemoryGroupedTopNBuilderSupplier cannot be null");
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory cannot be null");
        this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes cannot be null");
        this.partitionTypes = Objects.requireNonNull(partitionTypes, "partitionTypes cannot be null");
        this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels cannot be null");
        this.initializeInputInMemoryGroupedTopNBuilder();
        this.localUserMemoryContext = Objects.requireNonNull(localUserMemoryContext, "localUserMemoryContext cannot be null");
        this.localRevocableMemoryContext = Objects.requireNonNull(localRevocableMemoryContext, "localRevocableMemoryContext cannot be null");
        this.aggregatedMemoryContextForMerge = Objects.requireNonNull(aggregatedMemoryContextForMerge, "aggregatedMemoryContextForMerge cannot be null");
        this.aggregatedMemoryContextForSpill = Objects.requireNonNull(aggregatedMemoryContextForSpill, "aggregatedMemoryContextForSpill cannot be null");
        this.driverYieldSignal = Objects.requireNonNull(driverYieldSignal, "driverYieldSignal cannot be null");
        this.spillContext = Objects.requireNonNull(spillContext, "spillContext cannot be null");
        this.unspillMemoryLimit = Objects.requireNonNull(Long.valueOf(unspillMemoryLimit), "unspillMemoryLimit cannot be null");
        this.memoryWaitingFutureSupplier = memoryWaitingFutureSupplier;
    }

    @Override
    public Work<?> processPage(Page page) {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        return this.inputInMemoryGroupedTopNBuilder.processPage(page);
    }

    private boolean hasPreviousSpillCompletedSuccessfully() {
        if (this.spillInProgress.isDone()) {
            SpillingUtils.checkSpillSucceeded(this.spillInProgress);
            return true;
        }
        return false;
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        SpillingUtils.checkSpillSucceeded(this.spillInProgress);
        if (!this.spiller.isPresent() && (this.inputInMemoryGroupedTopNBuilder.isEmpty() || this.inputInMemoryGroupedTopNBuilder.migrateMemoryContext(this.localUserMemoryContext))) {
            return this.inputInMemoryGroupedTopNBuilder.buildResult();
        }
        SpillingUtils.checkSpillSucceeded(this.spillToDisk());
        Verify.verify((boolean)this.inputInMemoryGroupedTopNBuilder.isEmpty());
        this.updateMemoryReservations();
        ImmutableList sortedPageStreams = ImmutableList.builder().addAll((Iterable)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList())).build();
        return this.getFinalResult((List<WorkProcessor<Page>>)sortedPageStreams);
    }

    @Override
    public GroupByHash getGroupByHash() {
        return this.inputInMemoryGroupedTopNBuilder.getGroupByHash();
    }

    @Override
    public boolean isEmpty() {
        return this.inputInMemoryGroupedTopNBuilder.isEmpty() && this.outputInMemoryGroupedTopNBuilder.isEmpty();
    }

    @Override
    public long getEstimatedSizeInBytes() {
        return INSTANCE_SIZE + this.inputInMemoryGroupedTopNBuilder.getEstimatedSizeInBytes();
    }

    @Override
    public ListenableFuture<?> updateMemoryReservations() {
        ListenableFuture<?> inputBuilderFuture = this.inputInMemoryGroupedTopNBuilder.updateMemoryReservations();
        ListenableFuture<?> outputBuilderFuture = null;
        if (this.outputInMemoryGroupedTopNBuilder != null) {
            outputBuilderFuture = this.outputInMemoryGroupedTopNBuilder.updateMemoryReservations();
        }
        if (!inputBuilderFuture.isDone()) {
            return inputBuilderFuture;
        }
        if (outputBuilderFuture != null && !outputBuilderFuture.isDone()) {
            return outputBuilderFuture;
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            if (this.inputInMemoryGroupedTopNBuilder != null) {
                closer.register(this.inputInMemoryGroupedTopNBuilder::close);
            }
            if (this.outputInMemoryGroupedTopNBuilder != null) {
                closer.register(this.outputInMemoryGroupedTopNBuilder::close);
            }
            this.spiller.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            closer.register(() -> this.localUserMemoryContext.setBytes(0L));
            closer.register(() -> this.localRevocableMemoryContext.setBytes(0L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        Preconditions.checkState((boolean)this.spillInProgress.isDone());
        if (this.inputInMemoryGroupedTopNBuilder.isEmpty() || this.localRevocableMemoryContext.getBytes() == 0L) {
            return Operator.NOT_BLOCKED;
        }
        this.spillToDisk();
        return this.spillInProgress;
    }

    @Override
    public void finishMemoryRevoke() {
        if (this.spiller.isPresent()) {
            Preconditions.checkState((boolean)this.spillInProgress.isDone());
            Verify.verify((boolean)this.inputInMemoryGroupedTopNBuilder.isEmpty());
            this.spiller.get().commit();
        }
        this.updateMemoryReservations();
    }

    @VisibleForTesting
    private WorkProcessor<Page> getFinalResult(List<WorkProcessor<Page>> sortedPageStreams) {
        MergeHashSort mergeHashSort = new MergeHashSort(this.aggregatedMemoryContextForMerge);
        WorkProcessor<Page> mergedSortedPages = mergeHashSort.merge(this.partitionTypes, this.partitionChannels, this.sourceTypes, sortedPageStreams, this.driverYieldSignal);
        this.initializeOutputInMemoryGroupedTopNBuilder();
        return mergedSortedPages.flatTransform(new WorkProcessor.Transformation<Page, WorkProcessor<Page>>(){

            @Override
            public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Optional<Page> inputPageOptional) {
                boolean inputIsPresent = inputPageOptional.isPresent();
                if (!inputIsPresent && SpillableGroupedTopNBuilder.this.outputInMemoryGroupedTopNBuilder.isEmpty()) {
                    return WorkProcessor.TransformationState.finished();
                }
                if (inputIsPresent) {
                    Page inputPage = inputPageOptional.get();
                    boolean done = SpillableGroupedTopNBuilder.this.outputInMemoryGroupedTopNBuilder.processPage(inputPage).process();
                    if (!done) {
                        return WorkProcessor.TransformationState.blocked((ListenableFuture)SpillableGroupedTopNBuilder.this.memoryWaitingFutureSupplier.get());
                    }
                    if (SpillableGroupedTopNBuilder.this.outputInMemoryGroupedTopNBuilder.getEstimatedSizeInBytes() < SpillableGroupedTopNBuilder.this.unspillMemoryLimit) {
                        return WorkProcessor.TransformationState.needsMoreData();
                    }
                }
                WorkProcessor<Page> result = SpillableGroupedTopNBuilder.this.outputInMemoryGroupedTopNBuilder.buildResult();
                SpillableGroupedTopNBuilder.this.initializeOutputInMemoryGroupedTopNBuilder();
                return WorkProcessor.TransformationState.ofResult(result, inputIsPresent);
            }
        });
    }

    private ListenableFuture<?> spillToDisk() {
        if (!this.spiller.isPresent()) {
            this.spiller = Optional.of(this.spillerFactory.create(this.sourceTypes, this.spillContext, this.aggregatedMemoryContextForSpill));
        }
        this.spillInProgress = this.spiller.get().spill(this.inputInMemoryGroupedTopNBuilder.buildHashSortedIntermediateResult());
        this.initializeInputInMemoryGroupedTopNBuilder();
        return this.spillInProgress;
    }

    private void initializeInputInMemoryGroupedTopNBuilder() {
        if (this.inputInMemoryGroupedTopNBuilder != null) {
            this.inputInMemoryGroupedTopNBuilder.close();
        }
        this.inputInMemoryGroupedTopNBuilder = this.inputInMemoryGroupedTopNBuilderSupplier.get();
    }

    private void initializeOutputInMemoryGroupedTopNBuilder() {
        if (this.outputInMemoryGroupedTopNBuilder != null) {
            this.outputInMemoryGroupedTopNBuilder.close();
        }
        this.outputInMemoryGroupedTopNBuilder = this.outputInMemoryGroupedTopNBuilderSupplier.get();
    }

    @Override
    public Iterator<Page> buildHashSortedIntermediateResult() {
        throw new UnsupportedOperationException("SpillableGroupedTopNBuilder does not support buildHashSortedIntermediateResult");
    }

    @VisibleForTesting
    protected InMemoryGroupedTopNBuilder getInputInMemoryGroupedTopNBuilder() {
        return this.inputInMemoryGroupedTopNBuilder;
    }
}

