/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePageWithPositionComparator
implements PageWithPositionComparator {
    private final int[] sortChannels;
    private final SortOrder[] sortOrders;
    private final Type[] types;

    public SimplePageWithPositionComparator(List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Objects.requireNonNull(types, "types is null");
        this.sortChannels = Ints.toArray((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        this.sortOrders = Objects.requireNonNull(sortOrders, "sortOrders is null").toArray(new SortOrder[0]);
        Preconditions.checkArgument((this.sortOrders.length == this.sortChannels.length ? 1 : 0) != 0, (Object)"sortChannels and sortOrders length mismatch");
        this.types = new Type[this.sortChannels.length];
        for (int i = 0; i < this.sortChannels.length; ++i) {
            int channel = this.sortChannels[i];
            this.types[i] = types.get(channel);
            Preconditions.checkArgument((this.types[i] != null ? 1 : 0) != 0, (String)"type %s in types is null", (int)channel);
        }
    }

    @Override
    public int compareTo(Page left, int leftPosition, Page right, int rightPosition) {
        for (int i = 0; i < this.sortChannels.length; ++i) {
            int sortChannel = this.sortChannels[i];
            SortOrder sortOrder = this.sortOrders[i];
            Type type = this.types[i];
            Block leftBlock = left.getBlock(sortChannel);
            Block rightBlock = right.getBlock(sortChannel);
            try {
                int compare = sortOrder.compareBlockValue(type, leftBlock, leftPosition, rightBlock, rightPosition);
                if (compare == 0) continue;
                return compare;
            }
            catch (NotSupportedException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }
}

