/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.Session;
import com.facebook.presto.execution.FragmentResultCacheContext;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.PipelineStatus;
import com.facebook.presto.operator.TaskContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PipelineContext {
    private final TaskContext taskContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final int pipelineId;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final boolean partitioned;
    private final List<DriverContext> drivers = new CopyOnWriteArrayList<DriverContext>();
    private final AtomicInteger totalSplits = new AtomicInteger();
    private final AtomicLong totalSplitsWeight = new AtomicLong();
    private final AtomicInteger completedDrivers = new AtomicInteger();
    private final AtomicLong completedSplitsWeight = new AtomicLong();
    private final AtomicLong executionStartTime = new AtomicLong();
    private final AtomicLong lastExecutionStartTime = new AtomicLong();
    private final AtomicLong lastExecutionEndTime = new AtomicLong();
    private final Distribution queuedTime = new Distribution();
    private final Distribution elapsedTime = new Distribution();
    private final AtomicLong totalScheduledTime = new AtomicLong();
    private final AtomicLong totalCpuTime = new AtomicLong();
    private final AtomicLong totalBlockedTime = new AtomicLong();
    private final AtomicLong totalAllocation = new AtomicLong();
    private final CounterStat rawInputDataSize = new CounterStat();
    private final CounterStat rawInputPositions = new CounterStat();
    private final CounterStat processedInputDataSize = new CounterStat();
    private final CounterStat processedInputPositions = new CounterStat();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicLong physicalWrittenDataSize = new AtomicLong();
    private final ConcurrentMap<Integer, OperatorStats> operatorStatsById = new ConcurrentHashMap<Integer, OperatorStats>();
    private final MemoryTrackingContext pipelineMemoryContext;

    public PipelineContext(int pipelineId, TaskContext taskContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, MemoryTrackingContext pipelineMemoryContext, boolean inputPipeline, boolean outputPipeline, boolean partitioned) {
        this.pipelineId = pipelineId;
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        this.partitioned = partitioned;
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.pipelineMemoryContext = Objects.requireNonNull(pipelineMemoryContext, "pipelineMemoryContext is null");
        pipelineMemoryContext.initializeLocalMemoryContexts(ExchangeOperator.class.getSimpleName());
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public TaskId getTaskId() {
        return this.taskContext.getTaskId();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    public DriverContext addDriverContext() {
        return this.addDriverContext(0L, Lifespan.taskWide(), Optional.empty());
    }

    public DriverContext addDriverContext(long splitWeight, Lifespan lifespan, Optional<FragmentResultCacheContext> fragmentResultCacheContext) {
        Preconditions.checkArgument((this.partitioned || splitWeight == 0L ? 1 : 0) != 0, (Object)"Only partitioned splits should have weights");
        DriverContext driverContext = new DriverContext(this, this.notificationExecutor, this.yieldExecutor, this.pipelineMemoryContext.newMemoryTrackingContext(), lifespan, fragmentResultCacheContext, splitWeight);
        this.drivers.add(driverContext);
        return driverContext;
    }

    public Session getSession() {
        return this.taskContext.getSession();
    }

    public void splitsAdded(int count, long weightSum) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((weightSum >= 0L ? 1 : 0) != 0);
        this.totalSplits.addAndGet(count);
        if (this.partitioned && weightSum != 0L) {
            this.totalSplitsWeight.addAndGet(weightSum);
        }
    }

    public void driverFinished(DriverContext driverContext) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        if (!this.drivers.remove(driverContext)) {
            throw new IllegalArgumentException("Unknown driver " + driverContext);
        }
        this.lastExecutionEndTime.set(System.currentTimeMillis());
        DriverStats driverStats = driverContext.getDriverStats();
        this.completedDrivers.getAndIncrement();
        if (this.partitioned) {
            this.completedSplitsWeight.addAndGet(driverContext.getSplitWeight());
        }
        this.queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
        this.elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalScheduledTime.getAndAdd(driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalCpuTime.getAndAdd(driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalBlockedTime.getAndAdd(driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS));
        this.totalAllocation.getAndAdd(driverStats.getTotalAllocationInBytes());
        List<OperatorStats> operators = driverStats.getOperatorStats();
        for (OperatorStats operator : operators) {
            this.operatorStatsById.compute(operator.getOperatorId(), (operatorId, summaryStats) -> summaryStats == null ? operator : (OperatorStats)OperatorStats.merge((List<OperatorStats>)ImmutableList.of((Object)operator, (Object)summaryStats)).orElse(null));
        }
        this.rawInputDataSize.update(driverStats.getRawInputDataSizeInBytes());
        this.rawInputPositions.update(driverStats.getRawInputPositions());
        this.processedInputDataSize.update(driverStats.getProcessedInputDataSizeInBytes());
        this.processedInputPositions.update(driverStats.getProcessedInputPositions());
        this.outputDataSize.update(driverStats.getOutputDataSizeInBytes());
        this.outputPositions.update(driverStats.getOutputPositions());
        this.physicalWrittenDataSize.getAndAdd(driverStats.getPhysicalWrittenDataSizeInBytes());
    }

    public void start() {
        long now = System.currentTimeMillis();
        this.executionStartTime.compareAndSet(0L, now);
        this.lastExecutionStartTime.set(now);
        this.taskContext.start();
    }

    public void failed(Throwable cause) {
        this.taskContext.failed(cause);
    }

    public boolean isDone() {
        return this.taskContext.isDone();
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        return this.taskContext.reserveSpill(bytes);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.taskContext.freeSpill(bytes);
    }

    public LocalMemoryContext localSystemMemoryContext() {
        return this.pipelineMemoryContext.localSystemMemoryContext();
    }

    public void moreMemoryAvailable() {
        this.drivers.forEach(DriverContext::moreMemoryAvailable);
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.taskContext.isPerOperatorCpuTimerEnabled();
    }

    public boolean isCpuTimerEnabled() {
        return this.taskContext.isCpuTimerEnabled();
    }

    public boolean isPerOperatorAllocationTrackingEnabled() {
        return this.taskContext.isPerOperatorAllocationTrackingEnabled();
    }

    public boolean isAllocationTrackingEnabled() {
        return this.taskContext.isAllocationTrackingEnabled();
    }

    public CounterStat getInputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputDataSize());
        }
        return stat;
    }

    public CounterStat getInputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.rawInputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getInputPositions());
        }
        return stat;
    }

    public CounterStat getOutputDataSize() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputDataSize);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputDataSize());
        }
        return stat;
    }

    public CounterStat getOutputPositions() {
        CounterStat stat = new CounterStat();
        stat.merge(this.outputPositions);
        for (DriverContext driver : this.drivers) {
            stat.merge(driver.getOutputPositions());
        }
        return stat;
    }

    public long getPhysicalWrittenDataSize() {
        return this.drivers.stream().mapToLong(DriverContext::getPhysicalWrittenDataSize).sum();
    }

    public PipelineStatus getPipelineStatus() {
        return PipelineContext.getPipelineStatus(this.drivers.iterator(), this.totalSplits.get(), this.completedDrivers.get(), this.getActivePartitionedSplitsWeight(), this.partitioned);
    }

    private long getActivePartitionedSplitsWeight() {
        if (this.partitioned) {
            return this.totalSplitsWeight.get() - this.completedSplitsWeight.get();
        }
        return 0L;
    }

    public PipelineStats getPipelineStats() {
        if (this.taskContext.getState().isDone()) {
            long now = System.currentTimeMillis();
            this.executionStartTime.compareAndSet(0L, now);
            this.lastExecutionStartTime.compareAndSet(0L, now);
            this.lastExecutionEndTime.compareAndSet(0L, now);
        }
        int completedDrivers = this.completedDrivers.get();
        ImmutableList driverContexts = ImmutableList.copyOf(this.drivers);
        int totalSplits = this.totalSplits.get();
        PipelineStatusBuilder pipelineStatusBuilder = new PipelineStatusBuilder(totalSplits, completedDrivers, this.getActivePartitionedSplitsWeight(), this.partitioned);
        int totalDrivers = completedDrivers + driverContexts.size();
        Distribution queuedTime = new Distribution(this.queuedTime);
        Distribution elapsedTime = new Distribution(this.elapsedTime);
        long totalScheduledTime = this.totalScheduledTime.get();
        long totalCpuTime = this.totalCpuTime.get();
        long totalBlockedTime = this.totalBlockedTime.get();
        long totalAllocation = this.totalAllocation.get();
        long rawInputDataSize = this.rawInputDataSize.getTotalCount();
        long rawInputPositions = this.rawInputPositions.getTotalCount();
        long processedInputDataSize = this.processedInputDataSize.getTotalCount();
        long processedInputPositions = this.processedInputPositions.getTotalCount();
        long outputDataSize = this.outputDataSize.getTotalCount();
        long outputPositions = this.outputPositions.getTotalCount();
        long physicalWrittenDataSize = this.physicalWrittenDataSize.get();
        ImmutableSet.Builder blockedReasons = ImmutableSet.builder();
        boolean hasUnfinishedDrivers = false;
        boolean unfinishedDriversFullyBlocked = true;
        ImmutableList.Builder drivers = ImmutableList.builderWithExpectedSize((int)driverContexts.size());
        Map<Integer, List> operatorStatsById = this.operatorStatsById.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList<OperatorStats>(Arrays.asList((OperatorStats)e.getValue()))));
        for (DriverContext driverContext : driverContexts) {
            DriverStats driverStats = driverContext.getDriverStats();
            drivers.add((Object)driverStats);
            pipelineStatusBuilder.accumulate(driverStats, driverContext.getSplitWeight());
            if (driverStats.getStartTimeInMillis() != 0L && driverStats.getEndTimeInMillis() == 0L) {
                hasUnfinishedDrivers = true;
                unfinishedDriversFullyBlocked &= driverStats.isFullyBlocked();
                blockedReasons.addAll(driverStats.getBlockedReasons());
            }
            queuedTime.add(driverStats.getQueuedTime().roundTo(TimeUnit.NANOSECONDS));
            elapsedTime.add(driverStats.getElapsedTime().roundTo(TimeUnit.NANOSECONDS));
            totalScheduledTime += driverStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += driverStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += driverStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            totalAllocation += driverStats.getTotalAllocationInBytes();
            for (OperatorStats operatorStats : driverStats.getOperatorStats()) {
                operatorStatsById.computeIfAbsent(operatorStats.getOperatorId(), k -> new ArrayList()).add(operatorStats);
            }
            rawInputDataSize += driverStats.getRawInputDataSizeInBytes();
            rawInputPositions += driverStats.getRawInputPositions();
            processedInputDataSize += driverStats.getProcessedInputDataSizeInBytes();
            processedInputPositions += driverStats.getProcessedInputPositions();
            outputDataSize += driverStats.getOutputDataSizeInBytes();
            outputPositions += driverStats.getOutputPositions();
            physicalWrittenDataSize += driverStats.getPhysicalWrittenDataSizeInBytes();
        }
        PipelineStatus pipelineStatus = pipelineStatusBuilder.build();
        boolean fullyBlocked = hasUnfinishedDrivers && unfinishedDriversFullyBlocked;
        return new PipelineStats(this.pipelineId, this.executionStartTime.get(), this.lastExecutionStartTime.get(), this.lastExecutionEndTime.get(), this.inputPipeline, this.outputPipeline, totalDrivers, pipelineStatus.getQueuedDrivers(), pipelineStatus.getQueuedPartitionedDrivers(), pipelineStatus.getQueuedPartitionedSplitsWeight(), pipelineStatus.getRunningDrivers(), pipelineStatus.getRunningPartitionedDrivers(), pipelineStatus.getRunningPartitionedSplitsWeight(), pipelineStatus.getBlockedDrivers(), completedDrivers, this.pipelineMemoryContext.getUserMemory(), this.pipelineMemoryContext.getRevocableMemory(), this.pipelineMemoryContext.getSystemMemory(), queuedTime.snapshot(), elapsedTime.snapshot(), totalScheduledTime, totalCpuTime, totalBlockedTime, fullyBlocked, (Set<BlockedReason>)blockedReasons.build(), totalAllocation, rawInputDataSize, rawInputPositions, processedInputDataSize, processedInputPositions, outputDataSize, outputPositions, physicalWrittenDataSize, (List)operatorStatsById.values().stream().map(OperatorStats::merge).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList()), (List<DriverStats>)drivers.build());
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitPipelineContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.drivers.stream().map(driver -> driver.accept(visitor, context)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public MemoryTrackingContext getPipelineMemoryContext() {
        return this.pipelineMemoryContext;
    }

    private static PipelineStatus getPipelineStatus(Iterator<DriverContext> driverContextsIterator, int totalSplits, int completedDrivers, long activePartitionedSplitsWeight, boolean partitioned) {
        PipelineStatusBuilder builder = new PipelineStatusBuilder(totalSplits, completedDrivers, activePartitionedSplitsWeight, partitioned);
        while (driverContextsIterator.hasNext()) {
            builder.accumulate(driverContextsIterator.next());
        }
        return builder.build();
    }

    private static final class PipelineStatusBuilder {
        private final int totalSplits;
        private final int completedDrivers;
        private final long activePartitionedSplitsWeight;
        private final boolean partitioned;
        private int runningDrivers;
        private int blockedDrivers;
        private long runningSplitsWeight;
        private long blockedSplitsWeight;
        private int physicallyQueuedDrivers;

        private PipelineStatusBuilder(int totalSplits, int completedDrivers, long activePartitionedSplitsWeight, boolean partitioned) {
            this.totalSplits = totalSplits;
            this.partitioned = partitioned;
            this.completedDrivers = completedDrivers;
            this.activePartitionedSplitsWeight = activePartitionedSplitsWeight;
        }

        public void accumulate(DriverContext driverContext) {
            if (!driverContext.isExecutionStarted()) {
                ++this.physicallyQueuedDrivers;
            } else if (driverContext.isFullyBlocked()) {
                ++this.blockedDrivers;
                this.blockedSplitsWeight += driverContext.getSplitWeight();
            } else {
                ++this.runningDrivers;
                this.runningSplitsWeight += driverContext.getSplitWeight();
            }
        }

        public void accumulate(DriverStats driverStats, long splitWeight) {
            if (driverStats.getStartTimeInMillis() == 0L) {
                ++this.physicallyQueuedDrivers;
            } else if (driverStats.isFullyBlocked()) {
                ++this.blockedDrivers;
                this.blockedSplitsWeight += splitWeight;
            } else {
                ++this.runningDrivers;
                this.runningSplitsWeight += splitWeight;
            }
        }

        public PipelineStatus build() {
            long runningPartitionedSplitsWeight;
            int runningPartitionedSplits;
            int queuedPartitionedSplits;
            long queuedPartitionedSplitsWeight;
            int queuedDrivers;
            if (this.partitioned) {
                queuedDrivers = this.totalSplits - this.runningDrivers - this.blockedDrivers - this.completedDrivers;
                if (queuedDrivers < 0) {
                    queuedDrivers = 0;
                }
                queuedPartitionedSplitsWeight = this.activePartitionedSplitsWeight - this.runningSplitsWeight - this.blockedSplitsWeight;
                if (queuedDrivers == 0 || queuedPartitionedSplitsWeight < 0L) {
                    queuedPartitionedSplitsWeight = 0L;
                }
                queuedPartitionedSplits = queuedDrivers;
                runningPartitionedSplits = this.runningDrivers;
                runningPartitionedSplitsWeight = this.runningSplitsWeight;
            } else {
                queuedDrivers = this.physicallyQueuedDrivers;
                queuedPartitionedSplits = 0;
                queuedPartitionedSplitsWeight = 0L;
                runningPartitionedSplits = 0;
                runningPartitionedSplitsWeight = 0L;
            }
            return new PipelineStatus(queuedDrivers, this.runningDrivers, this.blockedDrivers, queuedPartitionedSplits, queuedPartitionedSplitsWeight, runningPartitionedSplits, runningPartitionedSplitsWeight);
        }
    }
}

