/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.util.DateTimeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.net.URI;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.joda.time.DateTime;

@ThriftStruct
public class PageBufferClientStatus {
    private final URI uri;
    private final String state;
    private final long lastUpdateInMillis;
    private final long rowsReceived;
    private final int pagesReceived;
    private final OptionalLong rowsRejected;
    private final OptionalInt pagesRejected;
    private final int requestsScheduled;
    private final int requestsCompleted;
    private final int requestsFailed;
    private final String httpRequestState;

    public PageBufferClientStatus(URI uri, String state, long lastUpdateInMillis, long rowsReceived, int pagesReceived, OptionalLong rowsRejected, OptionalInt pagesRejected, int requestsScheduled, int requestsCompleted, int requestsFailed, String httpRequestState) {
        this.uri = uri;
        this.state = state;
        this.lastUpdateInMillis = lastUpdateInMillis;
        this.rowsReceived = rowsReceived;
        this.pagesReceived = pagesReceived;
        this.rowsRejected = Objects.requireNonNull(rowsRejected, "rowsRejected is null");
        this.pagesRejected = Objects.requireNonNull(pagesRejected, "pagesRejected is null");
        this.requestsScheduled = requestsScheduled;
        this.requestsCompleted = requestsCompleted;
        this.requestsFailed = requestsFailed;
        this.httpRequestState = httpRequestState;
    }

    @JsonCreator
    @ThriftConstructor
    public PageBufferClientStatus(@JsonProperty(value="uri") URI uri, @JsonProperty(value="state") String state, @JsonProperty(value="lastUpdate") DateTime lastUpdate, @JsonProperty(value="rowsReceived") long rowsReceived, @JsonProperty(value="pagesReceived") int pagesReceived, @JsonProperty(value="rowsRejected") OptionalLong rowsRejected, @JsonProperty(value="pagesRejected") OptionalInt pagesRejected, @JsonProperty(value="requestsScheduled") int requestsScheduled, @JsonProperty(value="requestsCompleted") int requestsCompleted, @JsonProperty(value="requestsFailed") int requestsFailed, @JsonProperty(value="httpRequestState") String httpRequestState) {
        this(uri, state, DateTimeUtils.toTimeStampInMillis(lastUpdate), rowsReceived, pagesReceived, rowsRejected, pagesRejected, requestsScheduled, requestsCompleted, requestsFailed, httpRequestState);
    }

    @JsonProperty
    @ThriftField(value=1)
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty
    @ThriftField(value=2)
    public String getState() {
        return this.state;
    }

    @JsonProperty
    @ThriftField(value=3)
    public DateTime getLastUpdate() {
        return new DateTime(this.lastUpdateInMillis);
    }

    public long getLastUpdateInMillis() {
        return this.lastUpdateInMillis;
    }

    @JsonProperty
    @ThriftField(value=4)
    public long getRowsReceived() {
        return this.rowsReceived;
    }

    @JsonProperty
    @ThriftField(value=5)
    public int getPagesReceived() {
        return this.pagesReceived;
    }

    @JsonProperty
    @ThriftField(value=6)
    public OptionalLong getRowsRejected() {
        return this.rowsRejected;
    }

    @JsonProperty
    @ThriftField(value=7)
    public OptionalInt getPagesRejected() {
        return this.pagesRejected;
    }

    @JsonProperty
    @ThriftField(value=8)
    public int getRequestsScheduled() {
        return this.requestsScheduled;
    }

    @JsonProperty
    @ThriftField(value=9)
    public int getRequestsCompleted() {
        return this.requestsCompleted;
    }

    @JsonProperty
    @ThriftField(value=10)
    public int getRequestsFailed() {
        return this.requestsFailed;
    }

    @JsonProperty
    @ThriftField(value=11)
    public String getHttpRequestState() {
        return this.httpRequestState;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("state", (Object)this.state).add("lastUpdateInMillis", this.lastUpdateInMillis).add("rowsReceived", this.rowsReceived).add("pagesReceived", this.pagesReceived).add("httpRequestState", (Object)this.httpRequestState).toString();
    }
}

