/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DynamicFilterStats;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorInfoUnion;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class OperatorStats {
    private final int stageId;
    private final int stageExecutionId;
    private final int pipelineId;
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final long totalDrivers;
    private final long isBlockedCalls;
    private final Duration isBlockedWall;
    private final Duration isBlockedCpu;
    private final long isBlockedAllocationInBytes;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final long addInputAllocationInBytes;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final long inputDataSizeInBytes;
    private final long inputPositions;
    private final double sumSquaredInputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final long getOutputAllocationInBytes;
    private final long outputDataSizeInBytes;
    private final long outputPositions;
    private final long physicalWrittenDataSizeInBytes;
    private final Duration additionalCpu;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final long finishAllocationInBytes;
    private final long userMemoryReservationInBytes;
    private final long revocableMemoryReservationInBytes;
    private final long systemMemoryReservationInBytes;
    private final long peakUserMemoryReservationInBytes;
    private final long peakSystemMemoryReservationInBytes;
    private final long peakTotalMemoryReservationInBytes;
    private final long spilledDataSizeInBytes;
    private final Optional<BlockedReason> blockedReason;
    @Nullable
    private final OperatorInfo info;
    @Nullable
    private final OperatorInfoUnion infoUnion;
    private final RuntimeStats runtimeStats;
    private final DynamicFilterStats dynamicFilterStats;
    private final long nullJoinBuildKeyCount;
    private final long joinBuildKeyCount;
    private final long nullJoinProbeKeyCount;
    private final long joinProbeKeyCount;

    @JsonCreator
    public OperatorStats(@JsonProperty(value="stageId") int stageId, @JsonProperty(value="stageExecutionId") int stageExecutionId, @JsonProperty(value="pipelineId") int pipelineId, @JsonProperty(value="operatorId") int operatorId, @JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="operatorType") String operatorType, @JsonProperty(value="totalDrivers") long totalDrivers, @JsonProperty(value="isBlockedCalls") long isBlockedCalls, @JsonProperty(value="isBlockedWall") Duration isBlockedWall, @JsonProperty(value="isBlockedCpu") Duration isBlockedCpu, @JsonProperty(value="isBlockedAllocationInBytes") long isBlockedAllocationInBytes, @JsonProperty(value="addInputCalls") long addInputCalls, @JsonProperty(value="addInputWall") Duration addInputWall, @JsonProperty(value="addInputCpu") Duration addInputCpu, @JsonProperty(value="addInputAllocationInBytes") long addInputAllocationInBytes, @JsonProperty(value="rawInputDataSizeInBytes") long rawInputDataSizeInBytes, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="inputDataSizeInBytes") long inputDataSizeInBytes, @JsonProperty(value="inputPositions") long inputPositions, @JsonProperty(value="sumSquaredInputPositions") double sumSquaredInputPositions, @JsonProperty(value="getOutputCalls") long getOutputCalls, @JsonProperty(value="getOutputWall") Duration getOutputWall, @JsonProperty(value="getOutputCpu") Duration getOutputCpu, @JsonProperty(value="getOutputAllocationInBytes") long getOutputAllocationInBytes, @JsonProperty(value="outputDataSizeInBytes") long outputDataSizeInBytes, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="additionalCpu") Duration additionalCpu, @JsonProperty(value="blockedWall") Duration blockedWall, @JsonProperty(value="finishCalls") long finishCalls, @JsonProperty(value="finishWall") Duration finishWall, @JsonProperty(value="finishCpu") Duration finishCpu, @JsonProperty(value="finishAllocationInBytes") long finishAllocationInBytes, @JsonProperty(value="userMemoryReservationInBytes") long userMemoryReservationInBytes, @JsonProperty(value="revocableMemoryReservationInBytes") long revocableMemoryReservationInBytes, @JsonProperty(value="systemMemoryReservationInBytes") long systemMemoryReservationInBytes, @JsonProperty(value="peakUserMemoryReservationInBytes") long peakUserMemoryReservationInBytes, @JsonProperty(value="peakSystemMemoryReservationInBytes") long peakSystemMemoryReservationInBytes, @JsonProperty(value="peakTotalMemoryReservationInBytes") long peakTotalMemoryReservationInBytes, @JsonProperty(value="spilledDataSizeInBytes") long spilledDataSizeInBytes, @JsonProperty(value="blockedReason") Optional<BlockedReason> blockedReason, @Nullable @JsonProperty(value="info") OperatorInfo info, @JsonProperty(value="runtimeStats") RuntimeStats runtimeStats, @JsonProperty(value="dynamicFilterStats") DynamicFilterStats dynamicFilterStats, @JsonProperty(value="nullJoinBuildKeyCount") long nullJoinBuildKeyCount, @JsonProperty(value="joinBuildKeyCount") long joinBuildKeyCount, @JsonProperty(value="nullJoinProbeKeyCount") long nullJoinProbeKeyCount, @JsonProperty(value="joinProbeKeyCount") long joinProbeKeyCount) {
        this.stageId = stageId;
        this.stageExecutionId = stageExecutionId;
        this.pipelineId = pipelineId;
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.isBlockedCalls = isBlockedCalls;
        this.isBlockedWall = Objects.requireNonNull(isBlockedWall, "isBlockedWall is null");
        this.isBlockedCpu = Objects.requireNonNull(isBlockedCpu, "isBlockedCpu is null");
        Preconditions.checkArgument((isBlockedAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"isBlockedAllocationInBytes is negative");
        this.isBlockedAllocationInBytes = isBlockedAllocationInBytes;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        Preconditions.checkArgument((addInputAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"addInputAllocationInBytes is negative");
        this.addInputAllocationInBytes = addInputAllocationInBytes;
        Preconditions.checkArgument((rawInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"rawInputDataSizeInBytes is negative");
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        Preconditions.checkArgument((inputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"inputDataSizeInBytes is negative");
        this.inputDataSizeInBytes = inputDataSizeInBytes;
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        Preconditions.checkArgument((getOutputAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"getOutputAllocationInBytes is negative");
        this.getOutputAllocationInBytes = getOutputAllocationInBytes;
        this.outputDataSizeInBytes = outputDataSizeInBytes >= 0L ? outputDataSizeInBytes : Long.MAX_VALUE;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        Preconditions.checkArgument((physicalWrittenDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"writtenDataSizeInBytes is negative");
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        this.additionalCpu = Objects.requireNonNull(additionalCpu, "additionalCpu is negative");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        Preconditions.checkArgument((finishAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"finishAllocationInBytes is negative");
        this.finishAllocationInBytes = finishAllocationInBytes;
        Preconditions.checkArgument((userMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"userMemoryReservationInBytes is negative");
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        Preconditions.checkArgument((revocableMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"revocableMemoryReservationInBytes is negative");
        this.revocableMemoryReservationInBytes = revocableMemoryReservationInBytes;
        Preconditions.checkArgument((systemMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"systemMemoryReservationInBytes is negative");
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        Preconditions.checkArgument((peakUserMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakUserMemoryReservationInBytes is negative");
        this.peakUserMemoryReservationInBytes = peakUserMemoryReservationInBytes;
        Preconditions.checkArgument((peakSystemMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakSystemMemoryReservationInBytes is negative");
        this.peakSystemMemoryReservationInBytes = peakSystemMemoryReservationInBytes;
        Preconditions.checkArgument((peakTotalMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakTotalMemoryReservationInBytes is negative");
        this.peakTotalMemoryReservationInBytes = peakTotalMemoryReservationInBytes;
        Preconditions.checkArgument((spilledDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"spilledDataSizeInBytes is negative");
        this.spilledDataSizeInBytes = spilledDataSizeInBytes;
        this.runtimeStats = runtimeStats;
        this.dynamicFilterStats = dynamicFilterStats;
        this.blockedReason = blockedReason;
        this.info = info;
        this.infoUnion = null;
        this.nullJoinBuildKeyCount = nullJoinBuildKeyCount;
        this.joinBuildKeyCount = joinBuildKeyCount;
        this.nullJoinProbeKeyCount = nullJoinProbeKeyCount;
        this.joinProbeKeyCount = joinProbeKeyCount;
    }

    @ThriftConstructor
    public OperatorStats(int stageId, int stageExecutionId, int pipelineId, int operatorId, PlanNodeId planNodeId, String operatorType, long totalDrivers, long isBlockedCalls, Duration isBlockedWall, Duration isBlockedCpu, long isBlockedAllocationInBytes, long addInputCalls, Duration addInputWall, Duration addInputCpu, long addInputAllocationInBytes, long rawInputDataSizeInBytes, long rawInputPositions, long inputDataSizeInBytes, long inputPositions, double sumSquaredInputPositions, long getOutputCalls, Duration getOutputWall, Duration getOutputCpu, long getOutputAllocationInBytes, long outputDataSizeInBytes, long outputPositions, long physicalWrittenDataSizeInBytes, Duration additionalCpu, Duration blockedWall, long finishCalls, Duration finishWall, Duration finishCpu, long finishAllocationInBytes, long userMemoryReservationInBytes, long revocableMemoryReservationInBytes, long systemMemoryReservationInBytes, long peakUserMemoryReservationInBytes, long peakSystemMemoryReservationInBytes, long peakTotalMemoryReservationInBytes, long spilledDataSizeInBytes, Optional<BlockedReason> blockedReason, RuntimeStats runtimeStats, DynamicFilterStats dynamicFilterStats, @Nullable OperatorInfoUnion infoUnion, long nullJoinBuildKeyCount, long joinBuildKeyCount, long nullJoinProbeKeyCount, long joinProbeKeyCount) {
        this.stageId = stageId;
        this.stageExecutionId = stageExecutionId;
        this.pipelineId = pipelineId;
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.totalDrivers = totalDrivers;
        this.isBlockedCalls = isBlockedCalls;
        this.isBlockedWall = Objects.requireNonNull(isBlockedWall, "isBlockedWall is null");
        this.isBlockedCpu = Objects.requireNonNull(isBlockedCpu, "isBlockedCpu is null");
        Preconditions.checkArgument((isBlockedAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"isBlockedAllocation is negative");
        this.isBlockedAllocationInBytes = isBlockedAllocationInBytes;
        this.addInputCalls = addInputCalls;
        this.addInputWall = Objects.requireNonNull(addInputWall, "addInputWall is null");
        this.addInputCpu = Objects.requireNonNull(addInputCpu, "addInputCpu is null");
        Preconditions.checkArgument((addInputAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"addInputAllocation is negative");
        this.addInputAllocationInBytes = addInputAllocationInBytes;
        Preconditions.checkArgument((rawInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"rawInputDataSize is negative");
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        Preconditions.checkArgument((inputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"inputDataSize is negative");
        this.inputDataSizeInBytes = inputDataSizeInBytes;
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.sumSquaredInputPositions = sumSquaredInputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = Objects.requireNonNull(getOutputWall, "getOutputWall is null");
        this.getOutputCpu = Objects.requireNonNull(getOutputCpu, "getOutputCpu is null");
        Preconditions.checkArgument((getOutputAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"getOutputAllocation is negative");
        this.getOutputAllocationInBytes = getOutputAllocationInBytes;
        Preconditions.checkArgument((outputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"outputDataSize is negative");
        this.outputDataSizeInBytes = outputDataSizeInBytes;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        Preconditions.checkArgument((physicalWrittenDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"writtenDataSize is negative");
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        this.additionalCpu = Objects.requireNonNull(additionalCpu, "additionalCpu is null");
        this.blockedWall = Objects.requireNonNull(blockedWall, "blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = Objects.requireNonNull(finishWall, "finishWall is null");
        this.finishCpu = Objects.requireNonNull(finishCpu, "finishCpu is null");
        Preconditions.checkArgument((finishAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"finishAllocation is negative");
        this.finishAllocationInBytes = finishAllocationInBytes;
        Preconditions.checkArgument((userMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"userMemoryReservation is negative");
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        Preconditions.checkArgument((revocableMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"revocableMemoryReservation is negative");
        this.revocableMemoryReservationInBytes = revocableMemoryReservationInBytes;
        Preconditions.checkArgument((systemMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"systemMemoryReservation is negative");
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        Preconditions.checkArgument((peakUserMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakUserMemoryReservation is negative");
        this.peakUserMemoryReservationInBytes = peakUserMemoryReservationInBytes;
        Preconditions.checkArgument((peakSystemMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakSystemMemoryReservation is negative");
        this.peakSystemMemoryReservationInBytes = peakSystemMemoryReservationInBytes;
        Preconditions.checkArgument((peakTotalMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"peakTotalMemoryReservation is negative");
        this.peakTotalMemoryReservationInBytes = peakTotalMemoryReservationInBytes;
        Preconditions.checkArgument((spilledDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"spilledDataSize is negative");
        this.spilledDataSizeInBytes = spilledDataSizeInBytes;
        this.runtimeStats = runtimeStats;
        this.dynamicFilterStats = dynamicFilterStats;
        this.blockedReason = blockedReason;
        this.infoUnion = infoUnion;
        this.info = null;
        this.nullJoinBuildKeyCount = nullJoinBuildKeyCount;
        this.joinBuildKeyCount = joinBuildKeyCount;
        this.nullJoinProbeKeyCount = nullJoinProbeKeyCount;
        this.joinProbeKeyCount = joinProbeKeyCount;
    }

    @JsonProperty
    @ThriftField(value=1)
    public int getStageId() {
        return this.stageId;
    }

    @JsonProperty
    @ThriftField(value=2)
    public int getStageExecutionId() {
        return this.stageExecutionId;
    }

    @JsonProperty
    @ThriftField(value=3)
    public int getPipelineId() {
        return this.pipelineId;
    }

    @JsonProperty
    @ThriftField(value=4)
    public int getOperatorId() {
        return this.operatorId;
    }

    @JsonProperty
    @ThriftField(value=5)
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    @ThriftField(value=6)
    public String getOperatorType() {
        return this.operatorType;
    }

    @JsonProperty
    @ThriftField(value=7)
    public long getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    @ThriftField(value=8)
    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    @JsonProperty
    @ThriftField(value=9)
    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    @JsonProperty
    @ThriftField(value=10)
    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    @JsonProperty
    @ThriftField(value=11)
    public long getAddInputAllocationInBytes() {
        return this.addInputAllocationInBytes;
    }

    @JsonProperty
    @ThriftField(value=12)
    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=13)
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    @ThriftField(value=14)
    public long getInputDataSizeInBytes() {
        return this.inputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=15)
    public long getInputPositions() {
        return this.inputPositions;
    }

    @JsonProperty
    @ThriftField(value=16)
    public double getSumSquaredInputPositions() {
        return this.sumSquaredInputPositions;
    }

    @JsonProperty
    @ThriftField(value=17)
    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    @JsonProperty
    @ThriftField(value=18)
    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    @JsonProperty
    @ThriftField(value=19)
    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    @JsonProperty
    @ThriftField(value=20)
    public long getGetOutputAllocationInBytes() {
        return this.getOutputAllocationInBytes;
    }

    @JsonProperty
    @ThriftField(value=21)
    public long getOutputDataSizeInBytes() {
        return this.outputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=22)
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    @ThriftField(value=23)
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=24)
    public Duration getAdditionalCpu() {
        return this.additionalCpu;
    }

    @JsonProperty
    @ThriftField(value=25)
    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    @JsonProperty
    @ThriftField(value=26)
    public long getFinishCalls() {
        return this.finishCalls;
    }

    @JsonProperty
    @ThriftField(value=27)
    public Duration getFinishWall() {
        return this.finishWall;
    }

    @JsonProperty
    @ThriftField(value=28)
    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    @JsonProperty
    @ThriftField(value=29)
    public long getFinishAllocationInBytes() {
        return this.finishAllocationInBytes;
    }

    @JsonProperty
    @ThriftField(value=30)
    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=31)
    public long getRevocableMemoryReservationInBytes() {
        return this.revocableMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=32)
    public long getSystemMemoryReservationInBytes() {
        return this.systemMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=33)
    public long getPeakUserMemoryReservationInBytes() {
        return this.peakUserMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=34)
    public long getPeakSystemMemoryReservationInBytes() {
        return this.peakSystemMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=35)
    public long getPeakTotalMemoryReservationInBytes() {
        return this.peakTotalMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=36)
    public long getSpilledDataSizeInBytes() {
        return this.spilledDataSizeInBytes;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=37)
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    @JsonProperty
    @ThriftField(value=38)
    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    @Nullable
    @JsonProperty
    public OperatorInfo getInfo() {
        return this.info;
    }

    @Nullable
    @ThriftField(value=39)
    public OperatorInfoUnion getInfoUnion() {
        return this.infoUnion;
    }

    @JsonProperty
    @ThriftField(value=40)
    public long getNullJoinBuildKeyCount() {
        return this.nullJoinBuildKeyCount;
    }

    @JsonProperty
    @ThriftField(value=41)
    public long getJoinBuildKeyCount() {
        return this.joinBuildKeyCount;
    }

    @JsonProperty
    @ThriftField(value=42)
    public long getNullJoinProbeKeyCount() {
        return this.nullJoinProbeKeyCount;
    }

    @JsonProperty
    @ThriftField(value=43)
    public long getJoinProbeKeyCount() {
        return this.joinProbeKeyCount;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=44)
    public DynamicFilterStats getDynamicFilterStats() {
        return this.dynamicFilterStats;
    }

    @JsonProperty
    @ThriftField(value=45)
    public long getIsBlockedCalls() {
        return this.isBlockedCalls;
    }

    @JsonProperty
    @ThriftField(value=46)
    public Duration getIsBlockedWall() {
        return this.isBlockedWall;
    }

    @JsonProperty
    @ThriftField(value=47)
    public Duration getIsBlockedCpu() {
        return this.isBlockedCpu;
    }

    @JsonProperty
    @ThriftField(value=48)
    public long getIsBlockedAllocationInBytes() {
        return this.isBlockedAllocationInBytes;
    }

    public static Optional<OperatorStats> merge(List<OperatorStats> operators) {
        if (operators.isEmpty()) {
            return Optional.empty();
        }
        if (operators.size() == 1) {
            return Optional.of(operators.get(0));
        }
        OperatorStats first = (OperatorStats)operators.stream().findFirst().get();
        int stageId = first.getStageId();
        int operatorId = first.getOperatorId();
        int stageExecutionId = first.getStageExecutionId();
        int pipelineId = first.getPipelineId();
        PlanNodeId planNodeId = first.getPlanNodeId();
        String operatorType = first.getOperatorType();
        long totalDrivers = 0L;
        long isBlockedCalls = 0L;
        long isBlockedWall = 0L;
        long isBlockedCpu = 0L;
        long isBlockedAllocation = 0L;
        long addInputCalls = 0L;
        long addInputWall = 0L;
        long addInputCpu = 0L;
        double addInputAllocation = 0.0;
        double rawInputDataSize = 0.0;
        long rawInputPositions = 0L;
        double inputDataSize = 0.0;
        long inputPositions = 0L;
        double sumSquaredInputPositions = 0.0;
        long getOutputCalls = 0L;
        long getOutputWall = 0L;
        long getOutputCpu = 0L;
        double getOutputAllocation = 0.0;
        double outputDataSize = 0.0;
        long outputPositions = 0L;
        double physicalWrittenDataSize = 0.0;
        long additionalCpu = 0L;
        long blockedWall = 0L;
        long finishCalls = 0L;
        long finishWall = 0L;
        long finishCpu = 0L;
        long finishAllocation = 0L;
        double memoryReservation = 0.0;
        double revocableMemoryReservation = 0.0;
        double systemMemoryReservation = 0.0;
        double peakUserMemory = 0.0;
        double peakSystemMemory = 0.0;
        double peakTotalMemory = 0.0;
        double spilledDataSize = 0.0;
        long nullJoinBuildKeyCount = 0L;
        long joinBuildKeyCount = 0L;
        long nullJoinProbeKeyCount = 0L;
        long joinProbeKeyCount = 0L;
        RuntimeStats runtimeStats = new RuntimeStats();
        DynamicFilterStats dynamicFilterStats = new DynamicFilterStats(new HashSet<PlanNodeId>());
        Optional<BlockedReason> blockedReason = Optional.empty();
        boolean mergeInfo = first.getInfo() instanceof Mergeable;
        Mergeable<OperatorInfo> base = null;
        for (OperatorStats operator : operators) {
            Preconditions.checkArgument((operator.getOperatorId() == operatorId ? 1 : 0) != 0, (String)"Expected operatorId to be %s but was %s", (int)operatorId, (int)operator.getOperatorId());
            totalDrivers += operator.totalDrivers;
            isBlockedCalls += operator.getGetOutputCalls();
            isBlockedWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            isBlockedCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            isBlockedAllocation += operator.getIsBlockedAllocationInBytes();
            addInputCalls += operator.getAddInputCalls();
            addInputWall += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            addInputCpu += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            addInputAllocation += (double)operator.getAddInputAllocationInBytes();
            rawInputDataSize += (double)operator.getRawInputDataSizeInBytes();
            rawInputPositions += operator.getRawInputPositions();
            inputDataSize += (double)operator.getInputDataSizeInBytes();
            inputPositions += operator.getInputPositions();
            sumSquaredInputPositions += operator.getSumSquaredInputPositions();
            getOutputCalls += operator.getGetOutputCalls();
            getOutputWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            getOutputCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            getOutputAllocation += (double)operator.getGetOutputAllocationInBytes();
            outputDataSize += (double)operator.getOutputDataSizeInBytes();
            outputPositions += operator.getOutputPositions();
            physicalWrittenDataSize += (double)operator.getPhysicalWrittenDataSizeInBytes();
            finishCalls += operator.getFinishCalls();
            finishWall += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            finishCpu += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            finishAllocation += operator.getFinishAllocationInBytes();
            additionalCpu += operator.getAdditionalCpu().roundTo(TimeUnit.NANOSECONDS);
            blockedWall += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
            memoryReservation += (double)operator.getUserMemoryReservationInBytes();
            revocableMemoryReservation += (double)operator.getRevocableMemoryReservationInBytes();
            systemMemoryReservation += (double)operator.getSystemMemoryReservationInBytes();
            peakUserMemory = Math.max(peakUserMemory, (double)operator.getPeakUserMemoryReservationInBytes());
            peakSystemMemory = Math.max(peakSystemMemory, (double)operator.getPeakSystemMemoryReservationInBytes());
            peakTotalMemory = Math.max(peakTotalMemory, (double)operator.getPeakTotalMemoryReservationInBytes());
            spilledDataSize += (double)operator.getSpilledDataSizeInBytes();
            if (operator.getBlockedReason().isPresent()) {
                blockedReason = operator.getBlockedReason();
            }
            OperatorInfo info = operator.getInfo();
            if (mergeInfo) {
                if (base == null) {
                    base = (Mergeable<OperatorInfo>)((Object)info);
                } else if (info != null && info.getClass() == base.getClass()) {
                    base = OperatorStats.mergeInfo(base, info);
                }
            }
            runtimeStats.mergeWith(operator.getRuntimeStats());
            dynamicFilterStats.mergeWith(operator.getDynamicFilterStats());
            nullJoinBuildKeyCount += operator.getNullJoinBuildKeyCount();
            joinBuildKeyCount += operator.getJoinBuildKeyCount();
            nullJoinProbeKeyCount += operator.getNullJoinProbeKeyCount();
            joinProbeKeyCount += operator.getJoinProbeKeyCount();
        }
        return Optional.of(new OperatorStats(stageId, stageExecutionId, pipelineId, operatorId, planNodeId, operatorType, totalDrivers, isBlockedCalls, Duration.succinctNanos((long)isBlockedWall), Duration.succinctNanos((long)isBlockedCpu), isBlockedAllocation, addInputCalls, Duration.succinctNanos((long)addInputWall), Duration.succinctNanos((long)addInputCpu), (long)addInputAllocation, (long)rawInputDataSize, rawInputPositions, (long)inputDataSize, inputPositions, sumSquaredInputPositions, getOutputCalls, Duration.succinctNanos((long)getOutputWall), Duration.succinctNanos((long)getOutputCpu), (long)getOutputAllocation, (long)outputDataSize, outputPositions, (long)physicalWrittenDataSize, Duration.succinctNanos((long)additionalCpu), Duration.succinctNanos((long)blockedWall), finishCalls, Duration.succinctNanos((long)finishWall), Duration.succinctNanos((long)finishCpu), finishAllocation, (long)memoryReservation, (long)revocableMemoryReservation, (long)systemMemoryReservation, (long)peakUserMemory, (long)peakSystemMemory, (long)peakTotalMemory, (long)spilledDataSize, blockedReason, mergeInfo ? (OperatorInfo)((Object)base) : null, runtimeStats, dynamicFilterStats, nullJoinBuildKeyCount, joinBuildKeyCount, nullJoinProbeKeyCount, joinProbeKeyCount));
    }

    private static Mergeable<OperatorInfo> getMergeableInfoOrNull(OperatorInfo info) {
        Mergeable base = null;
        if (info instanceof Mergeable) {
            base = (Mergeable)((Object)info);
        }
        return base;
    }

    private static <T> Mergeable<T> mergeInfo(Mergeable<T> base, T other) {
        return (Mergeable)base.mergeWith(other);
    }

    public OperatorStats summarize() {
        if (this.info == null || this.info.isFinal()) {
            return this;
        }
        OperatorInfo info = null;
        return new OperatorStats(this.stageId, this.stageExecutionId, this.pipelineId, this.operatorId, this.planNodeId, this.operatorType, this.totalDrivers, this.isBlockedCalls, this.isBlockedWall, this.isBlockedCpu, this.isBlockedAllocationInBytes, this.addInputCalls, this.addInputWall, this.addInputCpu, this.addInputAllocationInBytes, this.rawInputDataSizeInBytes, this.rawInputPositions, this.inputDataSizeInBytes, this.inputPositions, this.sumSquaredInputPositions, this.getOutputCalls, this.getOutputWall, this.getOutputCpu, this.getOutputAllocationInBytes, this.outputDataSizeInBytes, this.outputPositions, this.physicalWrittenDataSizeInBytes, this.additionalCpu, this.blockedWall, this.finishCalls, this.finishWall, this.finishCpu, this.finishAllocationInBytes, this.userMemoryReservationInBytes, this.revocableMemoryReservationInBytes, this.systemMemoryReservationInBytes, this.peakUserMemoryReservationInBytes, this.peakSystemMemoryReservationInBytes, this.peakTotalMemoryReservationInBytes, this.spilledDataSizeInBytes, this.blockedReason, info, this.runtimeStats, this.dynamicFilterStats, this.nullJoinBuildKeyCount, this.joinBuildKeyCount, this.nullJoinProbeKeyCount, this.joinProbeKeyCount);
    }
}

