/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class LimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private Page nextPage;
    private long remainingLimit;

    public LimitOperator(OperatorContext operatorContext, long limit) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.remainingLimit = 0L;
    }

    @Override
    public boolean isFinished() {
        return this.remainingLimit == 0L && this.nextPage == null;
    }

    @Override
    public boolean needsInput() {
        return this.remainingLimit > 0L && this.nextPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        if ((long)page.getPositionCount() <= this.remainingLimit) {
            this.remainingLimit -= (long)page.getPositionCount();
            this.nextPage = page;
        } else {
            this.nextPage = page.getRegion(0, (int)this.remainingLimit);
            this.remainingLimit = 0L;
        }
    }

    @Override
    public Page getOutput() {
        Page page = this.nextPage;
        this.nextPage = null;
        return page;
    }

    public static class LimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final long limit;
        private boolean closed;

        public LimitOperatorFactory(int operatorId, PlanNodeId planNodeId, long limit) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.limit = limit;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LimitOperator.class.getSimpleName());
            return new LimitOperator(operatorContext, this.limit);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new LimitOperatorFactory(this.operatorId, this.planNodeId, this.limit);
        }
    }
}

