/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.annotation.Nullable;

public class InterpretedHashGenerator
implements HashGenerator {
    private final Type[] hashChannelTypes;
    @Nullable
    private final int[] hashChannels;

    public static InterpretedHashGenerator createPositionalWithTypes(List<Type> hashChannelTypes) {
        return new InterpretedHashGenerator(hashChannelTypes, null, true);
    }

    public InterpretedHashGenerator(List<Type> hashChannelTypes, List<Integer> hashChannels) {
        this(hashChannelTypes, Objects.requireNonNull(hashChannels).stream().mapToInt(i -> i).toArray());
    }

    public InterpretedHashGenerator(List<Type> hashChannelTypes, int[] hashChannels) {
        this(hashChannelTypes, Objects.requireNonNull(hashChannels, "hashChannels is null"), false);
    }

    private InterpretedHashGenerator(List<Type> hashChannelTypes, @Nullable int[] hashChannels, boolean positional) {
        this.hashChannelTypes = Objects.requireNonNull(hashChannelTypes, "hashChannelTypes is null").toArray(new Type[0]);
        if (positional) {
            Preconditions.checkArgument((hashChannels == null ? 1 : 0) != 0, (Object)"hashChannels must be null");
            this.hashChannels = null;
        } else {
            Objects.requireNonNull(hashChannels, "hashChannels is null");
            Preconditions.checkArgument((hashChannels.length == this.hashChannelTypes.length ? 1 : 0) != 0);
            this.hashChannels = InterpretedHashGenerator.isPositionalChannels(hashChannels) ? null : hashChannels;
        }
    }

    @Override
    public long hashPosition(int position, Page page) {
        long result = 0L;
        for (int i = 0; i < this.hashChannelTypes.length; ++i) {
            Block block = page.getBlock(this.hashChannels == null ? i : this.hashChannels[i]);
            result = CombineHashFunction.getHash(result, TypeUtils.hashPosition(this.hashChannelTypes[i], block, position));
        }
        return result;
    }

    public long hashPosition(int position, IntFunction<Block> blockProvider) {
        long result = 0L;
        for (int i = 0; i < this.hashChannelTypes.length; ++i) {
            Block block = blockProvider.apply(this.hashChannels == null ? i : this.hashChannels[i]);
            result = CombineHashFunction.getHash(result, TypeUtils.hashPosition(this.hashChannelTypes[i], block, position));
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashChannelTypes", (Object)this.hashChannelTypes).add("hashChannels", (Object)(this.hashChannels == null ? "<identity>" : Arrays.toString(this.hashChannels))).toString();
    }

    private static boolean isPositionalChannels(int[] hashChannels) {
        for (int i = 0; i < hashChannels.length; ++i) {
            if (hashChannels[i] == i) continue;
            return false;
        }
        return true;
    }
}

