/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class DriverStats {
    private final Lifespan lifespan;
    private final long createTimeInMillis;
    private final long startTimeInMillis;
    private final long endTimeInMillis;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final long userMemoryReservationInBytes;
    private final long revocableMemoryReservationInBytes;
    private final long systemMemoryReservationInBytes;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final long totalAllocationInBytes;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final Duration rawInputReadTime;
    private final long processedInputDataSizeInBytes;
    private final long processedInputPositions;
    private final long outputDataSizeInBytes;
    private final long outputPositions;
    private final long physicalWrittenDataSizeInBytes;
    private final List<OperatorStats> operatorStats;

    public DriverStats() {
        this.lifespan = null;
        this.createTimeInMillis = System.currentTimeMillis();
        this.startTimeInMillis = 0L;
        this.endTimeInMillis = 0L;
        this.queuedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.elapsedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.userMemoryReservationInBytes = 0L;
        this.revocableMemoryReservationInBytes = 0L;
        this.systemMemoryReservationInBytes = 0L;
        this.totalScheduledTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalCpuTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.totalBlockedTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.fullyBlocked = false;
        this.blockedReasons = ImmutableSet.of();
        this.totalAllocationInBytes = 0L;
        this.rawInputDataSizeInBytes = 0L;
        this.rawInputPositions = 0L;
        this.rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
        this.processedInputDataSizeInBytes = 0L;
        this.processedInputPositions = 0L;
        this.outputDataSizeInBytes = 0L;
        this.outputPositions = 0L;
        this.physicalWrittenDataSizeInBytes = 0L;
        this.operatorStats = ImmutableList.of();
    }

    @JsonCreator
    @ThriftConstructor
    public DriverStats(@JsonProperty(value="lifespan") Lifespan lifespan, @JsonProperty(value="createTimeInMillis") long createTimeInMillis, @JsonProperty(value="startTimeInMillis") long startTimeInMillis, @JsonProperty(value="endTimeInMillis") long endTimeInMillis, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="userMemoryReservationInBytes") long userMemoryReservationInBytes, @JsonProperty(value="revocableMemoryReservationInBytes") long revocableMemoryReservationInBytes, @JsonProperty(value="systemMemoryReservationInBytes") long systemMemoryReservationInBytes, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocationInBytes") long totalAllocationInBytes, @JsonProperty(value="rawInputDataSizeInBytes") long rawInputDataSizeInBytes, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="rawInputReadTime") Duration rawInputReadTime, @JsonProperty(value="processedInputDataSizeInBytes") long processedInputDataSizeInBytes, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSizeInBytes") long outputDataSizeInBytes, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="operatorStats") List<OperatorStats> operatorStats) {
        this.lifespan = lifespan;
        Preconditions.checkArgument((createTimeInMillis >= 0L ? 1 : 0) != 0, (Object)"createTimeInMillis is negative");
        this.createTimeInMillis = createTimeInMillis;
        this.startTimeInMillis = startTimeInMillis;
        this.endTimeInMillis = endTimeInMillis;
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        Preconditions.checkArgument((userMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"userMemoryReservationInBytes is negative");
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        Preconditions.checkArgument((revocableMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"revocableMemoryReservationInBytes is negative");
        this.revocableMemoryReservationInBytes = revocableMemoryReservationInBytes;
        Preconditions.checkArgument((systemMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"systemMemoryReservationInBytes is negative");
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        Preconditions.checkArgument((totalAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"totalAllocationInBytes is negative");
        this.totalAllocationInBytes = totalAllocationInBytes;
        Preconditions.checkArgument((rawInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"rawInputDataSizeInBytes is negative");
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.rawInputReadTime = Objects.requireNonNull(rawInputReadTime, "rawInputReadTime is null");
        Preconditions.checkArgument((processedInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"processedInputDataSizeInBytes is negative");
        this.processedInputDataSizeInBytes = processedInputDataSizeInBytes;
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSizeInBytes = outputDataSizeInBytes >= 0L ? outputDataSizeInBytes : Long.MAX_VALUE;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        Preconditions.checkArgument((physicalWrittenDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"writtenDataSizeInBytes is negative");
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        this.operatorStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorStats, "operatorStats is null"));
    }

    @JsonProperty
    @ThriftField(value=1)
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @JsonProperty
    @ThriftField(value=2)
    public long getCreateTimeInMillis() {
        return this.createTimeInMillis;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=3)
    public long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    @JsonProperty
    @ThriftField(value=4)
    public long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    @JsonProperty
    @ThriftField(value=5)
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    @ThriftField(value=6)
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    @ThriftField(value=7)
    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=8)
    public long getRevocableMemoryReservationInBytes() {
        return this.revocableMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=9)
    public long getSystemMemoryReservationInBytes() {
        return this.systemMemoryReservationInBytes;
    }

    @JsonProperty
    @ThriftField(value=10)
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    @ThriftField(value=11)
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    @ThriftField(value=12)
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    @ThriftField(value=13)
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    @ThriftField(value=14)
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    @ThriftField(value=15)
    public long getTotalAllocationInBytes() {
        return this.totalAllocationInBytes;
    }

    @JsonProperty
    @ThriftField(value=16)
    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=17)
    public Duration getRawInputReadTime() {
        return this.rawInputReadTime;
    }

    @JsonProperty
    @ThriftField(value=18)
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    @ThriftField(value=19)
    public long getProcessedInputDataSizeInBytes() {
        return this.processedInputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=20)
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    @ThriftField(value=21)
    public long getOutputDataSizeInBytes() {
        return this.outputDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=22)
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    @ThriftField(value=23)
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    @ThriftField(value=24)
    public List<OperatorStats> getOperatorStats() {
        return this.operatorStats;
    }
}

