/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.metadata.RemoteNodeState;
import com.facebook.presto.server.thrift.ThriftServerInfoClient;
import com.facebook.presto.spi.NodeState;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThriftRemoteNodeState
implements RemoteNodeState {
    private final ThriftServerInfoClient thriftClient;
    private final AtomicReference<Optional<NodeState>> nodeState = new AtomicReference(Optional.empty());
    private final AtomicBoolean requestInflight = new AtomicBoolean();
    private final AtomicLong lastUpdateNanos = new AtomicLong();

    public ThriftRemoteNodeState(DriftClient<ThriftServerInfoClient> thriftClient, URI stateInfoUri) {
        Objects.requireNonNull(stateInfoUri, "stateInfoUri is null");
        Preconditions.checkState((boolean)stateInfoUri.getScheme().equals("thrift"), (String)"unexpected scheme %s", (Object)stateInfoUri.getScheme());
        this.thriftClient = (ThriftServerInfoClient)Objects.requireNonNull(thriftClient, "thriftClient is null").get(Optional.of(stateInfoUri.getAuthority()));
    }

    @Override
    public Optional<NodeState> getNodeState() {
        return this.nodeState.get();
    }

    @Override
    public void asyncRefresh() {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (sinceUpdate.toMillis() > 1000L && this.requestInflight.compareAndSet(false, true)) {
            ListenableFuture<Integer> responseFuture = this.thriftClient.getServerState();
            Futures.addCallback(responseFuture, (FutureCallback)new FutureCallback<Integer>(){

                public void onSuccess(@Nullable Integer result) {
                    ThriftRemoteNodeState.this.lastUpdateNanos.set(System.nanoTime());
                    ThriftRemoteNodeState.this.requestInflight.compareAndSet(true, false);
                    if (result != null) {
                        ThriftRemoteNodeState.this.nodeState.set(Optional.of(NodeState.valueOf((int)result)));
                    }
                }

                public void onFailure(Throwable t) {
                    ThriftRemoteNodeState.this.lastUpdateNanos.set(System.nanoTime());
                    ThriftRemoteNodeState.this.requestInflight.compareAndSet(true, false);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

