/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.StaticTypeManagerStoreConfig;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class StaticTypeManagerStore {
    private static final Logger log = Logger.get(StaticTypeManagerStore.class);
    private static final String TYPE_MANAGER_NAME = "type-manager.name";
    private final FunctionAndTypeManager functionAndTypeManager;
    private final File configDir;
    private final AtomicBoolean typeManagersLoading = new AtomicBoolean();

    @Inject
    public StaticTypeManagerStore(FunctionAndTypeManager functionAndTypeManager, StaticTypeManagerStoreConfig config) {
        this.functionAndTypeManager = functionAndTypeManager;
        this.configDir = config.getTypeManagerConfigurationDir();
    }

    public void loadTypeManagers() throws Exception {
        if (!this.typeManagersLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : StaticTypeManagerStore.listFiles(this.configDir)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            String catalogName = Files.getNameWithoutExtension((String)file.getName());
            Map<String, String> properties = PropertiesUtil.loadProperties(file);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)properties.get(TYPE_MANAGER_NAME)) ? 1 : 0) != 0, (String)"Type manager configuration %s does not contain %s", (Object)file.getAbsoluteFile(), (Object)TYPE_MANAGER_NAME);
            this.loadTypeManager(catalogName, properties);
        }
    }

    public void loadTypeManagers(Map<String, Map<String, String>> catalogProperties) {
        catalogProperties.entrySet().stream().forEach(entry -> this.loadTypeManager((String)entry.getKey(), (Map)entry.getValue()));
    }

    private void loadTypeManager(String catalogName, Map<String, String> properties) {
        log.info("-- Loading %s type manager --", new Object[]{catalogName});
        properties = new HashMap<String, String>(properties);
        String typeManagerName = properties.remove(TYPE_MANAGER_NAME);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)typeManagerName) ? 1 : 0) != 0, (String)"%s property must be present", (Object)TYPE_MANAGER_NAME);
        this.functionAndTypeManager.loadTypeManager(typeManagerName);
        log.info("-- Added type manager [%s] --", new Object[]{catalogName});
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

