/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.StaticFunctionNamespaceStoreConfig;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class StaticFunctionNamespaceStore {
    private static final Logger log = Logger.get(StaticFunctionNamespaceStore.class);
    private static final String FUNCTION_NAMESPACE_MANAGER_NAME = "function-namespace-manager.name";
    private final FunctionAndTypeManager functionAndTypeManager;
    private final NodeManager nodeManager;
    private final File configDir;
    private final AtomicBoolean functionNamespaceLoading = new AtomicBoolean();

    @Inject
    public StaticFunctionNamespaceStore(FunctionAndTypeManager functionAndTypeManager, NodeManager nodeManager, StaticFunctionNamespaceStoreConfig config) {
        this.functionAndTypeManager = functionAndTypeManager;
        this.nodeManager = nodeManager;
        this.configDir = config.getFunctionNamespaceConfigurationDir();
    }

    public void loadFunctionNamespaceManagers() throws Exception {
        if (!this.functionNamespaceLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : StaticFunctionNamespaceStore.listFiles(this.configDir)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            String catalogName = Files.getNameWithoutExtension((String)file.getName());
            Map<String, String> properties = PropertiesUtil.loadProperties(file);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)properties.get(FUNCTION_NAMESPACE_MANAGER_NAME)) ? 1 : 0) != 0, (String)"Function namespace configuration %s does not contain %s", (Object)file.getAbsoluteFile(), (Object)FUNCTION_NAMESPACE_MANAGER_NAME);
            this.loadFunctionNamespaceManager(catalogName, properties);
        }
    }

    public void loadFunctionNamespaceManagers(Map<String, Map<String, String>> catalogProperties) {
        catalogProperties.entrySet().stream().forEach(entry -> this.loadFunctionNamespaceManager((String)entry.getKey(), (Map)entry.getValue()));
    }

    private void loadFunctionNamespaceManager(String catalogName, Map<String, String> properties) {
        log.info("-- Loading function namespace manager for catalog %s --", new Object[]{catalogName});
        properties = new HashMap<String, String>(properties);
        String functionNamespaceManagerName = properties.remove(FUNCTION_NAMESPACE_MANAGER_NAME);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)functionNamespaceManagerName) ? 1 : 0) != 0, (String)"%s property must be present", (Object)FUNCTION_NAMESPACE_MANAGER_NAME);
        this.functionAndTypeManager.loadFunctionNamespaceManager(functionNamespaceManagerName, catalogName, properties, this.nodeManager);
        log.info("-- Added function namespace manager [%s] --", new Object[]{catalogName});
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

