/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.metadata.StaticCatalogStoreConfig;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class StaticCatalogStore {
    private static final Logger log = Logger.get(StaticCatalogStore.class);
    private final ConnectorManager connectorManager;
    private final File catalogConfigurationDir;
    private final Set<String> disabledCatalogs;
    private final AtomicBoolean catalogsLoading = new AtomicBoolean();
    private final AtomicBoolean catalogsLoaded = new AtomicBoolean();

    @Inject
    public StaticCatalogStore(ConnectorManager connectorManager, StaticCatalogStoreConfig config) {
        this(connectorManager, config.getCatalogConfigurationDir(), (List)MoreObjects.firstNonNull(config.getDisabledCatalogs(), (Object)ImmutableList.of()));
    }

    public StaticCatalogStore(ConnectorManager connectorManager, File catalogConfigurationDir, List<String> disabledCatalogs) {
        this.connectorManager = connectorManager;
        this.catalogConfigurationDir = catalogConfigurationDir;
        this.disabledCatalogs = ImmutableSet.copyOf(disabledCatalogs);
    }

    public boolean areCatalogsLoaded() {
        return this.catalogsLoaded.get();
    }

    public void loadCatalogs() throws Exception {
        this.loadCatalogs((Map<String, Map<String, String>>)ImmutableMap.of());
    }

    public void loadCatalogs(Map<String, Map<String, String>> additionalCatalogs) throws Exception {
        if (!this.catalogsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : StaticCatalogStore.listFiles(this.catalogConfigurationDir)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            this.loadCatalog(file);
        }
        additionalCatalogs.forEach(this::loadCatalog);
        this.catalogsLoaded.set(true);
    }

    private void loadCatalog(File file) throws Exception {
        String catalogName = Files.getNameWithoutExtension((String)file.getName());
        log.info("-- Loading catalog properties %s --", new Object[]{file});
        Map<String, String> properties = PropertiesUtil.loadProperties(file);
        Preconditions.checkState((boolean)properties.containsKey("connector.name"), (String)"Catalog configuration %s does not contain connector.name", (Object)file.getAbsoluteFile());
        this.loadCatalog(catalogName, properties);
    }

    private void loadCatalog(String catalogName, Map<String, String> properties) {
        if (this.disabledCatalogs.contains(catalogName)) {
            log.info("Skipping disabled catalog %s", new Object[]{catalogName});
            return;
        }
        log.info("-- Loading catalog %s --", new Object[]{catalogName});
        String connectorName = null;
        ImmutableMap.Builder connectorProperties = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().equals("connector.name")) {
                connectorName = entry.getValue();
                continue;
            }
            connectorProperties.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        Preconditions.checkState((connectorName != null ? 1 : 0) != 0, (String)"Configuration for catalog %s does not contain connector.name", (Object)catalogName);
        this.connectorManager.createConnection(catalogName, connectorName, (Map<String, String>)connectorProperties.build());
        log.info("-- Added catalog %s using connector %s --", new Object[]{catalogName, connectorName});
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

