/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyProviderConfig;
import com.facebook.presto.sessionpropertyproviders.JavaWorkerSessionPropertyProvider;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.session.SessionPropertyContext;
import com.facebook.presto.spi.session.WorkerSessionPropertyProvider;
import com.facebook.presto.spi.session.WorkerSessionPropertyProviderFactory;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.JavaFeaturesConfig;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class SessionPropertyManager {
    private static final JsonCodecFactory JSON_CODEC_FACTORY = new JsonCodecFactory();
    private static final Logger log = Logger.get(SessionPropertyManager.class);
    private static final String SESSION_PROPERTY_PROVIDER_NAME = "session-property-provider.name";
    private final ConcurrentMap<String, PropertyMetadata<?>> systemSessionProperties = new ConcurrentHashMap();
    private final ConcurrentMap<ConnectorId, Map<String, PropertyMetadata<?>>> connectorSessionProperties = new ConcurrentHashMap();
    private final Map<String, WorkerSessionPropertyProvider> workerSessionPropertyProviders;
    private final Map<String, WorkerSessionPropertyProviderFactory> workerSessionPropertyProviderFactories = new ConcurrentHashMap<String, WorkerSessionPropertyProviderFactory>();
    private final Supplier<Map<String, PropertyMetadata<?>>> memoizedWorkerSessionProperties;
    private final Optional<NodeManager> nodeManager;
    private final Optional<TypeManager> functionAndTypeManager;
    private final File configDir;
    private final AtomicBoolean sessionPropertyProvidersLoading = new AtomicBoolean();

    @Inject
    public SessionPropertyManager(SystemSessionProperties systemSessionProperties, Map<String, WorkerSessionPropertyProvider> workerSessionPropertyProviders, FunctionAndTypeManager functionAndTypeManager, NodeManager nodeManager, SessionPropertyProviderConfig config) {
        this(systemSessionProperties.getSessionProperties(), workerSessionPropertyProviders, Optional.ofNullable(functionAndTypeManager), Optional.ofNullable(nodeManager), config);
    }

    public SessionPropertyManager(List<PropertyMetadata<?>> sessionProperties, Map<String, WorkerSessionPropertyProvider> workerSessionPropertyProviders, Optional<TypeManager> functionAndTypeManager, Optional<NodeManager> nodeManager, SessionPropertyProviderConfig config) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.memoizedWorkerSessionProperties = Suppliers.memoizeWithExpiration(this::getWorkerSessionProperties, (long)1L, (TimeUnit)TimeUnit.HOURS);
        this.workerSessionPropertyProviders = new ConcurrentHashMap<String, WorkerSessionPropertyProvider>(workerSessionPropertyProviders);
        this.configDir = Objects.requireNonNull(config, "config is null").getSessionPropertyProvidersConfigurationDir();
        this.addSystemSessionProperties(sessionProperties);
    }

    public static SessionPropertyManager createTestingSessionPropertyManager() {
        return SessionPropertyManager.createTestingSessionPropertyManager(new SystemSessionProperties().getSessionProperties(), new JavaFeaturesConfig(), new NodeSpillConfig());
    }

    public static SessionPropertyManager createTestingSessionPropertyManager(SystemSessionProperties systemSessionProperties) {
        return SessionPropertyManager.createTestingSessionPropertyManager(systemSessionProperties.getSessionProperties(), new JavaFeaturesConfig(), new NodeSpillConfig());
    }

    public static SessionPropertyManager createTestingSessionPropertyManager(List<PropertyMetadata<?>> sessionProperties) {
        return SessionPropertyManager.createTestingSessionPropertyManager(sessionProperties, new JavaFeaturesConfig(), new NodeSpillConfig());
    }

    public static SessionPropertyManager createTestingSessionPropertyManager(List<PropertyMetadata<?>> sessionProperties, JavaFeaturesConfig javaFeaturesConfig, NodeSpillConfig nodeSpillConfig) {
        return new SessionPropertyManager(sessionProperties, (Map<String, WorkerSessionPropertyProvider>)ImmutableMap.of((Object)"java-worker", (Object)new JavaWorkerSessionPropertyProvider(new FeaturesConfig(), javaFeaturesConfig, nodeSpillConfig)), Optional.empty(), Optional.empty(), new SessionPropertyProviderConfig());
    }

    public void loadSessionPropertyProviders() throws Exception {
        if (!this.sessionPropertyProvidersLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : SessionPropertyManager.listFiles(this.configDir)) {
            if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
            String sessionPropertyProviderName = Files.getNameWithoutExtension((String)file.getName());
            Map<String, String> properties = PropertiesUtil.loadProperties(file);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)properties.get(SESSION_PROPERTY_PROVIDER_NAME)) ? 1 : 0) != 0, (String)"Session property manager configuration %s does not contain %s", (Object)file.getAbsoluteFile(), (Object)SESSION_PROPERTY_PROVIDER_NAME);
            properties = new HashMap<String, String>(properties);
            properties.remove(SESSION_PROPERTY_PROVIDER_NAME);
            this.loadSessionPropertyProvider(sessionPropertyProviderName, properties, this.functionAndTypeManager, this.nodeManager);
        }
    }

    public void loadSessionPropertyProvider(String sessionPropertyProviderName, Map<String, String> properties, Optional<TypeManager> typeManager, Optional<NodeManager> nodeManager) {
        log.info("-- Loading %s session property provider --", new Object[]{sessionPropertyProviderName});
        WorkerSessionPropertyProviderFactory factory = this.workerSessionPropertyProviderFactories.get(sessionPropertyProviderName);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (Object)("No factory for session property provider : " + sessionPropertyProviderName));
        WorkerSessionPropertyProvider sessionPropertyProvider = factory.create(new SessionPropertyContext(typeManager, nodeManager), properties);
        if (this.workerSessionPropertyProviders.putIfAbsent(sessionPropertyProviderName, sessionPropertyProvider) != null) {
            throw new IllegalArgumentException("System session property provider is already registered for property provider : " + sessionPropertyProviderName);
        }
        log.info("-- Added session property provider [%s] --", new Object[]{sessionPropertyProviderName});
    }

    @VisibleForTesting
    public Map<String, WorkerSessionPropertyProvider> getWorkerSessionPropertyProviders() {
        return ImmutableMap.copyOf(this.workerSessionPropertyProviders);
    }

    public void addSessionPropertyProviderFactory(WorkerSessionPropertyProviderFactory factory) {
        if (this.workerSessionPropertyProviderFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("System Session property provider factory" + factory.getName() + "is already registered", new Object[0]));
        }
    }

    public void addSystemSessionProperties(List<PropertyMetadata<?>> systemSessionProperties) {
        systemSessionProperties.forEach(this::addSystemSessionProperty);
    }

    public void addSystemSessionProperty(PropertyMetadata<?> sessionProperty) {
        Objects.requireNonNull(sessionProperty, "sessionProperty is null");
        Preconditions.checkState((this.systemSessionProperties.put(sessionProperty.getName(), sessionProperty) == null ? 1 : 0) != 0, (String)"System session property '%s' are already registered", (Object)sessionProperty.getName());
    }

    public void addConnectorSessionProperties(ConnectorId connectorId, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(properties, "properties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Preconditions.checkState((this.connectorSessionProperties.putIfAbsent(connectorId, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Session properties for connectorId '%s' are already registered", (Object)connectorId);
    }

    public void removeConnectorSessionProperties(ConnectorId connectorId) {
        this.connectorSessionProperties.remove(connectorId);
    }

    public Optional<PropertyMetadata<?>> getSystemSessionPropertyMetadata(String name) {
        Objects.requireNonNull(name, "name is null");
        if (this.systemSessionProperties.get(name) == null) {
            return Optional.ofNullable(this.memoizedWorkerSessionProperties.get().get(name));
        }
        return Optional.ofNullable((PropertyMetadata)this.systemSessionProperties.get(name));
    }

    public Optional<PropertyMetadata<?>> getConnectorSessionPropertyMetadata(ConnectorId connectorId, String propertyName) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        Map properties = (Map)this.connectorSessionProperties.get(connectorId);
        if (properties == null || properties.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown connector " + connectorId);
        }
        return Optional.ofNullable((PropertyMetadata)properties.get(propertyName));
    }

    private Map<String, PropertyMetadata<?>> getWorkerSessionProperties() {
        List workerSessionPropertiesList = (List)this.workerSessionPropertyProviders.values().stream().flatMap(manager -> manager.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
        ConcurrentHashMap workerSessionProperties = new ConcurrentHashMap();
        workerSessionPropertiesList.forEach(sessionProperty -> {
            Objects.requireNonNull(sessionProperty, "sessionProperty is null");
            workerSessionProperties.put(sessionProperty.getName(), (PropertyMetadata<?>)sessionProperty);
        });
        return workerSessionProperties;
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    public List<SessionPropertyValue> getAllSessionProperties(Session session, Map<String, ConnectorId> catalogs) {
        String value;
        String defaultValue;
        Objects.requireNonNull(session, "session is null");
        ImmutableList.Builder sessionPropertyValues = ImmutableList.builder();
        Map<String, String> systemProperties = session.getSystemProperties();
        for (PropertyMetadata<?> propertyMetadata : new TreeMap(this.systemSessionProperties).values()) {
            defaultValue = MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString();
            value = systemProperties.getOrDefault(propertyMetadata.getName(), defaultValue);
            sessionPropertyValues.add((Object)new SessionPropertyValue(value, defaultValue, propertyMetadata.getName(), Optional.empty(), propertyMetadata.getName(), propertyMetadata.getDescription(), propertyMetadata.getSqlType().getDisplayName(), propertyMetadata.isHidden()));
        }
        for (Map.Entry entry : new TreeMap<String, ConnectorId>(catalogs).entrySet()) {
            String catalog = (String)entry.getKey();
            ConnectorId connectorId = (ConnectorId)entry.getValue();
            Map<String, String> connectorProperties = session.getConnectorProperties(connectorId);
            for (PropertyMetadata property : new TreeMap((Map)this.connectorSessionProperties.get(connectorId)).values()) {
                String defaultValue2 = MoreObjects.firstNonNull((Object)property.getDefaultValue(), (Object)"").toString();
                String value2 = connectorProperties.getOrDefault(property.getName(), defaultValue2);
                sessionPropertyValues.add((Object)new SessionPropertyValue(value2, defaultValue2, catalog + "." + property.getName(), Optional.of(catalog), property.getName(), property.getDescription(), property.getSqlType().getDisplayName(), property.isHidden()));
            }
        }
        for (PropertyMetadata propertyMetadata : new TreeMap(this.memoizedWorkerSessionProperties.get()).values()) {
            defaultValue = MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString();
            value = systemProperties.getOrDefault(propertyMetadata.getName(), defaultValue);
            sessionPropertyValues.add((Object)new SessionPropertyValue(value, defaultValue, propertyMetadata.getName(), Optional.empty(), propertyMetadata.getName(), propertyMetadata.getDescription(), propertyMetadata.getSqlType().getDisplayName(), propertyMetadata.isHidden()));
        }
        return sessionPropertyValues.build();
    }

    public <T> T decodeSystemPropertyValue(String name, @Nullable String value, Class<T> type) {
        PropertyMetadata<?> property = this.getSystemSessionPropertyMetadata(name).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name));
        return SessionPropertyManager.decodePropertyValue(name, value, type, property);
    }

    public <T> T decodeCatalogPropertyValue(ConnectorId connectorId, String catalogName, String propertyName, @Nullable String propertyValue, Class<T> type) {
        String fullPropertyName = catalogName + "." + propertyName;
        PropertyMetadata<?> property = this.getConnectorSessionPropertyMetadata(connectorId, propertyName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + fullPropertyName));
        return SessionPropertyManager.decodePropertyValue(fullPropertyName, propertyValue, type, property);
    }

    public void validateSystemSessionProperty(String propertyName, String propertyValue) {
        PropertyMetadata<?> propertyMetadata = this.getSystemSessionPropertyMetadata(propertyName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + propertyName));
        SessionPropertyManager.decodePropertyValue(propertyName, propertyValue, propertyMetadata.getJavaType(), propertyMetadata);
    }

    public void validateCatalogSessionProperty(ConnectorId connectorId, String catalogName, String propertyName, String propertyValue) {
        String fullPropertyName = catalogName + "." + propertyName;
        PropertyMetadata<?> propertyMetadata = this.getConnectorSessionPropertyMetadata(connectorId, propertyName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + fullPropertyName));
        SessionPropertyManager.decodePropertyValue(fullPropertyName, propertyValue, propertyMetadata.getJavaType(), propertyMetadata);
    }

    private static <T> T decodePropertyValue(String fullPropertyName, @Nullable String propertyValue, Class<T> type, PropertyMetadata<?> metadata) {
        if (metadata.getJavaType() != type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Property %s is type %s, but requested type was %s", fullPropertyName, metadata.getJavaType().getName(), type.getName()));
        }
        if (propertyValue == null) {
            return type.cast(metadata.getDefaultValue());
        }
        try {
            Object objectValue = SessionPropertyManager.deserializeSessionProperty(metadata.getSqlType(), propertyValue);
            return type.cast(metadata.decode(objectValue));
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s is invalid: %s", fullPropertyName, propertyValue), (Throwable)e);
        }
    }

    public static Object evaluatePropertyValue(Expression expression, Type expectedType, Session session, Metadata metadata, Map<NodeRef<Parameter>, Expression> parameters) {
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
        Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, metadata, session, parameters);
        BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
        Object objectValue = expectedType.getObjectValue(session.getSqlFunctionProperties(), (Block)blockBuilder, 0);
        if (objectValue == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property value must not be null");
        }
        return objectValue;
    }

    public static String serializeSessionProperty(Type type, Object value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property can not be null");
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return value.toString();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return value.toString();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return value.toString();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return value.toString();
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value.toString();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return value.toString();
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).toJson(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Object deserializeSessionProperty(Type type, String value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property can not be null");
        }
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return value;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.valueOf(value);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.valueOf(value);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Integer.valueOf(value);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.valueOf(value);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return Byte.valueOf(value);
        }
        if (type instanceof ArrayType || type instanceof MapType) {
            return SessionPropertyManager.getJsonCodecForType(type).fromJson(value);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static <T> JsonCodec<T> getJsonCodecForType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(String.class);
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Boolean.class);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Long.class);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Integer.class);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Double.class);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return JSON_CODEC_FACTORY.jsonCodec(Byte.class);
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            return JSON_CODEC_FACTORY.listJsonCodec(SessionPropertyManager.getJsonCodecForType(elementType));
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            return JSON_CODEC_FACTORY.mapJsonCodec(SessionPropertyManager.getMapKeyType(keyType), SessionPropertyManager.getJsonCodecForType(valueType));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property type %s is not supported", type));
    }

    private static Class<?> getMapKeyType(Type type) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return String.class;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Boolean.class;
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return Long.class;
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Integer.class;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.class;
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return Byte.class;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Session property map key type %s is not supported", type));
    }

    public static class SessionPropertyValue {
        private final String fullyQualifiedName;
        private final Optional<String> catalogName;
        private final String propertyName;
        private final String description;
        private final String type;
        private final String value;
        private final String defaultValue;
        private final boolean hidden;

        private SessionPropertyValue(String value, String defaultValue, String fullyQualifiedName, Optional<String> catalogName, String propertyName, String description, String type, boolean hidden) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.catalogName = catalogName;
            this.propertyName = propertyName;
            this.description = description;
            this.type = type;
            this.value = value;
            this.defaultValue = defaultValue;
            this.hidden = hidden;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Optional<String> getCatalogName() {
            return this.catalogName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }
}

