/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class QualifiedTablePrefix {
    private final String catalogName;
    private final Optional<String> schemaName;
    private final Optional<String> tableName;

    public QualifiedTablePrefix(String catalogName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.empty();
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String catalogName, String schemaName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.of(schemaName);
        this.tableName = Optional.empty();
    }

    public QualifiedTablePrefix(String catalogName, String schemaName, String tableName) {
        this.catalogName = MetadataUtil.checkCatalogName(catalogName);
        this.schemaName = Optional.of(schemaName);
        this.tableName = Optional.of(tableName);
    }

    @JsonCreator
    @ThriftConstructor
    public QualifiedTablePrefix(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") Optional<String> schemaName, @JsonProperty(value="tableName") Optional<String> tableName) {
        MetadataUtil.checkCatalogName(catalogName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public static QualifiedTablePrefix toQualifiedTablePrefix(QualifiedObjectName qualifiedObjectName) {
        return new QualifiedTablePrefix(qualifiedObjectName.getCatalogName(), qualifiedObjectName.getSchemaName(), qualifiedObjectName.getObjectName());
    }

    @JsonProperty
    @ThriftField(value=1)
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @ThriftField(value=2)
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    @ThriftField(value=3)
    public Optional<String> getTableName() {
        return this.tableName;
    }

    public boolean hasSchemaName() {
        return this.schemaName.isPresent();
    }

    public boolean hasTableName() {
        return this.tableName.isPresent();
    }

    public SchemaTablePrefix asSchemaTablePrefix() {
        if (!this.schemaName.isPresent()) {
            return new SchemaTablePrefix();
        }
        if (!this.tableName.isPresent()) {
            return new SchemaTablePrefix(this.schemaName.get());
        }
        return new SchemaTablePrefix(this.schemaName.get(), this.tableName.get());
    }

    public boolean matches(QualifiedObjectName objectName) {
        return Objects.equals(this.catalogName, objectName.getCatalogName()) && this.schemaName.map(schema -> Objects.equals(schema, objectName.getSchemaName())).orElse(true) != false && this.tableName.map(table -> Objects.equals(table, objectName.getObjectName())).orElse(true) != false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedTablePrefix o = (QualifiedTablePrefix)obj;
        return Objects.equals(this.catalogName, o.catalogName) && Objects.equals(this.schemaName, o.schemaName) && Objects.equals(this.tableName, o.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }

    public String toString() {
        return this.catalogName + '.' + this.schemaName.orElse("*") + '.' + this.tableName.orElse("*");
    }
}

