/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorTableVersion;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.GrantorSpecification;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.PrincipalSpecification;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MetadataUtil {
    public static final String likeTableCatalogError = "LIKE table catalog '%s' does not exist";
    public static final String catalogError = "Catalog %s does not exist";
    public static final String targetTableCatalogError = "Target catalog '%s' does not exist";

    private MetadataUtil() {
    }

    public static String checkCatalogName(String catalogName) {
        return MetadataUtil.checkLowerCase(catalogName, "catalogName");
    }

    public static SchemaTableName toSchemaTableName(QualifiedObjectName qualifiedObjectName) {
        return new SchemaTableName(qualifiedObjectName.getSchemaName(), qualifiedObjectName.getObjectName());
    }

    public static SchemaTableName toSchemaTableName(String schemaName, String tableName) {
        if (schemaName.equalsIgnoreCase("information_schema")) {
            return new SchemaTableName(schemaName.toLowerCase(Locale.ENGLISH), tableName.toLowerCase(Locale.ENGLISH));
        }
        return new SchemaTableName(schemaName, tableName);
    }

    public static ConnectorId getConnectorIdOrThrow(Session session, Metadata metadata, String catalogName) {
        return metadata.getCatalogHandle(session, catalogName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, "Catalog does not exist: " + catalogName, new Object[0]));
    }

    public static ConnectorId getConnectorIdOrThrow(Session session, Metadata metadata, String catalogName, Statement statement, String errorMsg) {
        return metadata.getCatalogHandle(session, catalogName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, errorMsg, new Object[]{catalogName}));
    }

    public static String checkLowerCase(String value, String name) {
        if (value == null) {
            throw new NullPointerException(String.format("%s is null", name));
        }
        Preconditions.checkArgument((boolean)value.equals(value.toLowerCase(Locale.ENGLISH)), (String)"%s is not lowercase: %s", (Object)name, (Object)value);
        return value;
    }

    public static ColumnMetadata findColumnMetadata(ConnectorTableMetadata tableMetadata, String columnName) {
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            if (!columnName.equals(columnMetadata.getName())) continue;
            return columnMetadata;
        }
        return null;
    }

    public static String createCatalogName(Session session, Node node) {
        Optional<String> sessionCatalog = session.getCatalog();
        if (!sessionCatalog.isPresent()) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Session catalog must be set", new Object[0]);
        }
        return sessionCatalog.get();
    }

    public static CatalogSchemaName createCatalogSchemaName(Session session, Node node, Optional<QualifiedName> schema, Metadata metadata) {
        String catalogName = session.getCatalog().orElse(null);
        String schemaName = session.getSchema().orElse(null);
        if (schema.isPresent()) {
            List parts = schema.get().getOriginalParts();
            if (parts.size() > 2) {
                throw new SemanticException(SemanticErrorCode.INVALID_SCHEMA_NAME, node, "Too many parts in schema name: %s", new Object[]{schema.get()});
            }
            if (parts.size() == 2) {
                catalogName = (String)parts.get(0);
            }
            if (catalogName == null) {
                throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]);
            }
            schemaName = metadata.normalizeIdentifier(session, catalogName, schema.get().getOriginalSuffix());
        }
        if (catalogName == null) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]);
        }
        if (schemaName == null) {
            throw new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, node, "Schema must be specified when session schema is not set", new Object[0]);
        }
        return new CatalogSchemaName(catalogName, schemaName);
    }

    public static QualifiedObjectName createQualifiedObjectName(Session session, Node node, QualifiedName name, Metadata metadata) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(name, "name is null");
        if (name.getOriginalParts().size() > 3) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, String.format("Too many dots in table name: %s", name));
        }
        List parts = Lists.reverse((List)name.getOriginalParts());
        String objectName = (String)parts.get(0);
        String schemaName = parts.size() > 1 ? (String)parts.get(1) : session.getSchema().orElseThrow(() -> new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, node, "Schema must be specified when session schema is not set", new Object[0]));
        String catalogName = parts.size() > 2 ? (String)parts.get(2) : session.getCatalog().orElseThrow(() -> new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]));
        catalogName = catalogName.toLowerCase(Locale.ENGLISH);
        schemaName = metadata.normalizeIdentifier(session, catalogName, schemaName);
        objectName = metadata.normalizeIdentifier(session, catalogName, objectName);
        return new QualifiedObjectName(catalogName, schemaName, objectName);
    }

    public static QualifiedName createQualifiedName(QualifiedObjectName name) {
        return QualifiedName.of((String)name.getCatalogName(), (String[])new String[]{name.getSchemaName(), name.getObjectName()});
    }

    public static Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, TransactionManager transactionManager, String catalogName) {
        return transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
    }

    public static Optional<TableHandle> getOptionalTableHandle(Session session, TransactionManager transactionManager, QualifiedObjectName table, Optional<ConnectorTableVersion> tableVersion) {
        ConnectorId connectorId;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = MetadataUtil.getOptionalCatalogMetadata(session, transactionManager, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = tableVersion.map(arg_0 -> MetadataUtil.lambda$getOptionalTableHandle$4(metadata = (catalogMetadata = catalog.get()).getMetadataFor(connectorId = catalogMetadata.getConnectorId(session, table)), session, connectorId, table, arg_0)).orElseGet(() -> metadata.getTableHandle(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(table)))) != null) {
            return Optional.of(new TableHandle(connectorId, tableHandle, catalogMetadata.getTransactionHandleFor(connectorId), Optional.empty()));
        }
        return Optional.empty();
    }

    public static PrestoPrincipal createPrincipal(Session session, GrantorSpecification specification) {
        GrantorSpecification.Type type = specification.getType();
        switch (type) {
            case PRINCIPAL: {
                return MetadataUtil.createPrincipal((PrincipalSpecification)specification.getPrincipal().get());
            }
            case CURRENT_USER: {
                return new PrestoPrincipal(PrincipalType.USER, session.getIdentity().getUser());
            }
            case CURRENT_ROLE: {
                throw new UnsupportedOperationException("CURRENT_ROLE is not yet supported");
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static PrestoPrincipal createPrincipal(PrincipalSpecification specification) {
        PrincipalSpecification.Type type = specification.getType();
        switch (type) {
            case UNSPECIFIED: 
            case USER: {
                return new PrestoPrincipal(PrincipalType.USER, specification.getName().getValue());
            }
            case ROLE: {
                return new PrestoPrincipal(PrincipalType.ROLE, specification.getName().getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static boolean tableExists(Metadata metadata, Session session, String table) {
        if (!session.getCatalog().isPresent() || !session.getSchema().isPresent()) {
            return false;
        }
        QualifiedObjectName name = new QualifiedObjectName(session.getCatalog().get(), session.getSchema().get(), table);
        return metadata.getMetadataResolver(session).getTableHandle(name).isPresent();
    }

    private static /* synthetic */ ConnectorTableHandle lambda$getOptionalTableHandle$4(ConnectorMetadata metadata, Session session, ConnectorId connectorId, QualifiedObjectName table, ConnectorTableVersion expression) {
        return metadata.getTableHandle(session.toConnectorSession(connectorId), MetadataUtil.toSchemaTableName(table), Optional.of(expression));
    }

    public static class TableMetadataBuilder {
        private final SchemaTableName tableName;
        private final ImmutableList.Builder<ColumnMetadata> columns = ImmutableList.builder();
        private final ImmutableMap.Builder<String, Object> properties = ImmutableMap.builder();
        private final Optional<String> comment;

        public static TableMetadataBuilder tableMetadataBuilder(String schemaName, String tableName) {
            return new TableMetadataBuilder(new SchemaTableName(schemaName, tableName));
        }

        public static TableMetadataBuilder tableMetadataBuilder(SchemaTableName tableName) {
            return new TableMetadataBuilder(tableName);
        }

        private TableMetadataBuilder(SchemaTableName tableName) {
            this(tableName, Optional.empty());
        }

        private TableMetadataBuilder(SchemaTableName tableName, Optional<String> comment) {
            this.tableName = tableName;
            this.comment = comment;
        }

        public TableMetadataBuilder column(String columnName, Type type) {
            this.columns.add((Object)ColumnMetadata.builder().setName(columnName).setType(type).build());
            return this;
        }

        public TableMetadataBuilder property(String name, Object value) {
            this.properties.put((Object)name, value);
            return this;
        }

        public ConnectorTableMetadata build() {
            return new ConnectorTableMetadata(this.tableName, (List)this.columns.build(), (Map)this.properties.build(), this.comment);
        }
    }

    public static class SchemaMetadataBuilder {
        private final ImmutableMap.Builder<SchemaTableName, ConnectorTableMetadata> tables = ImmutableMap.builder();

        public static SchemaMetadataBuilder schemaMetadataBuilder() {
            return new SchemaMetadataBuilder();
        }

        public SchemaMetadataBuilder table(ConnectorTableMetadata tableMetadata) {
            this.tables.put((Object)tableMetadata.getTable(), (Object)tableMetadata);
            return this;
        }

        public ImmutableMap<SchemaTableName, ConnectorTableMetadata> build() {
            return this.tables.build();
        }
    }
}

