/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.FunctionInvoker;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class FunctionInvokerProvider {
    private final FunctionAndTypeManager functionAndTypeManager;

    public FunctionInvokerProvider(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = functionAndTypeManager;
    }

    public FunctionInvoker createFunctionInvoker(FunctionHandle functionHandle, Optional<InvocationConvention> invocationConvention) {
        JavaScalarFunctionImplementation functionImplementation = this.functionAndTypeManager.getJavaScalarFunctionImplementation(functionHandle);
        for (ScalarFunctionImplementationChoice choice : BytecodeUtils.getAllScalarFunctionImplementationChoices(functionImplementation)) {
            if (!FunctionInvokerProvider.checkChoice(choice.getArgumentProperties(), choice.isNullable(), choice.hasProperties(), invocationConvention)) continue;
            return new FunctionInvoker(choice.getMethodHandle());
        }
        Preconditions.checkState((boolean)invocationConvention.isPresent());
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Dependent function implementation (%s) with convention (%s) is not available", functionHandle, invocationConvention.toString()));
    }

    @VisibleForTesting
    static boolean checkChoice(List<ScalarFunctionImplementationChoice.ArgumentProperty> definitionArgumentProperties, boolean definitionReturnsNullable, boolean definitionHasSession, Optional<InvocationConvention> invocationConvention) {
        for (int i = 0; i < definitionArgumentProperties.size(); ++i) {
            InvocationConvention.InvocationArgumentConvention invocationArgumentConvention = invocationConvention.get().getArgumentConvention(i);
            ScalarFunctionImplementationChoice.NullConvention nullConvention = definitionArgumentProperties.get(i).getNullConvention();
            if (definitionArgumentProperties.get(i).getArgumentType() == ScalarFunctionImplementationChoice.ArgumentType.FUNCTION_TYPE) {
                if (invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.FUNCTION) {
                    return false;
                }
                throw new UnsupportedOperationException("Invocation convention for function type is not supported");
            }
            if (nullConvention == ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL && invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                return false;
            }
            if (nullConvention == ScalarFunctionImplementationChoice.NullConvention.USE_BOXED_TYPE && invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                return false;
            }
            if (nullConvention == ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG && invocationArgumentConvention != InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                return false;
            }
            if (nullConvention != ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION || invocationArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
            return false;
        }
        if (definitionReturnsNullable && invocationConvention.get().getReturnConvention() != InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN) {
            return false;
        }
        if (!definitionReturnsNullable && invocationConvention.get().getReturnConvention() != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            return false;
        }
        return definitionHasSession == invocationConvention.get().hasSession();
    }
}

