/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdater;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdaterProvider;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectorMetadataUpdaterManager {
    private final Map<ConnectorId, ConnectorMetadataUpdaterProvider> metadataUpdaterProviderMap = new ConcurrentHashMap<ConnectorId, ConnectorMetadataUpdaterProvider>();

    @Inject
    public ConnectorMetadataUpdaterManager() {
    }

    public void addMetadataUpdaterProvider(ConnectorId connectorId, ConnectorMetadataUpdaterProvider metadataUpdaterProvider) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(metadataUpdaterProvider, "metadataUpdaterProvider is null");
        Preconditions.checkArgument((this.metadataUpdaterProviderMap.putIfAbsent(connectorId, metadataUpdaterProvider) == null ? 1 : 0) != 0, (String)"ConnectorMetadataUpdaterProvider for connector '%s' is already registered", (Object)connectorId);
    }

    public void removeMetadataUpdaterProvider(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        this.metadataUpdaterProviderMap.remove(connectorId);
    }

    public Optional<ConnectorMetadataUpdater> getMetadataUpdater(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        return Optional.ofNullable(this.metadataUpdaterProviderMap.get(connectorId)).map(ConnectorMetadataUpdaterProvider::getMetadataUpdater);
    }
}

