/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class BuiltInFunctionHandle
implements FunctionHandle {
    private final Signature signature;

    @JsonCreator
    public BuiltInFunctionHandle(@JsonProperty(value="signature") Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        BuiltInFunctionHandle.checkArgument(signature.getTypeVariableConstraints().isEmpty(), "%s has unbound type parameters", signature);
    }

    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.signature.getName().toString();
    }

    public FunctionKind getKind() {
        return this.signature.getKind();
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.signature.getArgumentTypes();
    }

    public CatalogSchemaName getCatalogSchemaName() {
        return this.signature.getName().getCatalogSchemaName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuiltInFunctionHandle that = (BuiltInFunctionHandle)o;
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }

    public String toString() {
        return this.signature.toString();
    }

    private static void checkArgument(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }
}

